/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wcs20.GetCoverageType;
import net.opengis.wcs20.ScalingType;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs2_0.GetCoverage;
import org.geoserver.wcs2_0.GridCoverageRequest;
import org.geoserver.wcs2_0.WCSTestSupport;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.WCS20GetCoverageRequestReader;
import org.geoserver.wcs2_0.response.MIMETypeMapper;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GetCoverageTest
extends WCSTestSupport {
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);
    private GridCoverage2DReader coverageReader;
    private AffineTransform2D originalMathTransform;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addRasterLayer(TIMESERIES, "timeseries.zip", null, this.getCatalog());
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
    }

    @Before
    public void getRainReader() throws IOException {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(RAIN));
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        this.originalMathTransform = (AffineTransform2D)this.coverageReader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
    }

    @Test
    public void testAllowSubsamplingOnScaleFactor() throws Exception {
        Map<String, String> raw = this.setupGetCoverageRain();
        raw.put("scalefactor", "0.5");
        this.assertScalingByHalf(raw);
    }

    @Test
    public void testAllowSubsamplingOnScaleExtent() throws Exception {
        GridEnvelope range = this.coverageReader.getOriginalGridRange();
        int width = range.getSpan(0);
        int height = range.getSpan(1);
        Map<String, String> raw = this.setupGetCoverageRain();
        raw.put("scaleextent", "i(0," + width / 2 + "),j(0," + height / 2 + ")");
        this.assertScalingByHalf(raw);
    }

    @Test
    public void getNearestTime() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMESERIES));
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType gc = this.parse("wcs?request=GetCoverage&service=WCS&version=2.0.1&coverageId=timeseries&subset=time(\"2019-01-03T00:00:00Z\")");
        this.coverageReader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        boolean hasCoverage = true;
        GridCoverage gridCoverage = null;
        try {
            gridCoverage = getCoverage.run(gc);
        }
        catch (WCS20Exception e) {
            hasCoverage = false;
            Assert.assertTrue((boolean)e.getMessage().contains("Requested time subset does not intersect"));
            Assert.assertEquals((long)404L, (long)e.getHttpCode().intValue());
        }
        Assert.assertFalse((boolean)hasCoverage);
        this.setupNearestMatch(TIMESERIES, "time", true, "P5D", true);
        getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper);
        try {
            gridCoverage = getCoverage.run(gc);
            hasCoverage = true;
        }
        catch (WCS20Exception e) {
            hasCoverage = false;
        }
        Assert.assertNotNull((Object)gridCoverage);
        Assert.assertTrue((boolean)hasCoverage);
        this.scheduleForCleaning(gridCoverage);
    }

    protected GetCoverageType parse(String url) throws Exception {
        CaseInsensitiveMap rawKvp = new CaseInsensitiveMap(KvpUtils.parseQueryString((String)url));
        CaseInsensitiveMap kvp = new CaseInsensitiveMap(this.parseKvp((Map)rawKvp));
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType gc = (GetCoverageType)reader.createRequest();
        return (GetCoverageType)reader.read((Object)gc, (Map)kvp, (Map)rawKvp);
    }

    private void assertScalingByHalf(Map<String, String> raw) throws Exception {
        Map kvp = this.parseKvp(raw);
        WCS20GetCoverageRequestReader reader = new WCS20GetCoverageRequestReader();
        GetCoverageType getCoverageRequest = (GetCoverageType)reader.read(reader.createRequest(), kvp, raw);
        WCSInfo service = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        EnvelopeAxesLabelsMapper axesMapper = (EnvelopeAxesLabelsMapper)GeoServerExtensions.bean(EnvelopeAxesLabelsMapper.class);
        MIMETypeMapper mimeMapper = (MIMETypeMapper)GeoServerExtensions.bean(MIMETypeMapper.class);
        GetCoverage getCoverage = new GetCoverage(service, this.getCatalog(), axesMapper, mimeMapper){

            MathTransform getMathTransform(GridCoverage2DReader reader, Envelope subset, GridCoverageRequest request, PixelInCell pixelInCell, ScalingType scaling) throws IOException {
                MathTransform mt = super.getMathTransform(reader, subset, request, pixelInCell, scaling);
                AffineTransform2D actual = (AffineTransform2D)mt;
                Assert.assertEquals((double)0.5, (double)(GetCoverageTest.this.originalMathTransform.getScaleX() / actual.getScaleX()), (double)1.0E-6);
                Assert.assertEquals((double)0.5, (double)(GetCoverageTest.this.originalMathTransform.getScaleY() / actual.getScaleY()), (double)1.0E-6);
                return mt;
            }
        };
        GridCoverage result = getCoverage.run(getCoverageRequest);
        this.scheduleForCleaning(result);
    }

    private Map<String, String> setupGetCoverageRain() {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WCS");
        raw.put("request", "GetCoverage");
        raw.put("version", "2.0.1");
        raw.put("coverageId", "sf__rain");
        raw.put("format", "image/tiff");
        return raw;
    }
}

