/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class WCSStorageCleaner
extends TimerTask {
    Logger LOGGER = Logging.getLogger(WCSStorageCleaner.class);
    long expirationDelay;

    @Override
    public void run() {
        try {
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            Resource wcs = loader.get("temp/wcs");
            if (wcs.getType() != Resource.Type.DIRECTORY) {
                return;
            }
            long now = System.currentTimeMillis();
            for (Resource f : wcs.list()) {
                if (now - f.lastmodified() <= this.expirationDelay * 1000L) continue;
                f.delete();
            }
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Error occurred while trying to clean up old coverages from temp storage", e);
        }
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }
}

