/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.wcs.AbstractGetCoverageTest;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.vfny.geoserver.wcs.WcsException;

public class ResourceAccessManagerWCSTest
extends AbstractGetCoverageTest {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wcs/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File security = new File(testData.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_DUMMY");
        props.put("cite_noworld", "cite,ROLE_DUMMY");
        props.put("cite_noworld_challenge", "cite,ROLE_DUMMY");
        props.put("cite_usa", "cite,ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        CoverageInfo world = catalog.getCoverageByName(this.getLayerId(MockData.WORLD));
        world.getParameters().put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().getCode(), Boolean.FALSE);
        catalog.save((ResourceInfo)world);
        tam.putLimits("cite_noworld", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, null));
        tam.putLimits("cite_noworld_challenge", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.CHALLENGE, (Filter)Filter.EXCLUDE, null, null));
        MultiPolygon rasterFilter = (MultiPolygon)new WKTReader().read("MULTIPOLYGON(((-120 30, -120 60, -60 60, -60 30, -120 30)))");
        tam.putLimits("cite_usa", (CatalogInfo)world, (AccessLimits)new CoverageAccessLimits(CatalogMode.HIDE, null, rasterFilter, null));
    }

    Map<String, Object> getWorld() {
        Map<String, Object> raw = this.baseMap();
        String getLayerId = this.getLayerId(MockData.WORLD);
        raw.put("identifier", getLayerId);
        raw.put("format", "image/tiff");
        raw.put("BoundingBox", "-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326");
        raw.put("store", "false");
        raw.put("GridBaseCRS", "urn:ogc:def:crs:EPSG:6.6:4326");
        return raw;
    }

    @Test
    public void testNoLimits() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite", "cite");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoordinateReferenceSystem wgs84Flipped = CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326");
        Assert.assertEquals((Object)wgs84Flipped, (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
        Assert.assertEquals((double)-90.0, (double)coverage.getEnvelope().getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)-180.0, (double)coverage.getEnvelope().getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)90.0, (double)coverage.getEnvelope().getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)180.0, (double)coverage.getEnvelope().getMaximum(1), (double)1.0E-6);
        int[] value = new int[3];
        coverage.evaluate((Position)new Position2D(wgs84Flipped, 40.0, -90.0), value);
        Assert.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((Position)new Position2D(wgs84Flipped, 45.0, 12.0), value);
        Assert.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[2] > 0 ? 1 : 0) != 0);
        CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
    }

    @Test
    public void testNoAccess() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite_noworld", "cite");
        try {
            this.executeGetCoverageKvp(raw);
            Assert.fail((String)"This should have failed with an exception");
        }
        catch (WcsException e) {
            Assert.assertTrue((boolean)e.getMessage().matches(".*wcs:World.*"));
        }
    }

    @Test
    public void testChallenge() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite_noworld_challenge", "cite");
        try {
            this.executeGetCoverageKvp(raw);
            Assert.fail((String)"This should have failed with a security exception");
        }
        catch (Throwable e) {
            Throwable se = null;
            while (e.getCause() != null && e.getCause() != e) {
                if (!SecurityUtils.isSecurityException((Throwable)(e = e.getCause()))) continue;
                se = e;
            }
            if (e == null) {
                Assert.fail((String)"We should have got some sort of SpringSecurityException");
            }
            Assert.assertTrue((boolean)se.getMessage().contains("World"));
            Assert.assertTrue((boolean)se.getMessage().contains("privileges"));
        }
    }

    @Test
    public void testRasterFilterUSA() throws Exception {
        Map<String, Object> raw = this.getWorld();
        this.authenticate("cite_usa", "cite");
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        Assert.assertEquals((long)1L, (long)coverages.length);
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        CoordinateReferenceSystem wgs84Flipped = CRS.decode((String)"urn:ogc:def:crs:EPSG:6.6:4326");
        Assert.assertEquals((Object)wgs84Flipped, (Object)coverage.getEnvelope().getCoordinateReferenceSystem());
        Assert.assertEquals((double)-90.0, (double)coverage.getEnvelope().getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)-180.0, (double)coverage.getEnvelope().getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)90.0, (double)coverage.getEnvelope().getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)180.0, (double)coverage.getEnvelope().getMaximum(1), (double)1.0E-6);
        int[] value = new int[3];
        coverage.evaluate((Position)new Position2D(wgs84Flipped, 40.0, -90.0), value);
        Assert.assertTrue((value[0] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[1] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((value[2] > 0 ? 1 : 0) != 0);
        coverage.evaluate((Position)new Position2D(wgs84Flipped, 45.0, 12.0), value);
        Assert.assertEquals((long)0L, (long)value[0]);
        Assert.assertEquals((long)0L, (long)value[1]);
        Assert.assertEquals((long)0L, (long)value[2]);
        CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
    }

    protected void authenticate(String username, String password) {
        this.login(username, password, new String[]{"MOCKROLE"});
    }
}

