/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import net.opengis.ows11.BoundingBoxType;
import org.geoserver.wcs.kvp.BoundingBoxKvpParser;
import org.junit.Assert;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class BoundingBoxKvpParserTest {
    BoundingBoxKvpParser parser = new BoundingBoxKvpParser();

    @Test
    public void test1DRange() throws Exception {
        this.executeFailingBBoxTest("10", "This bbox was invalid?");
        this.executeFailingBBoxTest("10,20", "This bbox was invalid?");
        this.executeFailingBBoxTest("10,20,30", "This bbox was invalid?");
    }

    @Test
    public void testNonNumericalRange() throws Exception {
        this.executeFailingBBoxTest("10,20,a,b", "This bbox was invalid?");
        this.executeFailingBBoxTest("a,20,30,b", "This bbox was invalid?");
    }

    @Test
    public void testOutOfDimRange() throws Exception {
        this.executeFailingBBoxTest("10,20,30,40,50,60,EPSG:4326", "This bbox has more dimensions than the crs?");
        this.executeFailingBBoxTest("10,20,30,40,EPSG:4979", "This bbox has less dimensions than the crs?");
    }

    @Test
    public void testUnknownCRS() throws Exception {
        this.executeFailingBBoxTest("10,20,30,40,50,60,EPSG:MakeNoPrisoners!", "This crs should definitely be unknown...");
    }

    void executeFailingBBoxTest(String bbox, String message) throws Exception {
        try {
            this.parser.parse(bbox);
            Assert.fail((String)message);
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"BoundingBox", (Object)e.getLocator());
        }
    }

    @Test
    public void testNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30");
        Assert.assertEquals((long)2L, (long)bbox.getLowerCorner().size());
        Assert.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        Assert.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        Assert.assertEquals((long)2L, (long)bbox.getUpperCorner().size());
        Assert.assertEquals((Object)15.0, bbox.getUpperCorner().get(0));
        Assert.assertEquals((Object)30.0, bbox.getUpperCorner().get(1));
        Assert.assertNull((Object)bbox.getCrs());
    }

    @Test
    public void test2DNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30,EPSG:4326");
        Assert.assertEquals((long)2L, (long)bbox.getLowerCorner().size());
        Assert.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        Assert.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        Assert.assertEquals((long)2L, (long)bbox.getUpperCorner().size());
        Assert.assertEquals((Object)15.0, bbox.getUpperCorner().get(0));
        Assert.assertEquals((Object)30.0, bbox.getUpperCorner().get(1));
        Assert.assertEquals((Object)"EPSG:4326", (Object)bbox.getCrs());
    }

    @Test
    public void test3DNoCrs() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("10,20,15,30,40,50,EPSG:4979");
        Assert.assertEquals((long)3L, (long)bbox.getLowerCorner().size());
        Assert.assertEquals((Object)10.0, bbox.getLowerCorner().get(0));
        Assert.assertEquals((Object)20.0, bbox.getLowerCorner().get(1));
        Assert.assertEquals((Object)15.0, bbox.getLowerCorner().get(2));
        Assert.assertEquals((long)3L, (long)bbox.getUpperCorner().size());
        Assert.assertEquals((Object)30.0, bbox.getUpperCorner().get(0));
        Assert.assertEquals((Object)40.0, bbox.getUpperCorner().get(1));
        Assert.assertEquals((Object)50.0, bbox.getUpperCorner().get(2));
        Assert.assertEquals((Object)"EPSG:4979", (Object)bbox.getCrs());
    }

    @Test
    public void testWgs84FullExtent() throws Exception {
        BoundingBoxType bbox = (BoundingBoxType)this.parser.parse("-180,-90,180,90,urn:ogc:def:crs:EPSG:4326");
        Assert.assertEquals((long)2L, (long)bbox.getLowerCorner().size());
        Assert.assertEquals((Object)-180.0, bbox.getLowerCorner().get(0));
        Assert.assertEquals((Object)-90.0, bbox.getLowerCorner().get(1));
        Assert.assertEquals((long)2L, (long)bbox.getUpperCorner().size());
        Assert.assertEquals((Object)180.0, bbox.getUpperCorner().get(0));
        Assert.assertEquals((Object)90.0, bbox.getUpperCorner().get(1));
        Assert.assertEquals((Object)"urn:ogc:def:crs:EPSG:4326", (Object)bbox.getCrs());
    }
}

