/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.ArrayList;
import java.util.Arrays;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class WCSDisabledTest
extends WCSTestSupport {
    @Test
    public void testDisabledServiceResponse() throws Exception {
        WCSInfo wcs = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        wcs.setEnabled(false);
        this.getGeoServer().save((ServiceInfo)wcs);
        Document doc = this.getAsDOM("wcs?service=WCS&request=getCapabilities");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testEnabledServiceResponse() throws Exception {
        this.enableWCS();
        Document doc = this.getAsDOM("wcs?service=WCS&request=getCapabilities");
        Assert.assertEquals((Object)"wcs:Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testDisableLayerServiceResponse() throws Exception {
        this.enableWCS();
        CoverageInfo cinfo = this.getCatalog().getCoverageByName("wcs:BlueMarble");
        cinfo.setServiceConfiguration(true);
        cinfo.setDisabledServices(new ArrayList<String>(Arrays.asList("WCS")));
        this.getCatalog().save((ResourceInfo)cinfo);
        Document doc = this.getAsDOM("wcs?service=WCS&request=getCapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:Contents/wcs:CoverageSummary/ows:Title[.='BlueMarble'])", (Document)doc);
    }

    @Test
    public void testEnableLayerServiceResponse() throws Exception {
        this.enableWCS();
        CoverageInfo cinfo = this.getCatalog().getCoverageByName("wcs:BlueMarble");
        cinfo.setServiceConfiguration(false);
        cinfo.setDisabledServices(new ArrayList());
        this.getCatalog().save((ResourceInfo)cinfo);
        Document doc = this.getAsDOM("wcs?service=WCS&request=getCapabilities");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents/wcs:CoverageSummary/ows:Title[.='BlueMarble'])", (Document)doc);
    }

    private void enableWCS() {
        WCSInfo wcs = (WCSInfo)this.getGeoServer().getService(WCSInfo.class);
        wcs.setEnabled(true);
        this.getGeoServer().save((ServiceInfo)wcs);
    }
}

