/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import net.opengis.wcs11.DescribeCoverageType;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DescribeCoverageXmlParserTest {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    @Before
    public void setUp() throws Exception {
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("DescribeCoverage", "1.1.1", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Test
    public void testBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  xsi:schemaLocation=\"http://www.opengis.net/wcs/1.1.1 schemas/wcs/1.1.1/wcsAll.xsd\"\r\n  version=\"1.1.1\" >\r\n  <wcs:Identifier>wcs:BlueMarble</wcs:Identifier>\r\n</wcs:DescribeCoverage>";
        DescribeCoverageType cap = (DescribeCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)cap.getService());
        Assert.assertEquals((Object)"1.1.1", (Object)cap.getVersion());
        Assert.assertEquals((long)1L, (long)cap.getIdentifier().size());
        Assert.assertEquals((Object)"wcs:BlueMarble", (Object)cap.getIdentifier().get(0));
    }
}

