/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.wcs.kvp.RangeSubsetKvpParser;
import org.junit.Assert;
import org.junit.Test;
import org.vfny.geoserver.wcs.WcsException;

public class RangeSubsetKvpParserTest {
    RangeSubsetKvpParser parser = new RangeSubsetKvpParser();

    @Test
    public void testSimpleFields() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance;temperature");
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((long)2L, (long)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        Assert.assertEquals((Object)"radiance", (Object)field.getIdentifier().getValue());
        Assert.assertEquals(null, (Object)field.getInterpolationType());
        field = (FieldSubsetType)rs.getFieldSubset().get(1);
        Assert.assertEquals((Object)"temperature", (Object)field.getIdentifier().getValue());
        Assert.assertEquals(null, (Object)field.getInterpolationType());
    }

    @Test
    public void testInvalidInterpolation() throws Exception {
        try {
            this.parser.parse("radiance:mindReadingWarper");
            Assert.fail((String)"We do not support _that_ interpolation!");
        }
        catch (WcsException e) {
            Assert.assertEquals((Object)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (Object)e.getCode());
            Assert.assertEquals((Object)"RangeSubset", (Object)e.getLocator());
        }
    }

    @Test
    public void testInterpolation() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance:linear;temperature:nearest");
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((long)2L, (long)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        Assert.assertEquals((Object)"radiance", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((Object)"linear", (Object)field.getInterpolationType());
        field = (FieldSubsetType)rs.getFieldSubset().get(1);
        Assert.assertEquals((Object)"temperature", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((Object)"nearest", (Object)field.getInterpolationType());
    }

    @Test
    public void testAxisSingleKey() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance[bands[Red]]");
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((long)1L, (long)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        Assert.assertEquals((Object)"radiance", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((long)1L, (long)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        Assert.assertEquals((Object)"bands", (Object)axis.getIdentifier());
        EList keys = axis.getKey();
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertEquals((Object)"Red", keys.get(0));
    }

    @Test
    public void testAxisKeys() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance[bands[Red,Green,Blue]]");
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((long)1L, (long)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        Assert.assertEquals((Object)"radiance", (Object)field.getIdentifier().getValue());
        Assert.assertEquals((long)1L, (long)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        Assert.assertEquals((Object)"bands", (Object)axis.getIdentifier());
        EList keys = axis.getKey();
        Assert.assertEquals((long)3L, (long)keys.size());
        Assert.assertEquals((Object)"Red", keys.get(0));
        Assert.assertEquals((Object)"Green", keys.get(1));
        Assert.assertEquals((Object)"Blue", keys.get(2));
    }
}

