/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetCoverageMultipartEncodingTest
extends WCSTestSupport {
    @Test
    public void testKvpBasic() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326&GridBaseCRS=urn:ogc:def:crs:EPSG:4326&format=geotiff";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        String contentType = response.getContentType();
        Assert.assertTrue((boolean)contentType.matches("multipart/related;\\s*boundary=\".*\""));
        Assert.assertFalse((boolean)contentType.contains("\n"));
        Assert.assertFalse((boolean)contentType.contains("\r"));
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragesPart = multipart.getBodyPart(0);
        Assert.assertEquals((Object)"text/xml", (Object)coveragesPart.getContentType());
        Assert.assertEquals((Object)"<urn:ogc:wcs:1.1:coverages>", (Object)coveragesPart.getHeader("Content-ID")[0]);
        Document dom = this.dom(coveragesPart.getDataHandler().getInputStream());
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)MockData.TASMANIA_BM.getLocalPart(), (String)"wcs:Coverages/wcs:Coverage/ows:Title", (Document)dom);
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
    }

    @Test
    public void testArcgridException() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&format=application/arcgrid&boundingbox=-90,-180,90,180,urn:ogc:def:crs:EPSG:6.6:4326";
        Document dom = this.getAsDOM(request);
        this.checkOws11Exception(dom);
    }

    @Test
    public void testTiffOutput() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326&GridBaseCRS=urn:ogc:def:crs:EPSG:4326&format=image/tiff";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        ImageInputStream iis = ImageIO.createImageInputStream(coveragePart.getInputStream());
        reader.setInput(iis);
        reader.read(0);
        iis.close();
    }

    @Test
    public void testPngOutput() throws Exception {
        String request = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326&GridBaseCRS=urn:ogc:def:crs:EPSG:4326&format=image/png";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        Multipart multipart = this.getMultipart(response);
        Assert.assertEquals((long)2L, (long)multipart.getCount());
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/png", (Object)coveragePart.getContentType());
        Assert.assertEquals((Object)"<theCoverage>", (Object)coveragePart.getHeader("Content-ID")[0]);
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        reader.setInput(ImageIO.createImageInputStream(coveragePart.getInputStream()));
        reader.read(0);
    }

    @Test
    public void testGeotiffNamesGalore() throws Exception {
        String requestBase = "wcs?service=WCS&version=1.1.1&request=GetCoverage&identifier=" + this.getLayerId(MockData.TASMANIA_BM) + "&BoundingBox=-90,-180,90,180,urn:ogc:def:crs:EPSG:4326&GridBaseCRS=urn:ogc:def:crs:EPSG:4326";
        this.ensureTiffFormat(this.getAsServletResponse(requestBase + "&format=geotiff"));
        this.ensureTiffFormat(this.getAsServletResponse(requestBase + "&format=image/geotiff"));
        this.ensureTiffFormat(this.getAsServletResponse(requestBase + "&format=image/tiff"));
    }

    private void ensureTiffFormat(MockHttpServletResponse response) throws MessagingException, IOException {
        Assert.assertTrue((String)("Content type not mulipart but " + response.getContentType()), (boolean)response.getContentType().matches("multipart/related;\\s*boundary=\".*\""));
        Multipart multipart = this.getMultipart(response);
        BodyPart coveragePart = multipart.getBodyPart(1);
        Assert.assertEquals((Object)"image/tiff", (Object)coveragePart.getContentType());
    }
}

