/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wcs11.GetCoverageType;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs.kvp.GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_1_1.WcsXmlReader;
import org.geotools.wcs.v1_1.WCSConfiguration;
import org.junit.After;
import org.junit.Before;
import org.opengis.coverage.grid.GridCoverage;

public abstract class AbstractGetCoverageTest
extends WCSTestSupport {
    static final double EPS = 4.0;
    GetCoverageRequestReader kvpreader;
    WebCoverageService111 service;
    WCSConfiguration configuration;
    WcsXmlReader xmlReader;
    List<GridCoverage> coverages = new ArrayList<GridCoverage>();

    @Before
    public void setup() {
        this.kvpreader = (GetCoverageRequestReader)applicationContext.getBean("wcs111GetCoverageRequestReader");
        this.service = (WebCoverageService111)applicationContext.getBean("wcs111ServiceTarget");
        this.configuration = new WCSConfiguration();
        this.xmlReader = new WcsXmlReader("GetCoverage", "1.1.1", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @After
    public void cleanCoverages() {
        for (GridCoverage coverage : this.coverages) {
            CoverageCleanerCallback.disposeCoverage((GridCoverage)coverage);
        }
    }

    protected GridCoverage[] executeGetCoverageKvp(Map<String, Object> raw) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.kvpreader.read(this.kvpreader.createRequest(), this.parseKvp(raw), raw);
        GridCoverage[] result = this.service.getCoverage(getCoverage);
        this.coverages.addAll(Arrays.asList(result));
        return result;
    }

    protected Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.1.1");
        raw.put("request", "GetCoverage");
        return raw;
    }

    protected GridCoverage[] executeGetCoverageXml(String request) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.xmlReader.read(null, (Reader)new StringReader(request), null);
        return this.service.getCoverage(getCoverage);
    }

    protected void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    protected Map parseKvp(Map raw) throws Exception {
        HashMap input = new HashMap(raw);
        List errors = KvpUtils.parse(input);
        if (errors != null && errors.size() > 0) {
            throw (Exception)errors.get(0);
        }
        return this.caseInsensitiveKvp(input);
    }

    protected Map caseInsensitiveKvp(HashMap input) {
        HashMap result = new HashMap();
        for (String key : input.keySet()) {
            result.put(key.toUpperCase(), input.get(key));
        }
        return new CaseInsensitiveMap(result);
    }
}

