/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.test.CoverageTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class DynamicDimensionsTest
extends CoverageTestSupport {
    private static final String DIMENSION_NAME = "wavelength";
    private static final QName WATTEMP = new QName(MockData.DEFAULT_URI, "watertemp", MockData.DEFAULT_PREFIX);

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(WATTEMP, "watertempDynamicDims.zip", null, null, SystemTestData.class, this.getCatalog());
        this.setupRasterDimension(DIMENSION_NAME, DimensionPresentation.LIST);
    }

    @Test
    public void testGetCoverageBadValue() throws Exception {
        String request = this.getWaterTempRequest("bad_dimension_value");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNull((Object)image);
        request = request.replace(DIMENSION_NAME, DIMENSION_NAME.toUpperCase());
        response = this.postAsServletResponse("wcs", request);
        image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNull((Object)image);
    }

    @Test
    public void testGetCoverageKVPBadValue() throws Exception {
        String request = this.getWaterTempRequestKVP("bad_dimension_value");
        MockHttpServletResponse response = this.getAsServletResponse(request);
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNull((Object)image);
        request = request.replace(DIMENSION_NAME, DIMENSION_NAME.toUpperCase());
        response = this.getAsServletResponse(request);
        image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNull((Object)image);
    }

    @Test
    public void testGetCoverageGoodValue() throws Exception {
        String request = this.getWaterTempRequest("100");
        MockHttpServletResponse response = this.postAsServletResponse("wcs", request);
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        request = request.replace(DIMENSION_NAME, DIMENSION_NAME.toUpperCase());
        response = this.postAsServletResponse("wcs", request);
        image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
    }

    @Test
    public void testGetCoverageKVPGoodValue() throws Exception {
        String request = this.getWaterTempRequestKVP("100");
        MockHttpServletResponse response = this.getAsServletResponse(request);
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
        request = request.replace(DIMENSION_NAME, DIMENSION_NAME.toUpperCase());
        response = this.getAsServletResponse(request);
        image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        Assert.assertEquals((Object)"image/tiff", (Object)response.getContentType());
    }

    private String getWaterTempRequestKVP(String dimensionValue) {
        String url = "wcs?service=WCS&version=1.0.0&request=GetCoverage&sourceCoverage=%s&format=GEOTIFF&width=25&height=24&crs=EPSG:4326&bbox=0.237,40.562,14.593,44.558&%s=%s";
        return String.format(url, this.getLayerId(WATTEMP), DIMENSION_NAME, dimensionValue);
    }

    private String getWaterTempRequest(String dimensionValue) {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<GetCoverage version=\"1.0.0\" service=\"WCS\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wcs\"\n  xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\"\n  xmlns:ogc=\"http://www.opengis.net/ogc\"\n  xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd\">\n  <sourceCoverage>" + this.getLayerId(WATTEMP) + "</sourceCoverage>\n  <domainSubset>\n    <spatialSubset>\n      <gml:Envelope srsName=\"EPSG:4326\">\n        <gml:pos>0.237 40.562</gml:pos>\n        <gml:pos>14.593 44.558</gml:pos>\n      </gml:Envelope>\n      <gml:Grid dimension=\"2\">\n        <gml:limits>\n          <gml:GridEnvelope>\n            <gml:low>0 0</gml:low>\n            <gml:high>25 24</gml:high>\n          </gml:GridEnvelope>\n        </gml:limits>\n        <gml:axisName>x</gml:axisName>\n        <gml:axisName>y</gml:axisName>\n      </gml:Grid>\n    </spatialSubset>\n  </domainSubset>\n  <rangeSubset>\n    <axisSubset name=\"wavelength\">\n      <singleValue>" + dimensionValue + "</singleValue>\n    </axisSubset>\n  </rangeSubset>\n  <output>\n    <crs>EPSG:4326</crs>\n    <format>GEOTIFF</format>\n  </output>\n</GetCoverage>";
        return request;
    }

    private void setupRasterDimension(String metadata, DimensionPresentation presentation) {
        CoverageInfo info = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(presentation);
        info.getMetadata().put("custom_dimension_" + metadata, (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }
}

