/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.IOException;
import java.util.ArrayList;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.test.WCSTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescribeCoverageTest
extends WCSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Before
    public void revertTasmaniaDem() throws IOException {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
    }

    @Test
    public void testDescribeAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        Assert.assertEquals((long)count, (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
    }

    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageStoreInfo cvInfo = this.getCatalog().getCoverageStoreByName(MockData.TASMANIA_DEM.getLocalPart());
        cvInfo.setURL("file:///I/AM/NOT/THERE");
        this.getCatalog().save((StoreInfo)cvInfo);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0");
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        int count = this.getCatalog().getCoverages().size();
        Assert.assertEquals((long)(count - 1), (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
    }

    @Test
    public void testDescribeUnknownCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=plop");
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)element.getAttribute("code"));
        Assert.assertEquals((Object)"coverage", (Object)element.getAttribute("locator"));
        Assert.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDescribeMissingVersion() throws Exception {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setCiteCompliant(true);
        gs.save((ServiceInfo)info);
        try {
            Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
            this.checkOws11Exception(dom);
            Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
            Assert.assertEquals((Object)"MissingParameterValue", (Object)element.getAttribute("code"));
            Assert.assertEquals((Object)"version", (Object)element.getAttribute("locator"));
        }
        finally {
            info.setCiteCompliant(false);
            gs.save((ServiceInfo)info);
        }
    }

    @Test
    public void testDescribeUnknownCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>plop</wcs:Coverage>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkOws11Exception(dom);
        Element element = (Element)dom.getElementsByTagName("ServiceException").item(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)element.getAttribute("code"));
        Assert.assertEquals((Object)"coverage", (Object)element.getAttribute("locator"));
        Assert.assertTrue((boolean)element.getTextContent().contains("plop"));
    }

    @Test
    public void testMetadataLinks() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/tasmania/dem.xml");
        ml.setMetadataType("FGDC");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.print(dom);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)"//wcs:metadataLink/@about", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"FGDC", (String)"//wcs:metadataLink/@metadataType", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)"//wcs:metadataLink/@xlink:type", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)"//wcs:metadataLink/@xlink:href", (Document)dom);
    }

    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("/metadata?key=value");
        ml.setMetadataType("FGDC");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)"//wcs:metadataLink/@about", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"FGDC", (String)"//wcs:metadataLink/@metadataType", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)"//wcs:metadataLink/@xlink:type", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?key=value"), (String)"//wcs:metadataLink/@xlink:href", (Document)dom);
    }

    @Test
    public void testDescribeDemCoverageKvp() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_DEM));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    @Test
    public void testDescribeDemCoverageXml() throws Exception {
        ArrayList errors = new ArrayList();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + this.getLayerId(MockData.TASMANIA_DEM) + "</wcs:Coverage>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs", request, errors);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        this.checkDemCoverageDescription(dom);
    }

    private void checkDemCoverageDescription(Document dom) throws Exception {
        int i;
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_DEM), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)2L, (long)offsetStrsLow.length);
        Assert.assertEquals((long)2L, (long)offsetStrsHigh.length);
        double[] offsets = new double[4];
        for (i = 0; i < offsetStrsLow.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
        }
        for (i = 2; i < 2 + offsetStrsHigh.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
        }
        Assert.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)offsets[1], (double)0.001);
        Assert.assertEquals((double)0.0, (double)offsets[2], (double)0.001);
        Assert.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:AxisDescription").getLength());
    }

    @Test
    public void testDescribeRotatedCoverage() throws Exception {
        int i;
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.ROTATED_CAD));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.ROTATED_CAD), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)2L, (long)offsetStrsLow.length);
        Assert.assertEquals((long)2L, (long)offsetStrsHigh.length);
        double[] offsets = new double[4];
        for (i = 0; i < offsetStrsLow.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
        }
        for (i = 2; i < 2 + offsetStrsHigh.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
        }
        Assert.assertTrue((offsets[0] < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[1] > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[2] > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((offsets[3] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:AxisDescription").getLength());
    }

    @Test
    public void testDescribeImageCoverage() throws Exception {
        int i;
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(MockData.TASMANIA_BM));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(MockData.TASMANIA_BM), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        Node gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(0);
        String[] offsetStrsLow = gridOffsets.getTextContent().split(" ");
        gridOffsets = xpath.getMatchingNodes("/wcs:CoverageDescription/wcs:CoverageOffering/wcs:domainSet/wcs:spatialDomain/gml:RectifiedGrid/gml:offsetVector", dom).item(1);
        String[] offsetStrsHigh = gridOffsets.getTextContent().split(" ");
        Assert.assertEquals((long)2L, (long)offsetStrsLow.length);
        Assert.assertEquals((long)2L, (long)offsetStrsHigh.length);
        double[] offsets = new double[4];
        for (i = 0; i < offsetStrsLow.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsLow[i]);
        }
        for (i = 2; i < 2 + offsetStrsHigh.length; ++i) {
            offsets[i] = Double.parseDouble(offsetStrsHigh[i - 2]);
        }
        Assert.assertTrue((offsets[0] > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)offsets[1], (double)0.001);
        Assert.assertEquals((double)0.0, (double)offsets[2], (double)0.001);
        Assert.assertTrue((offsets[3] < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:AxisDescription").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:interval").getLength());
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + MockData.TASMANIA_DEM.getLocalPart() + "</wcs:Coverage>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("cdf/wcs", request);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.postAsDOM("wcs", request);
        Assert.assertEquals((Object)"wcs:CoverageDescription", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testLayerQualified() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<wcs:DescribeCoverage service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\"\r\n  xmlns:wcs=\"http://www.opengis.net/wcs\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \r\n  version=\"1.0.0\" >\r\n  <wcs:Coverage>" + MockData.TASMANIA_DEM.getLocalPart() + "</wcs:Coverage>\r\n</wcs:DescribeCoverage>";
        Document dom = this.postAsDOM("wcs/World/wcs", request);
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.postAsDOM("wcs/DEM/wcs", request);
        Assert.assertEquals((Object)"wcs:CoverageDescription", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testTimeCoverageList() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(WATTEMP));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:temporalDomain/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:temporalDomain/gml:timePosition[2]", (Document)dom);
    }

    @Test
    public void testTimeCoverageContinousInterval() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.CONTINUOUS_INTERVAL, null);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(WATTEMP));
        this.print(dom);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod/wcs:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod/wcs:endPosition", (Document)dom);
    }

    @Test
    public void testTimeCoverageDiscreteInterval() throws Exception {
        this.setupRasterDimension(WATTEMP, "time", DimensionPresentation.DISCRETE_INTERVAL, 3600000.0);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(WATTEMP));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod/wcs:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-01T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod/wcs:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"PT1H", (String)"//wcs:temporalDomain/wcs:timePeriod/wcs:timeResolution", (Document)dom);
    }

    @Test
    public void testElevationList() throws Exception {
        this.setupRasterDimension(WATTEMP, "elevation", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(WATTEMP));
        this.print(dom);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wcs:AxisDescription[wcs:name = 'ELEVATION']/wcs:values/wcs:singleValue[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"100.0", (String)"//wcs:AxisDescription[wcs:name = 'ELEVATION']/wcs:values/wcs:singleValue[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wcs:AxisDescription[wcs:name = 'ELEVATION']/wcs:values/wcs:default", (Document)dom);
    }

    @Test
    public void testTimeRangeCoverageList() throws Exception {
        this.setupRasterDimension(TIMERANGES, "time", DimensionPresentation.LIST, null);
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(TIMERANGES));
        this.print(dom);
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//wcs:lonLatEnvelope/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//gml:EnvelopeWithTimePeriod/gml:timePosition[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wcs:temporalDomain/wcs:timePeriod)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-10-31T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod[1]/wcs:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-04T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod[1]/wcs:endPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-05T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod[2]/wcs:beginPosition", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2008-11-07T00:00:00.000Z", (String)"//wcs:temporalDomain/wcs:timePeriod[2]/wcs:endPosition", (Document)dom);
    }

    @Test
    public void testMethodNameInjection() throws Exception {
        Document dom = this.getAsDOM("wcs?service=WCS&version=1.0.0&request=DescribeCoverage%22%3E%3C/ServiceException%3E%3Cfoo%3EHello,%20World%3C/foo%3E%3CServiceException+foo=%22&coverage=" + this.getLayerId(TIMERANGES));
        XMLAssert.assertXpathExists((String)"/ServiceExceptionReport/ServiceException", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"OperationNotSupported", (String)"/ServiceExceptionReport/ServiceException/@code", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"DescribeCoverage\"></ServiceException><foo>Hello, World</foo><ServiceException foo=\"", (String)"/ServiceExceptionReport/ServiceException/@locator", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//foo", (Document)dom);
    }

    @Test
    public void testIAUDescription() throws Exception {
        Document dom = this.getAsDOM("wcs?request=DescribeCoverage&service=WCS&version=1.0.0&coverage=" + this.getLayerId(SystemTestData.MARS_VIKING));
        this.checkValidationErrors(dom, WCS10_DESCRIBECOVERAGE_SCHEMA);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageDescription").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wcs:CoverageOffering").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)this.getLayerId(SystemTestData.MARS_VIKING), (String)"/wcs:CoverageDescription/wcs:CoverageOffering/wcs:name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"IAU:49900", (String)"//wcs:requestResponseCRSs", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"IAU:49900", (String)"//gml:RectifiedGrid/@srsName", (Document)dom);
    }
}

