/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.xml;

import java.io.Reader;
import java.io.StringReader;
import net.opengis.wcs10.DescribeCoverageType;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wcs.xml.v1_0_0.WcsXmlReader;
import org.geotools.wcs.WCSConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DescribeCoverageXmlParserTest {
    private WCSConfiguration configuration;
    private WcsXmlReader reader;

    @Before
    public void setUp() throws Exception {
        this.configuration = new WCSConfiguration();
        this.reader = new WcsXmlReader("DescribeCoverage", "1.0.0", this.configuration, EntityResolverProvider.RESOLVE_DISABLED_PROVIDER);
    }

    @Test
    public void testBasic() throws Exception {
        String request = "<DescribeCoverage  version=\"1.0.0\"  service=\"WCS\"  xmlns=\"http://www.opengis.net/wcs\"  xmlns:nurc=\"http://www.nurc.nato.int\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wcs schemas/wcs/1.0.0/describeCoverage.xsd\">    <Coverage>nurc:Pk50095</Coverage>    </DescribeCoverage>";
        DescribeCoverageType cap = (DescribeCoverageType)this.reader.read(null, (Reader)new StringReader(request), null);
        Assert.assertEquals((Object)"WCS", (Object)cap.getService());
        Assert.assertEquals((Object)"1.0.0", (Object)cap.getVersion());
        Assert.assertEquals((long)1L, (long)cap.getCoverage().size());
        Assert.assertEquals((Object)"nurc:Pk50095", (Object)cap.getCoverage().get(0));
    }
}

