/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import net.opengis.wcs10.DescribeCoverageType;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.temporal.object.DefaultPeriodDuration;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.util.ResponseUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Wcs10DescribeCoverageTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)Wcs10DescribeCoverageTransformer.class.getPackage().getName());
    private static final String WCS_URI = "http://www.opengis.net/wcs";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Map<String, String> METHOD_NAME_MAP = new HashMap<String, String>();
    private final boolean skipMisconfigured;
    private Catalog catalog;

    public Wcs10DescribeCoverageTransformer(WCSInfo wcs, Catalog catalog) {
        this.catalog = catalog;
        this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wcs.getGeoServer().getGlobal().getResourceErrorHandling());
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS100DescribeCoverageTranslator(handler);
    }

    static {
        METHOD_NAME_MAP.put("nearest neighbor", "nearest");
        METHOD_NAME_MAP.put("bilinear", "linear");
        METHOD_NAME_MAP.put("bicubic", "cubic");
    }

    private class WCS100DescribeCoverageTranslator
    extends TransformerBase.TranslatorSupport {
        public static final String SCHEMAS = "schemas";
        private DescribeCoverageType request;

        public WCS100DescribeCoverageTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            ArrayList<CoverageInfo> coverages;
            boolean skipMisconfiguredThisTime;
            if (!(o instanceof DescribeCoverageType)) {
                throw new IllegalArgumentException("Not a GetCapabilitiesType: " + o);
            }
            this.request = (DescribeCoverageType)o;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", Wcs10DescribeCoverageTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = "xmlns:" + Wcs10DescribeCoverageTransformer.XSI_PREFIX;
            attributes.addAttribute("", prefixDef, prefixDef, "", Wcs10DescribeCoverageTransformer.XSI_URI);
            String locationAtt = Wcs10DescribeCoverageTransformer.XSI_PREFIX + ":schemaLocation";
            String locationDef = "http://www.opengis.net/wcs " + org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)org.geoserver.ows.util.ResponseUtils.appendPath((String[])new String[]{SCHEMAS, "wcs/1.0.0/describeCoverage.xsd"}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "version", "version", "", "1.0.0");
            this.start("wcs:CoverageDescription", attributes);
            if (this.request.getCoverage() == null || this.request.getCoverage().size() == 0) {
                skipMisconfiguredThisTime = Wcs10DescribeCoverageTransformer.this.skipMisconfigured;
                coverages = Wcs10DescribeCoverageTransformer.this.catalog.getCoverages();
            } else {
                skipMisconfiguredThisTime = false;
                coverages = new ArrayList<CoverageInfo>();
                for (String coverageId : this.request.getCoverage()) {
                    LayerInfo layer = Wcs10DescribeCoverageTransformer.this.catalog.getLayerByName(coverageId);
                    if (layer == null || layer.getType() != PublishedType.RASTER) {
                        throw new WcsException("Could not find the specified coverage: " + coverageId, WcsException.WcsExceptionCode.InvalidParameterValue, "coverage");
                    }
                    coverages.add(Wcs10DescribeCoverageTransformer.this.catalog.getCoverageByName(coverageId));
                }
            }
            for (CoverageInfo coverage : coverages) {
                try {
                    this.mark();
                    this.handleCoverageOffering(coverage);
                    this.commit();
                }
                catch (Exception e) {
                    if (skipMisconfiguredThisTime) {
                        this.reset();
                        continue;
                    }
                    throw new RuntimeException("Unexpected error occurred during describe coverage xml encoding", e);
                }
            }
            this.end("wcs:CoverageDescription");
        }

        private void handleCoverageOffering(CoverageInfo ci) throws Exception {
            this.start("wcs:CoverageOffering");
            for (MetadataLinkInfo mdl : ci.getMetadataLinks()) {
                this.handleMetadataLink(mdl, "simple");
            }
            this.element("wcs:description", ci.getDescription());
            this.element("wcs:name", ci.prefixedName());
            this.element("wcs:label", ci.getTitle());
            this.handleLonLatEnvelope(ci, ci.getLatLonBoundingBox());
            this.handleKeywords(ci.getKeywords());
            this.handleDomain(ci);
            this.handleRange(ci);
            this.handleSupportedCRSs(ci);
            this.handleSupportedFormats(ci);
            this.handleSupportedInterpolations(ci);
            this.end("wcs:CoverageOffering");
        }

        private void handleMetadataLink(MetadataLinkInfo mdl, String linkType) {
            AttributesImpl attributes = new AttributesImpl();
            if (StringUtils.isNotBlank((CharSequence)mdl.getAbout())) {
                attributes.addAttribute("", "about", "about", "", mdl.getAbout());
            }
            if (StringUtils.isNotBlank((CharSequence)mdl.getMetadataType())) {
                attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
            }
            if (linkType != null && linkType != "") {
                attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
            }
            if (StringUtils.isNotBlank((CharSequence)mdl.getContent())) {
                attributes.addAttribute("", "xlink:href", "xlink:href", "", ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)mdl, (String)this.request.getBaseUrl()));
            }
            if (attributes.getLength() > 0) {
                this.element("wcs:metadataLink", null, attributes);
            }
        }

        private void handleLonLatEnvelope(CoverageInfo ci, ReferencedEnvelope referencedEnvelope) throws IOException {
            CoverageStoreInfo csinfo = ci.getStore();
            if (csinfo == null) {
                throw new WcsException("Unable to acquire coverage store resource for coverage: " + ci.getName());
            }
            GridCoverage2DReader reader = null;
            try {
                reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
            }
            catch (IOException e) {
                LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            if (reader == null) {
                throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            if (referencedEnvelope != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "srsName", "srsName", "", "urn:ogc:def:crs:OGC:1.3:CRS84");
                this.start("wcs:lonLatEnvelope", attributes);
                String minCP = referencedEnvelope.getMinX() + " " + referencedEnvelope.getMinY();
                String maxCP = referencedEnvelope.getMaxX() + " " + referencedEnvelope.getMaxY();
                this.element("gml:pos", minCP);
                this.element("gml:pos", maxCP);
                DimensionInfo timeInfo = (DimensionInfo)ci.getMetadata().get("time", DimensionInfo.class);
                if (timeInfo != null && timeInfo.isEnabled()) {
                    ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
                    SimpleDateFormat format = dimensions.getTimeFormat();
                    this.element("gml:timePosition", format.format(dimensions.getMinTime()));
                    this.element("gml:timePosition", format.format(dimensions.getMaxTime()));
                }
                this.end("wcs:lonLatEnvelope");
            }
        }

        private void handleKeywords(List kwords) {
            this.start("wcs:keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("wcs:keyword", it.next().toString());
                }
            }
            this.end("wcs:keywords");
        }

        private void handleDomain(CoverageInfo ci) throws Exception {
            CoverageStoreInfo csinfo = ci.getStore();
            if (csinfo == null) {
                throw new WcsException("Unable to acquire coverage store resource for coverage: " + ci.getName());
            }
            GridCoverage2DReader reader = null;
            try {
                reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
            }
            catch (IOException e) {
                LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            if (reader == null) {
                throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
            }
            DimensionInfo timeInfo = (DimensionInfo)ci.getMetadata().get("time", DimensionInfo.class);
            ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
            this.start("wcs:domainSet");
            this.start("wcs:spatialDomain");
            this.handleBoundingBox(ci.getSRS(), ci.getNativeBoundingBox(), timeInfo, dimensions);
            this.handleGrid(ci);
            this.end("wcs:spatialDomain");
            if (timeInfo != null && timeInfo.isEnabled()) {
                this.handleTemporalDomain(ci, timeInfo, dimensions);
            }
            this.end("wcs:domainSet");
        }

        private void handleBoundingBox(String srsName, ReferencedEnvelope referencedEnvelope, DimensionInfo timeInfo, ReaderDimensionsAccessor dimensions) throws IOException {
            if (referencedEnvelope != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "srsName", "srsName", "", srsName);
                String minCP = referencedEnvelope.getMinX() + " " + referencedEnvelope.getMinY();
                String maxCP = referencedEnvelope.getMaxX() + " " + referencedEnvelope.getMaxY();
                String minTime = null;
                String maxTime = null;
                if (timeInfo != null && timeInfo.isEnabled()) {
                    SimpleDateFormat timeFormat = dimensions.getTimeFormat();
                    minTime = timeFormat.format(dimensions.getMinTime());
                    maxTime = timeFormat.format(dimensions.getMaxTime());
                }
                if (minTime != null && maxTime != null) {
                    this.start("gml:EnvelopeWithTimePeriod", attributes);
                    this.element("gml:pos", minCP);
                    this.element("gml:pos", maxCP);
                    this.element("gml:timePosition", minTime);
                    this.element("gml:timePosition", maxTime);
                    this.end("gml:EnvelopeWithTimePeriod");
                } else {
                    this.start("gml:Envelope", attributes);
                    this.element("gml:pos", minCP);
                    this.element("gml:pos", maxCP);
                    this.end("gml:Envelope");
                }
            }
        }

        private void handleTemporalDomain(CoverageInfo ci, DimensionInfo timeInfo, ReaderDimensionsAccessor dimensions) throws IOException {
            SimpleDateFormat timeFormat = dimensions.getTimeFormat();
            this.start("wcs:temporalDomain");
            if (timeInfo.getPresentation() == DimensionPresentation.LIST) {
                for (Object item : dimensions.getTimeDomain()) {
                    if (item instanceof Date) {
                        this.element("gml:timePosition", timeFormat.format((Date)item));
                        continue;
                    }
                    DateRange range = (DateRange)item;
                    this.start("wcs:timePeriod");
                    String minTime = timeFormat.format(range.getMinValue());
                    String maxTime = timeFormat.format(range.getMaxValue());
                    this.element("wcs:beginPosition", minTime);
                    this.element("wcs:endPosition", maxTime);
                    this.end("wcs:timePeriod");
                }
            } else {
                String minTime = timeFormat.format(dimensions.getMinTime());
                String maxTime = timeFormat.format(dimensions.getMaxTime());
                this.start("wcs:timePeriod");
                this.element("wcs:beginPosition", minTime);
                this.element("wcs:endPosition", maxTime);
                if (timeInfo.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL) {
                    BigDecimal resolution = timeInfo.getResolution();
                    if (resolution == null) {
                        resolution = new BigDecimal(dimensions.getMaxTime().getTime() - dimensions.getMinTime().getTime());
                    }
                    this.element("wcs:timeResolution", new DefaultPeriodDuration(resolution.longValue()).toString());
                }
                this.end("wcs:timePeriod");
            }
            this.end("wcs:temporalDomain");
        }

        private void handleGrid(CoverageInfo ci) throws Exception {
            GridGeometry originalGrid = ci.getGrid();
            GridEnvelope gridRange = originalGrid.getGridRange();
            AffineTransform2D gridToCRS = (AffineTransform2D)originalGrid.getGridToCRS();
            int gridDimension = gridToCRS.getSourceDimensions();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "dimension", "dimension", "", String.valueOf(gridDimension));
            attributes.addAttribute("", "srsName", "srsName", "", ci.getSRS());
            this.start("gml:RectifiedGrid", attributes);
            String lowers = "";
            String uppers = "";
            for (int r = 0; r < gridDimension; ++r) {
                if (gridToCRS.getSourceDimensions() > r) {
                    lowers = lowers + gridRange.getLow(r) + " ";
                    uppers = uppers + gridRange.getHigh(r) + " ";
                    continue;
                }
                lowers = lowers + "0 ";
                uppers = uppers + "0 ";
            }
            this.start("gml:limits");
            this.start("gml:GridEnvelope");
            this.element("gml:low", lowers.trim());
            this.element("gml:high", uppers.trim());
            this.end("gml:GridEnvelope");
            this.end("gml:limits");
            for (int dn = 0; dn < ci.getCRS().getCoordinateSystem().getDimension(); ++dn) {
                String axisName = ci.getCRS().getCoordinateSystem().getAxis(dn).getAbbreviation();
                axisName = axisName.toLowerCase().startsWith("lon") ? "x" : axisName;
                axisName = axisName.toLowerCase().startsWith("lat") ? "y" : axisName;
                this.element("gml:axisName", axisName);
            }
            StringBuilder origins = new StringBuilder();
            origins.append(gridToCRS.getTranslateX()).append(" ").append(gridToCRS.getTranslateY());
            this.start("gml:origin");
            this.element("gml:pos", origins.toString());
            this.end("gml:origin");
            StringBuilder offsetX = new StringBuilder();
            offsetX.append(gridToCRS.getScaleX()).append(" ").append(gridToCRS.getShearX());
            this.element("gml:offsetVector", offsetX.toString());
            StringBuilder offsetY = new StringBuilder();
            offsetY.append(gridToCRS.getShearY()).append(" ").append(gridToCRS.getScaleY());
            this.element("gml:offsetVector", offsetY.toString());
            this.end("gml:RectifiedGrid");
        }

        private void handleRange(CoverageInfo ci) throws IOException {
            this.start("wcs:rangeSet");
            this.start("wcs:RangeSet");
            this.element("wcs:name", ci.getName());
            this.element("wcs:label", ci.getTitle());
            this.start("wcs:axisDescription");
            this.start("wcs:AxisDescription");
            int numSampleDimensions = ci.getDimensions().size();
            this.element("wcs:name", "Band");
            this.element("wcs:label", "Band");
            this.start("wcs:values");
            if (numSampleDimensions > 1) {
                this.start("wcs:interval");
                this.element("wcs:min", "1");
                this.element("wcs:max", String.valueOf(numSampleDimensions));
                this.end("wcs:interval");
            } else {
                this.element("wcs:singleValue", "1");
            }
            this.end("wcs:values");
            this.end("wcs:AxisDescription");
            this.end("wcs:axisDescription");
            DimensionInfo elevationInfo = (DimensionInfo)ci.getMetadata().get("elevation", DimensionInfo.class);
            if (elevationInfo != null && elevationInfo.isEnabled()) {
                GridCoverage2DReader reader = null;
                try {
                    reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
                }
                catch (IOException e) {
                    LOGGER.severe("Unable to acquire a reader for this coverage with format: " + ci.getStore().getFormat().getName());
                }
                if (reader == null) {
                    throw new WcsException("Unable to acquire a reader for this coverage with format: " + ci.getStore().getFormat().getName());
                }
                ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
                if (dimensions.hasElevation()) {
                    this.start("wcs:axisDescription");
                    this.start("wcs:AxisDescription");
                    this.element("wcs:name", "ELEVATION");
                    this.element("wcs:label", "ELEVATION");
                    this.start("wcs:values");
                    TreeSet rawElevations = dimensions.getElevationDomain();
                    TreeSet<Double> elevations = new TreeSet<Double>();
                    for (Object raw : rawElevations) {
                        if (raw instanceof Double) {
                            elevations.add((Double)raw);
                            continue;
                        }
                        NumberRange range = (NumberRange)raw;
                        double midValue = (range.getMinimum() + range.getMaximum()) / 2.0;
                        elevations.add(midValue);
                    }
                    for (Double elevation : elevations) {
                        this.element("wcs:singleValue", Double.toString(elevation));
                    }
                    this.element("wcs:default", Double.toString((Double)elevations.first()));
                    this.end("wcs:values");
                    this.end("wcs:AxisDescription");
                    this.end("wcs:axisDescription");
                }
            }
            this.end("wcs:RangeSet");
            this.end("wcs:rangeSet");
        }

        private void handleSupportedCRSs(CoverageInfo ci) throws Exception {
            LinkedHashSet supportedCRSs = new LinkedHashSet();
            if (ci.getRequestSRS() != null) {
                supportedCRSs.addAll(ci.getRequestSRS());
            }
            if (ci.getResponseSRS() != null) {
                supportedCRSs.addAll(ci.getResponseSRS());
            }
            this.start("wcs:supportedCRSs");
            for (String crsName : supportedCRSs) {
                CoordinateReferenceSystem crs = CRS.decode((String)crsName, (boolean)true);
                this.element("wcs:requestResponseCRSs", CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false));
            }
            this.end("wcs:supportedCRSs");
        }

        private String urnIdentifier(CoordinateReferenceSystem crs) throws FactoryException {
            String authorityAndCode = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            String code = authorityAndCode.substring(authorityAndCode.lastIndexOf(":") + 1);
            return "urn:ogc:def:crs:EPSG::" + code;
        }

        private void handleSupportedFormats(CoverageInfo ci) throws Exception {
            String nativeFormat = ci.getNativeFormat() != null && ci.getNativeFormat().equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : ci.getNativeFormat();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "nativeFormat", "nativeFormat", "", nativeFormat);
            HashSet<String> formats = new HashSet<String>();
            for (String format : ci.getSupportedFormats()) {
                formats.add(format);
            }
            this.start("wcs:supportedFormats", attributes);
            ArrayList sortedFormats = new ArrayList(formats);
            Collections.sort(sortedFormats);
            for (String format : sortedFormats) {
                this.element("wcs:formats", format.equalsIgnoreCase("GEOTIFF") ? "GeoTIFF" : format);
            }
            this.end("wcs:supportedFormats");
        }

        private void handleSupportedInterpolations(CoverageInfo ci) {
            if (ci.getDefaultInterpolationMethod() != null) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "default", "default", "", ci.getDefaultInterpolationMethod());
                this.start("wcs:supportedInterpolations", attributes);
            } else {
                this.start("wcs:supportedInterpolations");
            }
            for (String method : ci.getInterpolationMethods()) {
                if (method == null) continue;
                this.element("wcs:interpolationMethod", method);
            }
            this.end("wcs:supportedInterpolations");
        }
    }
}

