/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.WCSInfo;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.processing.Operation;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Interpolate;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.math.DD;
import org.vfny.geoserver.wcs.WcsException;

public class WCSUtils {
    private static final double SHEAR_EPS = 0.001;
    private static final Logger LOGGER = Logging.getLogger(WCSUtils.class);
    public static final String ELEVATION = "ELEVATION";
    public static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Hints hints = new Hints();

    public static GridCoverage2D resample(GridCoverage2D coverage, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GridGeometry2D gridGeometry, Interpolation interpolation) throws WcsException {
        ParameterValueGroup param = PROCESSOR.getOperation("Resample").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)targetCRS);
        param.parameter("GridGeometry").setValue((Object)gridGeometry);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)((Resample)PROCESSOR.getOperation("Resample")).doOperation(param, hints);
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, Bounds bounds) {
        ReferencedEnvelope cropBounds = new ReferencedEnvelope(bounds);
        ReferencedEnvelope coverageBounds = new ReferencedEnvelope(coverage.getEnvelope());
        if (cropBounds.contains((Envelope)coverageBounds)) {
            return coverage;
        }
        ReferencedEnvelope intersection = cropBounds.intersection((Envelope)coverageBounds);
        if (WCSUtils.getEnvelopeInRasterSpace((Bounds)intersection, coverage.getGridGeometry()).isEmpty()) {
            return null;
        }
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)cropBounds);
        MultiPolygon roi = polygon.getFactory().createMultiPolygon(new Polygon[]{polygon});
        ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)bounds);
        param.parameter("ROI").setValue((Object)roi);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, Geometry crop) {
        Geometry roi;
        ReferencedEnvelope coverageBounds;
        ReferencedEnvelope cropBounds = new ReferencedEnvelope(crop.getEnvelopeInternal(), coverage.getCoordinateReferenceSystem2D());
        if (cropBounds.contains((Envelope)(coverageBounds = new ReferencedEnvelope(coverage.getEnvelope())))) {
            return coverage;
        }
        ReferencedEnvelope intersection = cropBounds.intersection((Envelope)coverageBounds);
        if (WCSUtils.getEnvelopeInRasterSpace((Bounds)intersection, coverage.getGridGeometry()).isEmpty()) {
            return null;
        }
        if (crop instanceof Polygon) {
            Polygon polygon = (Polygon)crop;
            roi = polygon.getFactory().createMultiPolygon(new Polygon[]{polygon});
        } else if (crop instanceof MultiPolygon) {
            roi = crop;
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + crop.getClass());
        }
        ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)cropBounds);
        param.parameter("ROI").setValue((Object)roi);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }

    public static GridCoverage2D padToEnvelope(GridCoverage2D coverage, Bounds bounds) throws TransformException {
        GridGeometry2D gg = coverage.getGridGeometry();
        GridEnvelope2D targetRange = WCSUtils.getEnvelopeInRasterSpace(bounds, gg);
        GridEnvelope2D sourceRange = gg.getGridRange2D();
        if (sourceRange.x == targetRange.x && sourceRange.y == targetRange.y && sourceRange.width == targetRange.width && sourceRange.height == targetRange.height) {
            return coverage;
        }
        if (targetRange.isEmpty()) {
            return null;
        }
        GridGeometry2D target = new GridGeometry2D((GridEnvelope)targetRange, gg.getGridToCRS(), gg.getCoordinateReferenceSystem2D());
        ArrayList<GridCoverage2D> sources = new ArrayList<GridCoverage2D>(2);
        sources.add(coverage);
        ParameterValueGroup param = PROCESSOR.getOperation("Mosaic").getParameters();
        param.parameter("Sources").setValue(sources);
        param.parameter("geometry").setValue((Object)target);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }

    private static GridEnvelope2D getEnvelopeInRasterSpace(Bounds bounds, GridGeometry2D gg) {
        try {
            GeneralBounds rasterEnvelopeFloat = CRS.transform((MathTransform)gg.getCRSToGrid2D(PixelOrientation.UPPER_LEFT), (Bounds)bounds);
            return new GridEnvelope2D((int)Math.round(rasterEnvelopeFloat.getMinimum(0)), (int)Math.round(rasterEnvelopeFloat.getMinimum(1)), (int)Math.round(rasterEnvelopeFloat.getSpan(0)), (int)Math.round(rasterEnvelopeFloat.getSpan(1)));
        }
        catch (TransformException e) {
            throw new ServiceException("Failed to transform envelope to raster space", (Throwable)e);
        }
    }

    public static GridCoverage2D interpolate(GridCoverage2D coverage, Interpolation interpolation) throws WcsException {
        if (interpolation != null) {
            ParameterValueGroup param = PROCESSOR.getOperation("Interpolate").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Type").setValue((Object)interpolation);
            return (GridCoverage2D)((Interpolate)PROCESSOR.getOperation("Interpolate")).doOperation(param, hints);
        }
        return coverage;
    }

    public static Coverage bandSelect(Map params, GridCoverage coverage) throws WcsException {
        int numDimensions = coverage.getNumSampleDimensions();
        HashMap<CallSite, Integer> dims = new HashMap<CallSite, Integer>();
        ArrayList<Integer> selectedBands = new ArrayList<Integer>();
        for (int d = 0; d < numDimensions; ++d) {
            dims.put((CallSite)((Object)("band" + (d + 1))), d);
        }
        if (params != null && !params.isEmpty()) {
            for (Object o : params.keySet()) {
                String param = (String)o;
                if (!param.equalsIgnoreCase("BAND")) continue;
                try {
                    String[] bands;
                    String values = (String)params.get(param);
                    if (values.indexOf("/") > 0) {
                        String[] minMaxRes = values.split("/");
                        int min = (int)Math.round(Double.parseDouble(minMaxRes[0]));
                        int max = (int)Math.round(Double.parseDouble(minMaxRes[1]));
                        for (int v = min; v <= max; ++v) {
                            String key = param.toLowerCase() + v;
                            if (!dims.containsKey(key)) continue;
                            selectedBands.add((Integer)dims.get(key));
                        }
                        continue;
                    }
                    for (String band : bands = values.split(",")) {
                        String key = param.toLowerCase() + band;
                        if (!dims.containsKey(key)) continue;
                        selectedBands.add((Integer)dims.get(key));
                    }
                    if (!selectedBands.isEmpty()) continue;
                    throw new Exception("WRONG PARAM VALUES.");
                }
                catch (Exception e) {
                    throw new WcsException("Band parameters incorrectly specified: " + e.getLocalizedMessage());
                }
            }
        }
        int length = selectedBands.size();
        int[] bands = new int[length];
        for (int b = 0; b < length; ++b) {
            bands[b] = (Integer)selectedBands.get(b);
        }
        return WCSUtils.bandSelect(coverage, bands);
    }

    public static Coverage bandSelect(GridCoverage coverage, int[] bands) {
        GridCoverage bandSelectedCoverage;
        if (bands != null && bands.length > 0) {
            ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("SampleDimensions").setValue((Object)bands);
            bandSelectedCoverage = ((SelectSampleDimension)PROCESSOR.getOperation("SelectSampleDimension")).doOperation(param, hints);
        } else {
            bandSelectedCoverage = coverage;
        }
        return bandSelectedCoverage;
    }

    public static void checkOutputLimits(WCSInfo info, GridEnvelope2D gridRange2D, SampleModel sampleModel) {
        long limit = info.getMaxOutputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getCoverageSize(gridRange2D, sampleModel);
        if (actual > limit) {
            throw new WcsException("This request is trying to generate too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be written in the output is " + WCSUtils.formatBytes(actual));
        }
    }

    public static void checkInputLimits(WCSInfo info, GridCoverage2D coverage) {
        if (coverage == null) {
            return;
        }
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getReadCoverageSize(coverage);
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static long getReadCoverageSize(GridCoverage2D coverage) {
        RenderedOp op;
        String operationName;
        RenderedImage ri = coverage.getRenderedImage();
        GridEnvelope2D gridEnvelope = coverage.getGridGeometry().getGridRange2D();
        if (WCSUtils.isDeferredLoaded(ri) && ("Crop".equals(operationName = (op = (RenderedOp)ri).getOperationName()) || "Mosaic".equals(operationName) && op.getNumSources() == 1)) {
            gridEnvelope = WCSUtils.getCropTilesEnvelope(op);
        }
        return WCSUtils.getCoverageSize(gridEnvelope, ri.getSampleModel());
    }

    private static GridEnvelope2D getCropTilesEnvelope(RenderedOp crop) {
        RenderedImage source = (RenderedImage)crop.getSources().get(0);
        Rectangle bounds = crop.getBounds();
        int tileXOffset = source.getTileGridXOffset();
        int tileYOffset = source.getTileGridYOffset();
        int tileWidth = source.getTileWidth();
        int tileHeight = source.getTileHeight();
        int tileMinX = WCSUtils.snapToTileGrid(bounds.x, tileXOffset, tileWidth);
        int tileMinY = WCSUtils.snapToTileGrid(bounds.y, tileYOffset, tileHeight);
        int tileMaxX = WCSUtils.snapToTileGrid(bounds.x + bounds.width, tileXOffset, tileWidth);
        int tileMaxY = WCSUtils.snapToTileGrid(bounds.y + bounds.height, tileYOffset, tileHeight);
        int minReadX = Math.max(tileXOffset + tileMinX * tileWidth, source.getMinX());
        int minReadY = Math.max(tileYOffset + tileMinY * tileHeight, source.getMinY());
        int maxReadX = Math.min(tileXOffset + (tileMaxX + 1) * tileWidth, source.getMinX() + source.getWidth());
        int maxReadY = Math.min(tileYOffset + (tileMaxY + 1) * tileHeight, source.getMinY() + source.getHeight());
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(minReadX, minReadY, maxReadX - minReadX, maxReadY - minReadY);
        return gridEnvelope;
    }

    private static int snapToTileGrid(int position, int offset, int tileSize) {
        return (position - offset) / tileSize;
    }

    static long getCoverageSize(GridEnvelope2D envelope, SampleModel sm) {
        long pixelsNumber = WCSUtils.computePixelsNumber(envelope);
        long pixelSize = 0L;
        int numBands = sm.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            pixelSize += (long)sm.getSampleSize(i);
        }
        return pixelsNumber * pixelSize / 8L;
    }

    public static void checkInputLimits(WCSInfo info, CoverageInfo meta, GridCoverage2DReader reader, GridGeometry2D gridGeometry) throws WcsException {
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = 0L;
        try {
            GeneralBounds requestedEnvelope = new GeneralBounds(gridGeometry.getEnvelope());
            CoordinateReferenceSystem requestCRS = requestedEnvelope.getCoordinateReferenceSystem();
            CoordinateReferenceSystem nativeCRS = reader.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                requestedEnvelope = CRS.transform((Bounds)requestedEnvelope, (CoordinateReferenceSystem)nativeCRS);
            }
            requestedEnvelope.intersect((Bounds)reader.getOriginalEnvelope());
            if (!requestedEnvelope.isEmpty()) {
                MathTransform crsToGrid = meta.getGrid().getGridToCRS().inverse();
                GeneralBounds requestedGrid = CRS.transform((MathTransform)crsToGrid, (Bounds)requestedEnvelope);
                double[] spans = new double[requestedGrid.getDimension()];
                double[] resolutions = new double[requestedGrid.getDimension()];
                for (int i = 0; i < spans.length; ++i) {
                    spans[i] = requestedGrid.getSpan(i);
                    resolutions[i] = requestedEnvelope.getSpan(i) / spans[i];
                }
                OverviewPolicy policy = info.getOverviewPolicy();
                double[] readResoutions = reader.getReadingResolutions(policy, resolutions);
                double[] baseResolutions = reader.getReadingResolutions(OverviewPolicy.IGNORE, resolutions);
                for (int i = 0; i < spans.length; ++i) {
                    int n = i;
                    spans[n] = spans[n] * (readResoutions[i] / baseResolutions[i]);
                }
                long pixels = 1L;
                for (int i = 0; i < requestedGrid.getDimension(); ++i) {
                    pixels = (long)((double)pixels * Math.ceil(requestedGrid.getSpan(i)));
                }
                long pixelSize = 0L;
                if (meta.getDimensions() != null) {
                    for (CoverageDimensionInfo dimension : meta.getDimensions()) {
                        int size = WCSUtils.guessSizeFromRange(dimension.getRange());
                        if (size == 0) {
                            LOGGER.log(Level.INFO, "Failed to guess the size of dimension " + dimension.getName() + ", skipping the pre-read check");
                            pixelSize = -1L;
                            break;
                        }
                        pixelSize += (long)size;
                    }
                }
                actual = pixels * pixelSize / 8L;
            }
        }
        catch (Throwable t) {
            throw new WcsException("An error occurred while checking serving limits", t);
        }
        if (actual < 0L) {
            LOGGER.log(Level.INFO, "Warning, we could not estimate the amount of bytes to be read from the coverage source for the current request");
        }
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static int guessSizeFromRange(NumberRange range) {
        double min = range.getMinimum();
        double max = range.getMaximum();
        double diff = max - min;
        if (diff <= 255.0) {
            return 8;
        }
        if (diff <= 65535.0) {
            return 16;
        }
        if (diff <= 4.294967295E9) {
            return 32;
        }
        if (diff <= 3.4028234663852886E38) {
            return 32;
        }
        return 64;
    }

    static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return new DecimalFormat("#.##").format((double)bytes / 1024.0) + "KB";
        }
        return new DecimalFormat("#.##").format((double)bytes / 1024.0 / 1024.0) + "MB";
    }

    public static Hints getReaderHints(WCSInfo wcs) {
        Hints hints = new Hints();
        hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        if (wcs.getOverviewPolicy() == null) {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
        } else {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)wcs.getOverviewPolicy()));
        }
        hints.put((Object)Hints.DECIMATION_POLICY, (Object)(wcs.isSubsamplingEnabled() ? DecimationPolicy.ALLOW : DecimationPolicy.DISALLOW));
        return hints;
    }

    public static Filter getRequestFilter() {
        List list;
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return null;
        }
        Object filter = request.getKvp().get("FILTER");
        if (!(filter instanceof Filter) && (filter = request.getKvp().get("CQL_FILTER")) instanceof List && !(list = (List)filter).isEmpty()) {
            filter = list.get(0);
        }
        if (!(filter instanceof Filter)) {
            filter = request.getKvp().get("FEATURE_ID");
        }
        if (filter instanceof Filter) {
            return (Filter)filter;
        }
        return null;
    }

    public static void checkOutputLimits(WCSInfo wcs, GridCoverage2D gc, int[] indexes) {
        long limit = wcs.getMaxOutputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long pixelsNumber = WCSUtils.computePixelsNumber(gc.getGridGeometry().getGridRange2D());
        long pixelSize = 0L;
        RenderedImage image = gc.getRenderedImage();
        SampleModel sm = image.getSampleModel();
        for (int band : indexes) {
            pixelSize += (long)sm.getSampleSize(band);
        }
        long actual = pixelsNumber * pixelSize / 8L;
        if (actual > limit) {
            throw new WcsException("This request is trying to generate too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be written in the output is " + WCSUtils.formatBytes(actual));
        }
    }

    private static long computePixelsNumber(GridEnvelope2D rasterEnvelope) {
        long pixelsNumber = 1L;
        int dimensions = rasterEnvelope.getDimension();
        for (int i = 0; i < dimensions; ++i) {
            pixelsNumber *= (long)rasterEnvelope.getSpan(i);
        }
        return pixelsNumber;
    }

    public static <T> GeneralParameterValue[] replaceParameter(GeneralParameterValue[] readParameters, Object value, ParameterDescriptor<T> pd) {
        for (GeneralParameterValue gpv : readParameters) {
            if (!gpv.getDescriptor().getName().equals(pd.getName())) continue;
            ((ParameterValue)gpv).setValue(value);
            return readParameters;
        }
        GeneralParameterValue[] readParametersClone = new GeneralParameterValue[readParameters.length + 1];
        System.arraycopy(readParameters, 0, readParametersClone, 0, readParameters.length);
        ParameterValue pv = pd.createValue();
        pv.setValue(value);
        readParametersClone[readParameters.length] = pv;
        return readParametersClone;
    }

    public static ReferencedEnvelope fitEnvelope(CoverageInfo ci, GridCoverage2DReader reader) {
        try {
            ReferencedEnvelope bounds = ci.boundingBox();
            return WCSUtils.fitEnvelope(bounds, reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fit the grid geometry to the declared envelope/crs", e);
        }
    }

    protected static ReferencedEnvelope fitEnvelope(ReferencedEnvelope bounds, GridCoverage2DReader reader) {
        if (WCSUtils.fitUnecessary(bounds, reader)) {
            return bounds;
        }
        if (!WCSUtils.simpleFitSupported(bounds, reader)) {
            return bounds;
        }
        return WCSUtils.simpleEnvelopeFit(bounds, reader);
    }

    private static ReferencedEnvelope simpleEnvelopeFit(ReferencedEnvelope bounds, GridCoverage2DReader reader) {
        GeneralBounds original = reader.getOriginalEnvelope();
        AffineTransform2D at = (AffineTransform2D)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        double scaleX = Math.abs(at.getScaleX());
        double minX = WCSUtils.fit(bounds.getMinimum(0), original.getMinimum(0), scaleX);
        double maxX = WCSUtils.fit(bounds.getMaximum(0), original.getMaximum(0), scaleX);
        if (maxX <= minX) {
            maxX = minX + scaleX;
        }
        double scaleY = Math.abs(at.getScaleY());
        double minY = WCSUtils.fit(bounds.getMinimum(1), original.getMinimum(1), scaleY);
        double maxY = WCSUtils.fit(bounds.getMaximum(1), original.getMaximum(1), scaleY);
        if (maxY <= minY) {
            maxY = minY + scaleY;
        }
        return new ReferencedEnvelope(minX, maxX, minY, maxY, bounds.getCoordinateReferenceSystem());
    }

    private static boolean simpleFitSupported(ReferencedEnvelope bounds, GridCoverage2DReader reader) {
        if (!CRS.equalsIgnoreMetadata((Object)bounds.getCoordinateReferenceSystem(), (Object)reader.getCoordinateReferenceSystem())) {
            LOGGER.fine("Cannot fit the declared envelope to native grid: reprojection is being used");
            return false;
        }
        MathTransform tx = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        if (!(tx instanceof AffineTransform2D)) {
            LOGGER.fine("Cannot fit the declared envelope to native grid: grid to world is not an affine");
            return false;
        }
        AffineTransform2D at = (AffineTransform2D)tx;
        if (Math.abs(at.getShearX()) > 0.001 || Math.abs(at.getShearY()) > 0.001) {
            LOGGER.fine("Cannot fit the declared envelope to native grid: grid to world affine has shear factors");
            return false;
        }
        return true;
    }

    private static boolean fitUnecessary(ReferencedEnvelope bounds, GridCoverage2DReader reader) {
        return bounds.equals((Object)ReferencedEnvelope.reference((Bounds)reader.getOriginalEnvelope()));
    }

    private static double fit(double cornerValue, double origin, double scale) {
        DD cv = DD.valueOf((double)cornerValue);
        DD px = cv.subtract(origin).divide(scale);
        DD roundPx = WCSUtils.roundDD(px);
        double fit = cv.subtract(px.subtract(roundPx).multiply(scale)).doubleValue();
        return fit;
    }

    private static DD roundDD(DD x) {
        DD xFloor;
        DD spaceBelow;
        DD xCeil = x.ceil();
        DD spaceAbove = xCeil.subtract(x);
        DD roundPx = spaceAbove.compareTo((Object)(spaceBelow = x.subtract(xFloor = x.floor()))) < 0 ? xCeil : xFloor;
        return roundPx;
    }

    public static GridGeometry2D fitGridGeometry(CoverageInfo ci, GridCoverage2DReader reader) {
        MathTransform gridToWorld = reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER);
        GridGeometry2D nativeGridGeometry = new GridGeometry2D(reader.getOriginalGridRange(), gridToWorld, reader.getCoordinateReferenceSystem());
        try {
            ReferencedEnvelope nativeEnvelope = ci.boundingBox();
            if (WCSUtils.fitUnecessary(nativeEnvelope, reader)) {
                return nativeGridGeometry;
            }
            if (!WCSUtils.simpleFitSupported(nativeEnvelope, reader)) {
                return WCSUtils.reprojectGridGeometryFit(reader, nativeEnvelope);
            }
            return WCSUtils.simpleGridGeometryFit(WCSUtils.simpleEnvelopeFit(nativeEnvelope, reader), (AffineTransform2D)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fit the grid geometry to the declared envelope/crs", e);
        }
    }

    private static GridGeometry2D reprojectGridGeometryFit(GridCoverage2DReader reader, ReferencedEnvelope envelope) {
        AffineTransform2D originalG2W = (AffineTransform2D)reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        double scale = XAffineTransform.getScale((AffineTransform)originalG2W);
        GeneralBounds originalEnvelope = reader.getOriginalEnvelope();
        AffineTransform2D g2w = new AffineTransform2D(scale, 0.0, 0.0, -scale, originalEnvelope.getMinimum(0), originalEnvelope.getMaximum(1));
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridEnvelope range = reader.getOriginalGridRange();
        RenderedOp image = ConstantDescriptor.create((Float)Float.valueOf(range.getSpan(0)), (Float)Float.valueOf(range.getSpan(1)), (Number[])new Byte[]{(byte)0}, null);
        GridCoverage2D sampleCoverage = factory.create((CharSequence)"sample", (RenderedImage)image, originalEnvelope.getCoordinateReferenceSystem(), (MathTransform)g2w, null, null, null);
        CoverageProcessor processor = CoverageProcessor.getInstance();
        Operation operation = processor.getOperation("Resample");
        ParameterValueGroup param = operation.getParameters().clone();
        param.parameter("source").setValue((Object)sampleCoverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)envelope.getCoordinateReferenceSystem());
        GridCoverage2D reprojected = (GridCoverage2D)processor.doOperation(param, hints);
        GridGeometry2D gg = reprojected.getGridGeometry();
        return WCSUtils.simpleGridGeometryFit(envelope, (AffineTransform2D)gg.getGridToCRS(PixelInCell.CELL_CORNER));
    }

    private static GridGeometry2D simpleGridGeometryFit(ReferencedEnvelope envelope, AffineTransform2D g2w) {
        AffineTransform2D fittedG2W = new AffineTransform2D(g2w.getScaleX(), g2w.getShearX(), g2w.getShearY(), g2w.getScaleY(), envelope.getMinimum(0), envelope.getMaximum(1));
        try {
            GeneralBounds gridEnvelope = CRS.transform((MathTransform)fittedG2W.inverse(), (Bounds)envelope);
            GridEnvelope2D fittedGridRange = new GridEnvelope2D(0, 0, (int)Math.round(gridEnvelope.getSpan(0)), (int)Math.round(gridEnvelope.getSpan(1)));
            return new GridGeometry2D((GridEnvelope)fittedGridRange, (MathTransform)fittedG2W, envelope.getCoordinateReferenceSystem());
        }
        catch (TransformException e) {
            throw new RuntimeException("Failed to invert grid to world", e);
        }
    }

    public static boolean isDeferredLoaded(GridCoverage2D coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        return WCSUtils.isDeferredLoaded(ri);
    }

    private static boolean isDeferredLoaded(RenderedImage ri) {
        if (ri instanceof RenderedOp) {
            RenderedOp rop = (RenderedOp)ri;
            if ("ImageRead".equals(rop.getOperationName())) {
                return true;
            }
            for (Object source : rop.getSources()) {
                if (!(source instanceof RenderedImage) || !WCSUtils.isDeferredLoaded((RenderedImage)source)) continue;
                return true;
            }
        }
        return false;
    }
}

