/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security.xml;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.geoserver.rest.security.AuthenticationFilterChainRestController;
import org.geoserver.security.HTTPMethod;
import org.geoserver.security.RequestFilterChain;

@XStreamAlias(value="filterChain")
public class AuthFilterChain {
    private String name;
    private String className;
    private List<String> patterns;
    private List<String> filters;
    private boolean disabled;
    private boolean allowSessionCreation;
    private boolean requireSSL;
    private boolean matchHTTPMethod;
    private Set<String> httpMethods;
    private String roleFilterName;
    private int position;

    public AuthFilterChain() {
    }

    public AuthFilterChain(RequestFilterChain requestFilterChain) {
        this.name = requestFilterChain.getName();
        this.className = requestFilterChain.getClass().getName();
        this.patterns = requestFilterChain.getPatterns();
        this.filters = requestFilterChain.getFilterNames();
        this.disabled = requestFilterChain.isDisabled();
        this.allowSessionCreation = requestFilterChain.isAllowSessionCreation();
        this.requireSSL = requestFilterChain.isRequireSSL();
        this.matchHTTPMethod = requestFilterChain.isMatchHTTPMethod();
        this.httpMethods = requestFilterChain.getHttpMethods().stream().map(Enum::name).collect(Collectors.toSet());
        this.roleFilterName = requestFilterChain.getRoleFilterName();
    }

    public RequestFilterChain toRequestFilterChain() {
        RequestFilterChain filterChain = this.createInstance(this.patterns);
        filterChain.setName(this.name);
        filterChain.setPatterns(this.patterns);
        filterChain.setFilterNames(this.filters);
        filterChain.setDisabled(this.disabled);
        filterChain.setAllowSessionCreation(this.allowSessionCreation);
        filterChain.setRequireSSL(this.requireSSL);
        filterChain.setMatchHTTPMethod(this.matchHTTPMethod);
        if (this.httpMethods != null) {
            filterChain.setHttpMethods(this.httpMethods.stream().map(HTTPMethod::valueOf).collect(Collectors.toSet()));
        }
        filterChain.setRoleFilterName(this.roleFilterName);
        return filterChain;
    }

    private RequestFilterChain createInstance(List<String> patterns) {
        try {
            Class<?> clazz = Class.forName(this.className);
            Optional<Constructor<?>> possibleConstructor = Arrays.stream(clazz.getDeclaredConstructors()).filter(AuthFilterChain.matchesStringArrayConstructor()).findFirst();
            if (possibleConstructor.isPresent()) {
                return (RequestFilterChain)possibleConstructor.get().newInstance(new Object[]{patterns.toArray(new String[0])});
            }
            throw new AuthenticationFilterChainRestController.CannotMakeChain(this.className, new InstantiationException("Cannot find a constructor with a single String[] parameter"));
        }
        catch (ReflectiveOperationException e) {
            throw new AuthenticationFilterChainRestController.CannotMakeChain(this.className, e);
        }
    }

    private static Predicate<Constructor<?>> matchesStringArrayConstructor() {
        return c -> {
            Class<?>[] parameterTypes = c.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0].isArray() && parameterTypes[0].getComponentType() == String.class;
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isRequireSSL() {
        return this.requireSSL;
    }

    public void setRequireSSL(boolean requireSSL) {
        this.requireSSL = requireSSL;
    }

    public boolean isMatchHTTPMethod() {
        return this.matchHTTPMethod;
    }

    public void setMatchHTTPMethod(boolean matchHTTPMethod) {
        this.matchHTTPMethod = matchHTTPMethod;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(Set<String> httpMethods) {
        this.httpMethods = httpMethods;
    }

    public String getRoleFilterName() {
        return this.roleFilterName;
    }

    public void setRoleFilterName(String roleFilterName) {
        this.roleFilterName = roleFilterName;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

