/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.security.xml.AuthFilterChain;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController(value="authenticationFilterChainRestController")
@RequestMapping(path={"/rest/security/filterChains"})
@ControllerAdvice(assignableTypes={AuthenticationFilterChainRestController.class})
public class AuthenticationFilterChainRestController
extends RestBaseController {
    private final GeoServerSecurityManager securityManager;

    public AuthenticationFilterChainRestController(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    @GetMapping(produces={"application/json", "application/xml"})
    public RestWrapper<AuthFilterChain> list() {
        this.checkAuthorisation();
        List<AuthFilterChain> filterChains = this.listFilterChains();
        return this.wrapList(filterChains, AuthFilterChain.class);
    }

    @GetMapping(value={"/{chainName}"}, produces={"application/json", "application/xml"})
    public RestWrapper<AuthFilterChain> view(@PathVariable(value="chainName") String chainName) {
        this.checkAuthorisation();
        AuthFilterChain filterChain = this.viewFilterChain(chainName);
        return this.wrapObject(filterChain, AuthFilterChain.class);
    }

    @PostMapping(consumes={"application/json", "application/xml"})
    public ResponseEntity<String> create(@RequestBody AuthFilterChain authFilterChain, UriComponentsBuilder builder) {
        this.checkAuthorisation();
        RequestFilterChain filterChain = authFilterChain.toRequestFilterChain();
        AuthFilterChain savedFilterChain = this.saveFilterChain(filterChain, authFilterChain.getPosition());
        HttpHeaders headers = new HttpHeaders();
        UriComponents uriComponents = builder.path("/security/filterChains/{chainName}").buildAndExpand(new Object[]{savedFilterChain.getName()});
        headers.setLocation(uriComponents.toUri());
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)authFilterChain.getName(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"/{chainName}"}, consumes={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public void update(@PathVariable(value="chainName") String chainName, @RequestBody AuthFilterChain authFilterChain) {
        this.checkAuthorisation();
        RequestFilterChain filterChain = authFilterChain.toRequestFilterChain();
        this.updateFilterChain(chainName, filterChain, authFilterChain.getPosition());
    }

    @DeleteMapping(value={"/{chainName}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="chainName") String chainName) {
        this.checkAuthorisation();
        this.deleteFilterChain(chainName);
    }

    @ExceptionHandler(value={CannotMakeChain.class})
    public ResponseEntity<ErrorResponse> handleRestException(CannotMakeChain exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotSaveConfig.class})
    public ResponseEntity<ErrorResponse> handleRestException(CannotSaveConfig exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotUpdateConfig.class})
    public ResponseEntity<ErrorResponse> handleRestException(CannotUpdateConfig exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={CannotReadConfig.class})
    public ResponseEntity<ErrorResponse> handleRestException(CannotReadConfig exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={BadRequest.class})
    public ResponseEntity<ErrorResponse> handleRestException(BadRequest exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NothingToDelete.class})
    public ResponseEntity<ErrorResponse> handleRestException(NothingToDelete exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.GONE.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.GONE);
    }

    @ExceptionHandler(value={DuplicateChainName.class})
    public ResponseEntity<ErrorResponse> handleRestException(DuplicateChainName exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FilterChainNotFound.class})
    public ResponseEntity<ErrorResponse> handleRestException(FilterChainNotFound exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.NOT_FOUND.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={NotAuthorised.class})
    public ResponseEntity<ErrorResponse> handleRestException(NotAuthorised exception) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.FORBIDDEN.value(), exception.getMessage());
        return new ResponseEntity((Object)errorResponse, HttpStatus.FORBIDDEN);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        this.checkAuthorisation();
        return AuthFilterChain.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter ignoredConverter) {
        XStream xstream = persister.getXStream();
        xstream.allowTypesByWildcard(new String[]{"org.geoserver.rest.security.xml.*"});
        xstream.processAnnotations(new Class[]{AuthFilterChain.class});
    }

    private List<AuthFilterChain> listFilterChains() {
        try {
            Preconditions.checkState((this.securityManager != null ? 1 : 0) != 0, (Object)"GeoServerSecurityManager not initialized");
            SecurityManagerConfig config = this.securityManager.loadSecurityConfig();
            List chains = config.getFilterChain().getRequestChains();
            return chains.stream().filter(Objects::nonNull).map(AuthFilterChain::new).peek(chain -> {
                RequestFilterChain filterChain = chains.stream().filter(c -> c.getName().equals(chain.getName())).findFirst().orElse(null);
                int position = filterChain != null ? chains.indexOf(filterChain) : 0;
                chain.setPosition(position);
            }).collect(Collectors.toList());
        }
        catch (IOException ex) {
            throw new CannotReadConfig(ex);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
    }

    private AuthFilterChain viewFilterChain(String chainName) {
        try {
            Preconditions.checkState((this.securityManager != null ? 1 : 0) != 0, (Object)"GeoServerSecurityManager not initialized");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)chainName) ? 1 : 0) != 0, (Object)"chainName is required");
            SecurityManagerConfig config = this.securityManager.loadSecurityConfig();
            RequestFilterChain chain = config.getFilterChain().getRequestChainByName(chainName);
            if (chain == null) {
                throw new FilterChainNotFound(chainName);
            }
            AuthFilterChain authFilterChain = new AuthFilterChain(chain);
            authFilterChain.setPosition(config.getFilterChain().getRequestChains().indexOf(chain));
            return authFilterChain;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (IOException e) {
            throw new CannotReadConfig(e);
        }
    }

    private void deleteFilterChain(String chainName) {
        try {
            Preconditions.checkState((this.securityManager != null ? 1 : 0) != 0, (Object)"GeoServerSecurityManager not initialized");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)chainName) ? 1 : 0) != 0, (Object)"chainName is required");
            SecurityManagerConfig config = this.securityManager.loadSecurityConfig();
            GeoServerSecurityFilterChain chain = config.getFilterChain();
            RequestFilterChain filterChain = chain.getRequestChains().stream().filter(c -> c.getName().equals(chainName)).findFirst().orElse(null);
            if (filterChain == null) {
                throw new NothingToDelete(chainName);
            }
            Preconditions.checkArgument((boolean)filterChain.canBeRemoved(), (Object)("Filter chain " + chainName + " cannot be removed."));
            if (!chain.getRequestChains().remove(filterChain)) {
                throw new NothingToDelete(chainName);
            }
            this.saveAndReturnAuthFilterChain(filterChain, config, chain.getRequestChains());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (IOException e) {
            throw new CannotUpdateConfig(e);
        }
    }

    private void updateFilterChain(String chainName, RequestFilterChain filterChain, int position) throws CannotSaveConfig {
        try {
            Preconditions.checkState((this.securityManager != null ? 1 : 0) != 0, (Object)"GeoServerSecurityManager not initialized");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)chainName) ? 1 : 0) != 0, (Object)"chainName is required");
            Preconditions.checkArgument((boolean)Objects.equals(filterChain.getName(), chainName), (Object)"chainName must be the same as the name of the filter chain to be updated");
            Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be greater than or equal to 0");
            SecurityManagerConfig config = this.securityManager.loadSecurityConfig();
            List chains = config.getFilterChain().getRequestChains();
            Preconditions.checkArgument((position < chains.size() ? 1 : 0) != 0, (Object)"position must be less than the number of filter chains");
            List<RequestFilterChain> updatedChains = chains.stream().map(chain -> chain.getName().equals(chainName) ? filterChain : chain).collect(Collectors.toList());
            if (position != updatedChains.indexOf(filterChain)) {
                updatedChains.remove(filterChain);
                updatedChains.add(position, filterChain);
            }
            this.saveAndReturnAuthFilterChain(filterChain, config, updatedChains);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (IOException | IllegalStateException e) {
            throw new CannotSaveConfig(e);
        }
    }

    private AuthFilterChain saveFilterChain(RequestFilterChain filterChain, int position) {
        try {
            Preconditions.checkState((this.securityManager != null ? 1 : 0) != 0, (Object)"GeoServerSecurityManager not initialized");
            Preconditions.checkArgument((boolean)Objects.nonNull(filterChain), (Object)"filterChain is required");
            Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be greater than or equal to 0");
            SecurityManagerConfig config = this.securityManager.loadSecurityConfig();
            List chains = config.getFilterChain().getRequestChains();
            if (chains.contains(filterChain)) {
                throw new DuplicateChainName(filterChain.getName());
            }
            chains.add(position, filterChain);
            return this.saveAndReturnAuthFilterChain(filterChain, config, chains);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest(e.getMessage());
        }
        catch (IOException | IllegalStateException e) {
            throw new CannotSaveConfig(e);
        }
    }

    private AuthFilterChain saveAndReturnAuthFilterChain(RequestFilterChain filterChain, SecurityManagerConfig config, List<RequestFilterChain> chains) {
        GeoServerSecurityFilterChain updateGeoServerFilterChains = new GeoServerSecurityFilterChain(chains);
        config.setFilterChain(updateGeoServerFilterChains);
        try {
            this.securityManager.saveSecurityConfig(config);
        }
        catch (Exception e) {
            throw new CannotSaveConfig(e);
        }
        this.securityManager.reload();
        AuthFilterChain authFilterChain = new AuthFilterChain(filterChain);
        authFilterChain.setPosition(chains.indexOf(filterChain));
        return authFilterChain;
    }

    private void checkAuthorisation() {
        if (!this.securityManager.checkAuthenticationForAdminRole()) {
            throw new NotAuthorised();
        }
    }

    public static class NotAuthorised
    extends RuntimeException {
        public NotAuthorised() {
            super("Admin role required to access this resource");
        }
    }

    public static class DuplicateChainName
    extends RuntimeException {
        public DuplicateChainName(String filterName) {
            super("Cannot create the filter chain " + filterName + " because one with that name already exists.");
        }
    }

    public static class FilterChainNotFound
    extends RuntimeException {
        public FilterChainNotFound(String filterName) {
            super("Cannot find the filter chain " + filterName + " in the Security configuration.");
        }
    }

    public static class BadRequest
    extends RuntimeException {
        public BadRequest(String message) {
            super(message);
        }
    }

    public static class NothingToDelete
    extends RuntimeException {
        public NothingToDelete(String filterName) {
            super("Cannot delete " + filterName + " as no filter exists");
        }
    }

    public static class CannotReadConfig
    extends RuntimeException {
        public CannotReadConfig(Exception ex) {
            super("Cannot read the Security configuration ", ex);
        }
    }

    public static class CannotUpdateConfig
    extends RuntimeException {
        public CannotUpdateConfig(Exception ex) {
            super("Cannot update the Security configuration ", ex);
        }
    }

    public static class CannotSaveConfig
    extends RuntimeException {
        public CannotSaveConfig(Exception ex) {
            super("Cannot save the Security configuration ", ex);
        }
    }

    public static class CannotMakeChain
    extends RuntimeException {
        public CannotMakeChain(String className, Exception ex) {
            super("Cannot make class " + className, ex);
        }
    }

    public static class ErrorResponse {
        private int status;
        private String message;

        public ErrorResponse(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

