/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.resources;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamJSONMessageConverter;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.resources.ResourceController;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class ResourceDirectoryInfoJSONConverter
extends XStreamJSONMessageConverter {
    protected boolean supports(Class<?> clazz) {
        return RestWrapper.class.isAssignableFrom(clazz) && !RestListWrapper.class.isAssignableFrom(clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.supports(clazz) && this.canWrite(mediaType);
    }

    public void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        ResourceController.ResourceDirectoryInfo dirInfo;
        RestWrapper restWrapper = (RestWrapper)o;
        Object object = restWrapper.getObject();
        if (object instanceof ResourceController.ResourceDirectoryInfo && 1 == (dirInfo = (ResourceController.ResourceDirectoryInfo)object).getChildren().size()) {
            boolean alwaysSerializeCollectionsAsArrays = true;
            XStreamPersister xmlPersister = this.xpf.createJSONPersister(alwaysSerializeCollectionsAsArrays);
            restWrapper.configurePersister(xmlPersister, (XStreamMessageConverter)this);
            this.writeSingleChildrenDirectoryInfo(dirInfo, xmlPersister, outputMessage.getBody());
            return;
        }
        super.writeInternal(o, outputMessage);
    }

    private void writeSingleChildrenDirectoryInfo(ResourceController.ResourceDirectoryInfo dirInfo, XStreamPersister xmlPersister, OutputStream out) throws IOException {
        SingleChildDirInfo info = new SingleChildDirInfo(dirInfo);
        XStream xstream = xmlPersister.getXStream();
        xstream.alias("ResourceDirectory", SingleChildDirInfo.class);
        CollectionConverter conv = new CollectionConverter(xstream.getMapper()){

            public boolean canConvert(Class type) {
                return Collection.class.isAssignableFrom(type);
            }

            protected void writeCompleteItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
                super.writeBareItem(item, context, writer);
            }
        };
        xstream.registerLocalConverter(Children.class, "child", (Converter)conv);
        xmlPersister.save((Object)info, out);
    }

    static class Children {
        List<ResourceController.ResourceChildInfo> child;

        Children(List<ResourceController.ResourceChildInfo> child) {
            this.child = child;
        }
    }

    static class SingleChildDirInfo {
        String name;
        ResourceController.ResourceParentInfo parent;
        String type;
        Date lastModified;
        Children children;

        public SingleChildDirInfo(ResourceController.ResourceDirectoryInfo info) {
            this.lastModified = info.getLastModified();
            this.name = info.getName();
            this.parent = info.getParent();
            this.type = info.getType();
            this.children = new Children(info.getChildren());
        }
    }
}

