/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.awt.RenderingHints;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AttributeTypeInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.catalog.FormatCollectionWrapper;
import org.geoserver.rest.catalog.MosaicInfoBBoxHandler;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.coverage.grid.io.GranuleRemovalPolicy;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/coveragestores/{storeName}/coverages/{coverageName}/index"})
public class StructuredCoverageController
extends AbstractCatalogController {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Autowired
    public StructuredCoverageController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/xml", "application/json", "text/json"})
    public RestWrapper<IndexSchema> indexGet(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName) throws IOException {
        GranuleSource source = this.getGranuleSource(workspaceName, storeName, coverageName);
        SimpleFeatureType schema = source.getSchema();
        List attributes = new CatalogBuilder(this.catalog).getAttributes((FeatureType)schema, null);
        IndexSchema indexSchema = new IndexSchema(attributes);
        return this.wrapObject(indexSchema, IndexSchema.class);
    }

    @GetMapping(path={"/granules"}, produces={"application/xml", "text/xml", "application/json", "text/json"})
    @ResponseBody
    public SimpleFeatureCollection granulesGet(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="offset", required=false) Integer offset, @RequestParam(name="limit", required=false) Integer limit) throws IOException {
        GranuleSource source = this.getGranuleSource(workspaceName, storeName, coverageName);
        Query q = this.toQuery(filter, offset, limit);
        return this.forceNonNullNamespace(source.getGranules(q));
    }

    @DeleteMapping(path={"/granules"})
    @ResponseBody
    public void granulesDelete(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="purge", required=false, defaultValue="none") String purge, @RequestParam(name="updateBBox", required=false) Boolean updateBBox) throws IOException {
        if (updateBBox == null) {
            updateBBox = false;
        }
        Query q = this.toQuery(filter, 0, 1);
        this.granulesDeleteInternal(workspaceName, storeName, coverageName, purge, q.getFilter(), updateBBox);
    }

    @GetMapping(path={"/granules/{granuleId:.+}"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public FormatCollectionWrapper granuleGet(@PathVariable String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @PathVariable String granuleId) throws IOException {
        Filter filter;
        Query q;
        GranuleSource source = this.getGranuleSource(workspaceName, storeName, coverageName);
        SimpleFeatureCollection granules = source.getGranules(q = new Query(null, filter = this.getGranuleIdFilter(granuleId)));
        if (granules.isEmpty()) {
            throw new ResourceNotFoundException("Could not find a granule with id " + granuleId + " in coverage " + coverageName);
        }
        SimpleFeatureCollection collection = this.forceNonNullNamespace(granules);
        if (granuleId.endsWith(".json")) {
            return new FormatCollectionWrapper.JSONCollectionWrapper(collection);
        }
        return new FormatCollectionWrapper.XMLCollectionWrapper(collection);
    }

    private Filter getGranuleIdFilter(String granuleId) {
        if (granuleId.endsWith(".xml")) {
            granuleId = granuleId.substring(0, granuleId.length() - 4);
        } else if (granuleId.endsWith(".json")) {
            granuleId = granuleId.substring(0, granuleId.length() - 5);
        }
        return FF.id(new FeatureId[]{FF.featureId(granuleId)});
    }

    @DeleteMapping(path={"/granules/{granuleId:.+}", "/granules/{granuleId:.+}/{format}"})
    @ResponseBody
    public void granuleDelete(@PathVariable(name="workspaceName") String workspaceName, @PathVariable String storeName, @PathVariable String coverageName, @PathVariable String granuleId, @RequestParam(name="purge", required=false, defaultValue="none") String purge, @RequestParam(name="updateBBox", required=false) Boolean updateBBox) throws IOException {
        if (updateBBox == null) {
            updateBBox = false;
        }
        Filter filter = this.getGranuleIdFilter(granuleId);
        this.granulesDeleteInternal(workspaceName, storeName, coverageName, purge, filter, updateBBox);
    }

    private void granulesDeleteInternal(String workspaceName, String storeName, String coverageName, String purge, Filter filter, boolean updateBBox) throws IOException {
        GranuleStore store = this.getGranuleStore(workspaceName, storeName, coverageName);
        if (purge != null) {
            GranuleRemovalPolicy policy = this.mapRemovalPolicy(purge);
            Hints hints = new Hints((RenderingHints.Key)Hints.GRANULE_REMOVAL_POLICY, (Object)policy);
            store.removeGranules(filter, hints);
        } else {
            store.removeGranules(filter);
        }
        if (updateBBox && (filter == null || !filter.equals(Filter.INCLUDE))) {
            new MosaicInfoBBoxHandler(this.catalog).updateNativeBBox(workspaceName, storeName, null);
        }
    }

    private GranuleRemovalPolicy mapRemovalPolicy(String key) {
        try {
            return GranuleRemovalPolicy.valueOf((String)key.toUpperCase());
        }
        catch (Exception e) {
            throw new RestException("Invalid purge value " + key + ", allowed values are " + Arrays.toString(GranuleRemovalPolicy.values()), HttpStatus.BAD_REQUEST);
        }
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return IndexSchema.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        XStream xstream = persister.getXStream();
        xstream.alias("Schema", IndexSchema.class);
        xstream.alias("Attribute", AttributeTypeInfo.class);
        xstream.omitField(AttributeTypeInfoImpl.class, "featureType");
        xstream.omitField(AttributeTypeInfoImpl.class, "metadata");
        ReflectionConverter rc = new ReflectionConverter(xstream.getMapper(), xstream.getReflectionProvider()){

            public boolean canConvert(Class type) {
                return type.equals(IndexSchema.class);
            }

            public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
                super.marshal(original, writer, context);
                converter.encodeLink("granules", writer);
            }
        };
        xstream.registerConverter((Converter)rc);
    }

    private GranuleSource getGranuleSource(String workspaceName, String storeName, String coverageName) throws IOException {
        CoverageInfo coverage = this.getExistingStructuredCoverage(workspaceName, storeName, coverageName);
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        String nativeCoverageName = this.getNativeCoverageName(coverage, reader);
        return reader.getGranules(nativeCoverageName, true);
    }

    private GranuleStore getGranuleStore(String workspaceName, String storeName, String coverageName) throws IOException {
        CoverageInfo coverage = this.getExistingStructuredCoverage(workspaceName, storeName, coverageName);
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)coverage.getGridCoverageReader(null, null);
        if (reader.isReadOnly()) {
            throw new RestException("Coverage " + coverage.prefixedName() + " is read ony", HttpStatus.METHOD_NOT_ALLOWED);
        }
        String nativeCoverageName = this.getNativeCoverageName(coverage, reader);
        return (GranuleStore)reader.getGranules(nativeCoverageName, false);
    }

    private String getNativeCoverageName(CoverageInfo coverage, StructuredGridCoverage2DReader reader) throws IOException {
        String nativeCoverageName = coverage.getNativeCoverageName();
        if (nativeCoverageName == null) {
            if (reader.getGridCoverageNames().length > 1) {
                throw new IllegalStateException("The grid coverage configuration for " + coverage.getName() + " does not specify a native coverage name, yet the reader provides more than one coverage. Please assign a native coverage name (the GUI does so automatically)");
            }
            nativeCoverageName = reader.getGridCoverageNames()[0];
        }
        return nativeCoverageName;
    }

    private SimpleFeatureCollection forceNonNullNamespace(SimpleFeatureCollection features) throws IOException {
        SimpleFeatureType sourceSchema = (SimpleFeatureType)features.getSchema();
        if (sourceSchema.getName().getNamespaceURI() == null) {
            try {
                String targetNs = "http://www.geoserver.org/rest/granules";
                AttributeDescriptor[] attributes = sourceSchema.getAttributeDescriptors().toArray(new AttributeDescriptor[sourceSchema.getAttributeDescriptors().size()]);
                SimpleFeatureType targetSchema = FeatureTypes.newFeatureType((AttributeDescriptor[])attributes, (String)sourceSchema.getName().getLocalPart(), (URI)new URI(targetNs));
                return new RetypingFeatureCollection(features, targetSchema);
            }
            catch (Exception e) {
                throw new IOException("Failed to retype the granules feature schema, in order to force it having a non null namespace", e);
            }
        }
        return features;
    }

    private CoverageInfo getExistingStructuredCoverage(String workspaceName, String storeName, String coverageName) {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspaceName);
        if (ws == null) {
            throw new ResourceNotFoundException("No such workspace : " + workspaceName);
        }
        CoverageStoreInfo store = this.catalog.getCoverageStoreByName(ws, storeName);
        if (store == null) {
            throw new ResourceNotFoundException("No such coverage store: " + storeName);
        }
        Optional<CoverageInfo> optCoverage = this.catalog.getCoveragesByStore(store).stream().filter(si -> coverageName.equals(si.getName())).findFirst();
        if (!optCoverage.isPresent()) {
            throw new ResourceNotFoundException("No such coverage in store: " + coverageName);
        }
        return optCoverage.get();
    }

    private Query toQuery(String filter, Integer offset, Integer limit) {
        Query q = new Query(Query.ALL);
        if (filter != null) {
            try {
                Filter ogcFilter = ECQL.toFilter((String)filter);
                q.setFilter(ogcFilter);
            }
            catch (CQLException e) {
                throw new RestException("Invalid cql syntax: " + e.getMessage(), HttpStatus.BAD_REQUEST);
            }
        }
        if (offset != null) {
            if (offset < 0) {
                throw new RestException("Invalid offset value: " + offset, HttpStatus.BAD_REQUEST);
            }
            q.setStartIndex(offset);
        }
        if (limit != null) {
            if (limit <= 0) {
                throw new RestException("Invalid limit value: " + offset, HttpStatus.BAD_REQUEST);
            }
            q.setMaxFeatures(limit.intValue());
        }
        return q;
    }

    static class IndexSchema {
        List<AttributeTypeInfo> attributes;

        public IndexSchema(List<AttributeTypeInfo> attributes) {
            this.attributes = attributes;
        }
    }
}

