/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geoserver.rest.util.MediaTypeExtensions;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class MapJSONConverter
extends BaseMessageConverter<Map<?, ?>> {
    public MapJSONConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, MediaTypeExtensions.TEXT_JSON});
    }

    protected boolean supports(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public Map<?, ?> readInternal(Class<? extends Map<?, ?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputMessage.getBody()));
        StringBuilder text = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            text.append(line);
        }
        return JSONObject.fromObject((Object)text.toString());
    }

    public void writeInternal(Map<?, ?> map, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputMessage.getBody()));
        ((Writer)outWriter).flush();
        JSON obj = (JSON)this.toJSONObject(map);
        obj.write((Writer)outWriter);
        ((Writer)outWriter).flush();
    }

    public Object toJSONObject(Object obj) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            JSONObject json = new JSONObject();
            for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                Object value = this.toJSONObject(entry.getValue());
                json.put((Object)key, value);
            }
            return json;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            JSONArray json = new JSONArray();
            for (Object object : collection) {
                Object value = this.toJSONObject(object);
                json.add(this.toJSONObject(value));
            }
            return json;
        }
        if (obj instanceof Number) {
            return obj;
        }
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj == null) {
            return JSONNull.getInstance();
        }
        return obj.toString();
    }
}

