/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/layers", "/rest/workspaces/{workspaceName}/layers"})
public class LayerController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(LayerController.class);

    @Autowired
    public LayerController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<LayerInfo> layersGet(@PathVariable(required=false) String workspaceName) {
        ArrayList layers;
        if (workspaceName == null) {
            layers = this.catalog.getLayers();
        } else {
            layers = new ArrayList();
            for (ResourceInfo resourceInfo : this.catalog.getResourcesByNamespace(workspaceName, ResourceInfo.class)) {
                layers.addAll(this.catalog.getLayers(resourceInfo));
            }
        }
        return this.wrapList(layers, LayerInfo.class);
    }

    @GetMapping(path={"/{layerName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<LayerInfo> layerGet(@PathVariable String layerName, @PathVariable(required=false) String workspaceName) {
        LayerInfo layer;
        if (workspaceName != null) {
            layerName = workspaceName + ":" + (String)layerName;
        }
        if ((layer = this.catalog.getLayerByName((String)layerName)) == null) {
            throw new ResourceNotFoundException("No such layer: " + (String)layerName);
        }
        return this.wrapObject(layer, LayerInfo.class);
    }

    @DeleteMapping(value={"/{layerName}"})
    public void layerDelete(@PathVariable String layerName, @PathVariable(required=false) String workspaceName, @RequestParam(name="recurse", required=false, defaultValue="false") boolean recurse) throws IOException {
        LayerInfo layer;
        if (workspaceName != null) {
            layerName = workspaceName + ":" + (String)layerName;
        }
        if ((layer = this.catalog.getLayerByName((String)layerName)) == null) {
            throw new ResourceNotFoundException((String)layerName);
        }
        if (!recurse) {
            this.catalog.remove(layer);
            LOGGER.info("DELETE layer '" + (String)layerName + "'");
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(layer);
            LOGGER.info("DELETE layer '" + (String)layerName + "' recurse=true");
        }
    }

    @PutMapping(value={"/{layerName}"})
    public void layerPut(@RequestBody LayerInfo layer, @PathVariable String layerName, @PathVariable(required=false) String workspaceName) {
        if (workspaceName != null) {
            layerName = workspaceName + ":" + (String)layerName;
        }
        LayerInfo original = this.catalog.getLayerByName((String)layerName);
        layer.setResource(original.getResource());
        CatalogBuilder session = new CatalogBuilder(this.catalog);
        session.updateLayer(original, layer);
        this.catalog.save(original);
        LOGGER.info("PUT layer " + (String)layerName);
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return LayerInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<LayerInfo> getObjectClass() {
                return LayerInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = LayerController.this.getURITemplateVariables();
                String layerName = (String)uriTemplateVars.get("layerName");
                if (layerName == null) {
                    return null;
                }
                return LayerController.this.catalog.getLayerByName(layerName);
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                StringBuilder link;
                if (obj instanceof StyleInfo) {
                    StyleInfo style = (StyleInfo)obj;
                    link = new StringBuilder();
                    if (style.getWorkspace() != null) {
                        String wsName = style.getWorkspace().getName();
                        writer.startNode("workspace");
                        writer.setValue(wsName);
                        writer.endNode();
                        link.append("/workspaces/").append(converter.encode(wsName));
                    }
                    link.append("/styles/").append(converter.encode(style.getName()));
                    converter.encodeLink(link.toString(), writer);
                }
                if (obj instanceof ResourceInfo) {
                    ResourceInfo r = (ResourceInfo)obj;
                    link = new StringBuilder("/workspaces/").append(converter.encode(r.getStore().getWorkspace().getName())).append("/");
                    if (r instanceof FeatureTypeInfo) {
                        link.append("datastores/").append(converter.encode(r.getStore().getName())).append("/featuretypes/");
                    } else if (r instanceof CoverageInfo) {
                        link.append("coveragestores/").append(converter.encode(r.getStore().getName())).append("/coverages/");
                    } else if (r instanceof WMSLayerInfo) {
                        link.append("wmsstores/").append(converter.encode(r.getStore().getName())).append("/wmslayers/");
                    } else {
                        return;
                    }
                    link.append(converter.encode(r.getName()));
                    converter.encodeLink(link.toString(), writer);
                }
            }
        });
    }
}

