/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.security.SecurityRESTTestSupport;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class UrlCheckControllerTest
extends SecurityRESTTestSupport {
    private URLCheckDAO urlCheckDao;

    @Before
    public void setUp() throws Exception {
        this.urlCheckDao = (URLCheckDAO)GeoServerExtensions.bean(URLCheckDAO.class, (ApplicationContext)applicationContext);
        RegexURLCheck check1 = new RegexURLCheck("check1", "regex check 1", "check1://.*");
        RegexURLCheck check2 = new RegexURLCheck("check2", "regex check 2", "check2://.*");
        RegexURLCheck check3 = new RegexURLCheck("check3", "regex check 3", "check3://.*");
        check2.setEnabled(false);
        this.urlCheckDao.saveChecks(List.of(check1, check2, check3));
    }

    @Test
    public void testGetAllAsXml() throws Exception {
        Document dom = this.getAsDOM("/rest/urlchecks.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//urlCheck)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check1", (String)"//urlCheck[1]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check1.xml", (String)"//urlCheck[1]/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check2", (String)"//urlCheck[2]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check2.xml", (String)"//urlCheck[2]/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check3", (String)"//urlCheck[3]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check3.xml", (String)"//urlCheck[3]/atom:link/@href", (Document)dom);
    }

    @Test
    public void testGetAllAsJson() throws Exception {
        JSON json = this.getAsJSON("/rest/urlchecks.json");
        JSONArray urlChecks = ((JSONObject)json).getJSONObject("urlChecks").getJSONArray("urlCheck");
        Assert.assertEquals((long)3L, (long)urlChecks.size());
        JSONObject check1 = urlChecks.getJSONObject(0);
        JSONObject check2 = urlChecks.getJSONObject(1);
        JSONObject check3 = urlChecks.getJSONObject(2);
        Assert.assertEquals((Object)"check1", (Object)check1.getString("name"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/urlchecks/check1.json", (Object)check1.getString("href"));
        Assert.assertEquals((Object)"check2", (Object)check2.getString("name"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/urlchecks/check2.json", (Object)check2.getString("href"));
        Assert.assertEquals((Object)"check3", (Object)check3.getString("name"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/urlchecks/check3.json", (Object)check3.getString("href"));
    }

    @Test
    public void testGetAllAsHtml() throws Exception {
        Document dom = this.getAsDOM("/rest/urlchecks.html");
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//html:li)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check1", (String)"//html:li[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check1.html", (String)"//html:li[1]/html:a/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check2", (String)"//html:li[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check2.html", (String)"//html:li[2]/html:a/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check3", (String)"//html:li[3]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/urlchecks/check3.html", (String)"//html:li[3]/html:a/@href", (Document)dom);
    }

    @Test
    public void testGetAsXml() throws Exception {
        Document dom = this.getAsDOM("/rest/urlchecks/check1.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/regexUrlCheck)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check1", (String)"/regexUrlCheck/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"regex check 1", (String)"/regexUrlCheck/description", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/regexUrlCheck/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"check1://.*", (String)"/regexUrlCheck/regex", (Document)dom);
    }

    @Test
    public void testGetAsJson() throws Exception {
        JSON json = this.getAsJSON("/rest/urlchecks/check2.json");
        JSONObject urlCheck = ((JSONObject)json).getJSONObject("regexUrlCheck");
        Assert.assertFalse((boolean)urlCheck.isNullObject());
        Assert.assertEquals((Object)"check2", (Object)urlCheck.getString("name"));
        Assert.assertEquals((Object)"regex check 2", (Object)urlCheck.getString("description"));
        Assert.assertEquals((Object)"false", (Object)urlCheck.getString("enabled"));
        Assert.assertEquals((Object)"check2://.*", (Object)urlCheck.getString("regex"));
    }

    @Test
    public void testGetAsHtml() throws Exception {
        Document dom = this.getAsDOM("/rest/urlchecks/check3.html");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//html:ul)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Name: check3", (String)"//html:li[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Description: regex check 3", (String)"//html:li[2]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Configuration: check3://.*", (String)"//html:li[3]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Enabled: true", (String)"//html:li[4]", (Document)dom);
    }

    @Test
    public void testGetUnknown() throws Exception {
        String checkName = "unknown";
        String requestPath = "/rest/urlchecks/" + checkName + ".html";
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)("No such URL check found: '" + checkName + "'"), (Object)response.getContentAsString());
    }

    @Test
    public void testPost() throws Exception {
        String checkJson = "{    \"regexUrlCheck\": {        \"name\": \"check\",        \"description\": \"this is another check\",        \"enabled\": \"true\",        \"regex\": \"http://example.com/.*\"    }}";
        String requestPath = "/rest/urlchecks";
        MockHttpServletResponse response = this.postAsServletResponse(requestPath, checkJson, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"check", (Object)response.getContentAsString());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/urlchecks/check", (Object)response.getHeader("location"));
        AbstractURLCheck check = this.urlCheckDao.getCheckByName("check");
        Assert.assertEquals((Object)"check", (Object)check.getName());
        Assert.assertEquals((Object)"this is another check", (Object)check.getDescription());
        Assert.assertTrue((boolean)check.isEnabled());
        Assert.assertEquals((Object)"http://example.com/.*", (Object)check.getConfiguration());
    }

    @Test
    public void testPostWhenAlreadyExists() throws Exception {
        String checkJson = "{    \"regexUrlCheck\": {        \"name\": \"check\",        \"description\": \"this is another check\",        \"enabled\": \"true\",        \"regex\": \"http://example.com/.*\"    }}";
        String requestPath = "/rest/urlchecks";
        this.postAsServletResponse(requestPath, checkJson, "application/json");
        MockHttpServletResponse response = this.postAsServletResponse(requestPath, checkJson, "application/json");
        Assert.assertEquals((long)409L, (long)response.getStatus());
        Assert.assertEquals((Object)"URL check 'check' already exists", (Object)response.getContentAsString());
    }

    @Test
    public void testPostWithoutName() throws Exception {
        String checkJson = "{    \"regexUrlCheck\": {        \"description\": \"this is another check\",        \"enabled\": \"true\",        \"regex\": \"http://example.com/.*\"    }}";
        String requestPath = "/rest/urlchecks";
        MockHttpServletResponse response = this.postAsServletResponse(requestPath, checkJson, "application/json");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"The URL check name is required", (Object)response.getContentAsString());
    }

    @Test
    public void testPostWithoutConfiguration() throws Exception {
        String checkJson = "{    \"regexUrlCheck\": {        \"name\": \"check\",        \"description\": \"this is another check\",        \"enabled\": \"true\"    }}";
        String requestPath = "/rest/urlchecks";
        MockHttpServletResponse response = this.postAsServletResponse(requestPath, checkJson, "application/json");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"The URL check configuration is required", (Object)response.getContentAsString());
    }

    @Test
    public void testPostWithoutEnabled() throws Exception {
        String checkJson = "{    \"regexUrlCheck\": {        \"name\": \"check\",        \"description\": \"this is another check\",        \"regex\": \"http://example.com/.*\"    }}";
        String requestPath = "/rest/urlchecks";
        MockHttpServletResponse response = this.postAsServletResponse(requestPath, checkJson, "application/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"check", (Object)response.getContentAsString());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/urlchecks/check", (Object)response.getHeader("location"));
        AbstractURLCheck check = this.urlCheckDao.getCheckByName("check");
        Assert.assertFalse((boolean)check.isEnabled());
    }

    @Test
    public void testPut() throws Exception {
        String editCheckJson = "{    \"regexUrlCheck\": {        \"name\": \"new-check\",        \"description\": \"new description\",        \"enabled\": \"false\",        \"regex\": \"new regex\"    }}";
        String requestPath = "/rest/urlchecks/check1";
        MockHttpServletResponse response = this.putAsServletResponse(requestPath, editCheckJson, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractURLCheck check = this.urlCheckDao.getCheckByName("new-check");
        Assert.assertEquals((Object)"new-check", (Object)check.getName());
        Assert.assertEquals((Object)"new description", (Object)check.getDescription());
        Assert.assertFalse((boolean)check.isEnabled());
        Assert.assertEquals((Object)"new regex", (Object)check.getConfiguration());
    }

    @Test
    public void testPutUnknown() throws Exception {
        String checkName = "unknown";
        String editCheckJson = "{\"regexUrlCheck\": {}}";
        String requestPath = "/rest/urlchecks/" + checkName;
        MockHttpServletResponse response = this.putAsServletResponse(requestPath, editCheckJson, "application/json");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)("Can't change a non existent URL check (" + checkName + ")"), (Object)response.getContentAsString());
    }

    @Test
    public void testPutWithEmptyConfiguration() throws Exception {
        String editCheckJson = "{\"regexUrlCheck\": {\"regex\": \"\"}}";
        String requestPath = "/rest/urlchecks/check1";
        MockHttpServletResponse response = this.putAsServletResponse(requestPath, editCheckJson, "application/json");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"The URL check configuration is required", (Object)response.getContentAsString());
    }

    @Test
    public void testPutNoChanges() throws Exception {
        String editCheckJson = "{\"regexUrlCheck\": {}}";
        String requestPath = "/rest/urlchecks/check1";
        MockHttpServletResponse response = this.putAsServletResponse(requestPath, editCheckJson, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractURLCheck check = this.urlCheckDao.getCheckByName("check1");
        Assert.assertEquals((Object)"check1", (Object)check.getName());
        Assert.assertEquals((Object)"regex check 1", (Object)check.getDescription());
        Assert.assertFalse((boolean)check.isEnabled());
        Assert.assertEquals((Object)"check1://.*", (Object)check.getConfiguration());
    }

    @Test
    public void testDelete() throws Exception {
        Thread.sleep(1000L);
        String requestPath = "/rest/urlchecks/check1";
        MockHttpServletResponse response = this.deleteAsServletResponse(requestPath);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        AbstractURLCheck check = this.urlCheckDao.getCheckByName("check1");
        Assert.assertNull((Object)check);
    }
}

