/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class AuthenticationFilterChainRestControllerMarshallingTest
extends GeoServerSystemTestSupport {
    private static XpathEngine xp;
    private static final String BASEPATH = "/rest";

    @BeforeClass
    public static void init() throws Exception {
        xp = XMLUnit.newXpathEngine();
        xp.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(Map.of("atom", "http://www.w3.org/2005/Atom")));
    }

    @Before
    public void setUp() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"password", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ADMINISTRATOR")));
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    @After
    public void after() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testList_XML() throws Exception {
        Document dom = this.getAsDOM("/rest/security/filterChains.xml", 200);
        NodeList nameNodes = xp.getMatchingNodes("//filterChain/name", dom);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < nameNodes.getLength(); ++i) {
            names.add(nameNodes.item(i).getTextContent());
        }
        names.forEach(name -> {
            String xpath = String.format("//filterChain[name='%s']/atom:link", name);
            try {
                NodeList link = xp.getMatchingNodes(xpath, dom);
                Assert.assertEquals((long)1L, (long)link.getLength());
                String href = link.item(0).getAttributes().getNamedItem("href").getTextContent();
                Assert.assertTrue((boolean)href.endsWith("/security/filterChains/" + name + ".xml"));
            }
            catch (XpathException e) {
                Assert.fail((String)("Xpath evaluation failed: " + e.getMessage()));
            }
        });
    }

    @Test
    public void testList_NotAuthorised() throws Exception {
        this.notAuthorised();
        this.getAsDOM("/rest/security/filterChains.xml", 403);
    }

    @Test
    public void testList_JSON() throws Exception {
        JSON json = this.getAsJSON("/rest/security/filterChains.json", 200);
        JSONArray filterChains = ((JSONObject)json).getJSONObject("filterChains").getJSONArray("filterChain");
        for (Object jsonObject : filterChains) {
            JSONObject filterChain = (JSONObject)jsonObject;
            String name = filterChain.getString("name");
            String href = filterChain.getString("href");
            Assert.assertTrue((boolean)href.endsWith("/security/filterChains/" + name + ".json"));
        }
    }

    @Test
    public void testView_XML() throws Exception {
        Document document = this.getAsDOM("/rest/security/filterChains/web.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"web", (String)"/filterChain/name", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"org.geoserver.security.HtmlLoginFilterChain", (String)"/filterChain/className", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/disabled", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/requireSSL", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/matchHTTPMethod", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/filterChain/position", (Document)document);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/filterChain/allowSessionCreation", (Document)document);
        NodeList patternNodes = xp.getMatchingNodes("/filterChain/patterns/string", document);
        Assert.assertEquals((long)3L, (long)patternNodes.getLength());
        NodeList filterNodes = xp.getMatchingNodes("/filterChain/filters/string", document);
        Assert.assertEquals((long)3L, (long)filterNodes.getLength());
    }

    @Test
    public void testView_Unauthorised() throws Exception {
        this.notAuthorised();
        this.getAsDOM("/rest/security/filterChains/web.xml", 403);
    }

    @Test
    public void testView_JSON() throws Exception {
        JSON json = this.getAsJSON("/rest/security/filterChains/web", 200);
        JSONObject jsonObject = ((JSONObject)json).getJSONObject("filterChain");
        Assert.assertEquals((Object)"web", (Object)jsonObject.getString("name"));
        Assert.assertEquals((Object)"org.geoserver.security.HtmlLoginFilterChain", (Object)jsonObject.getString("className"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("disabled"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("requireSSL"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("matchHTTPMethod"));
        Assert.assertEquals((Object)"0", (Object)jsonObject.getString("position"));
        Assert.assertEquals((Object)"true", (Object)jsonObject.getString("allowSessionCreation"));
        JSONArray patterns = jsonObject.getJSONObject("patterns").getJSONArray("string");
        Assert.assertEquals((long)3L, (long)patterns.size());
        JSONArray filters = jsonObject.getJSONObject("filters").optJSONArray("string");
        Assert.assertEquals((long)3L, (long)filters.size());
    }

    @Test
    public void testPost_XML() throws Exception {
        String document = this.getAsString("/rest/security/filterChains/web.xml");
        this.deleteAsServletResponse("/rest/security/filterChains/web");
        MockHttpServletResponse response = this.postAsServletResponse("/rest/security/filterChains", document, "application/xml");
        TestCase.assertEquals((int)201, (int)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String location = response.getHeader("Location");
        Assert.assertNotNull((Object)location);
        Assert.assertTrue((boolean)location.endsWith("/security/filterChains/web"));
        Document viewDocument = this.getAsDOM("/rest/security/filterChains/web.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"web", (String)"/filterChain/name", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"org.geoserver.security.HtmlLoginFilterChain", (String)"/filterChain/className", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/disabled", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/requireSSL", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/filterChain/matchHTTPMethod", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/filterChain/position", (Document)viewDocument);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/filterChain/allowSessionCreation", (Document)viewDocument);
    }

    @Test
    public void testPost_JSON() throws Exception {
        String json = this.getAsString("/rest/security/filterChains/web.json");
        this.deleteAsServletResponse("/rest/security/filterChains/web");
        MockHttpServletResponse response = this.postAsServletResponse("/rest/security/filterChains", json, "application/json");
        TestCase.assertEquals((int)201, (int)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String location = response.getHeader("Location");
        Assert.assertNotNull((Object)location);
        Assert.assertTrue((boolean)location.endsWith("/security/filterChains/web"));
        JSON viewJson = this.getAsJSON("/rest/security/filterChains/web", 200);
        JSONObject jsonObject = ((JSONObject)viewJson).getJSONObject("filterChain");
        Assert.assertEquals((Object)"web", (Object)jsonObject.getString("name"));
        Assert.assertEquals((Object)"org.geoserver.security.HtmlLoginFilterChain", (Object)jsonObject.getString("className"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("disabled"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("requireSSL"));
        Assert.assertEquals((Object)"false", (Object)jsonObject.getString("matchHTTPMethod"));
        Assert.assertEquals((Object)"0", (Object)jsonObject.getString("position"));
        Assert.assertEquals((Object)"true", (Object)jsonObject.getString("allowSessionCreation"));
    }

    @Test
    public void testPut_XML() throws Exception {
        String xml = this.getAsString("/rest/security/filterChains/web.xml");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/security/filterChains/web", xml, "application/xml");
        TestCase.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testPut_JSON() throws Exception {
        String json = this.getAsString("/rest/security/filterChains/web.json");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/security/filterChains/web", json, "application/json");
        TestCase.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testPut_NotAuthorised() throws Exception {
        this.notAuthorised();
        String json = this.getAsString("/rest/security/filterChains/web.json");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/security/filterChains/web", json, "application/json");
        TestCase.assertEquals((int)403, (int)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        String xml = this.getAsString("/rest/security/filterChains/web.xml");
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/security/filterChains/web");
        TestCase.assertEquals((int)200, (int)response.getStatus());
        MockHttpServletResponse viewResponse = this.getAsServletResponse("/rest/security/filterChains/web.xml");
        TestCase.assertEquals((int)404, (int)viewResponse.getStatus());
        MockHttpServletResponse restoreWeb = this.postAsServletResponse("/rest/security/filterChains", xml, "application/xml");
        TestCase.assertEquals((int)201, (int)restoreWeb.getStatus());
    }

    @Test
    public void testDelete_NotAuthorised() throws Exception {
        this.notAuthorised();
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/security/filterChains/web");
        TestCase.assertEquals((int)403, (int)response.getStatus());
    }

    private void notAuthorised() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

