/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.rest.security.SecurityRESTTestSupport;
import org.geoserver.security.CatalogMode;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@TestSetup(run=TestSetupFrequency.REPEAT)
public class AccessControllersTest
extends SecurityRESTTestSupport {
    static final String BASE_URI = "/rest/security/acl/";
    static final String DATA_URI = "/rest/security/acl/layers";
    static final String DATA_URI_XML = "/rest/security/acl/layers.xml";
    static final String DATA_URI_JSON = "/rest/security/acl/layers.json";
    static final String SERVICE_URI = "/rest/security/acl/services";
    static final String SERVICE_URI_XML = "/rest/security/acl/services.xml";
    static final String SERVICE_URI_JSON = "/rest/security/acl/services.json";
    static final String REST_URI = "/rest/security/acl/rest";
    static final String REST_URI_XML = "/rest/security/acl/rest.xml";
    static final String REST_URI_JSON = "/rest/security/acl/rest.json";
    static final String CATALOG_URI = "/rest/security/acl/catalog";
    static final String CATALOG_URI_XML = "/rest/security/acl/catalog.xml";
    static final String CATALOG_URI_JSON = "/rest/security/acl/catalog.json";
    private static final String TEST_ROLE1 = "TEST_ROLE1";
    private static final String TEST_ROLE2 = "TEST_ROLE2";
    private static final String TEST_ROLELIST = "TEST_ROLE1,TEST_ROLE2";

    String createXMLBody(String[][] rules) {
        StringBuilder buff = new StringBuilder();
        buff.append("<").append("rules").append(">\n");
        for (String[] rule : rules) {
            buff.append("<").append("rule").append(" ");
            buff.append("resource").append("=\"").append(rule[0]);
            buff.append("\">");
            buff.append(rule[1]);
            buff.append("</").append("rule").append(">\n");
        }
        buff.append("</").append("rules").append(">\n");
        return buff.toString();
    }

    String createJSONBody(String[][] rules) {
        JSONObject json = new JSONObject();
        for (String[] rule : rules) {
            json.put((Object)rule[0], (Object)rule[1]);
        }
        return json.toString(1);
    }

    void checkXMLResponse(Document dom, String[][] rules) throws XpathException {
        Assert.assertEquals((Object)"rules", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)rules.length, (long)dom.getDocumentElement().getElementsByTagName("rule").getLength());
        String pattern = "/rules/rule[@resource='XXX']";
        for (String[] rule : rules) {
            String exp = pattern.replace("XXX", rule[0]);
            String roles = xp.evaluate(exp, dom);
            Assert.assertTrue((boolean)this.checkRolesStringsForEquality(rule[1], roles));
        }
    }

    boolean checkRolesStringsForEquality(String roleString1, String roleString2) {
        String[] roleArray2;
        String[] roleArray1 = roleString1.split(",");
        if (roleArray1.length != (roleArray2 = roleString2.split(",")).length) {
            return false;
        }
        HashSet<String> roleSet1 = new HashSet<String>();
        for (String role : roleArray1) {
            roleSet1.add(role.trim());
        }
        HashSet<String> roleSet2 = new HashSet<String>();
        for (String role : roleArray2) {
            roleSet2.add(role.trim());
        }
        for (String role : roleSet1) {
            if (roleSet2.contains(role)) continue;
            return false;
        }
        return true;
    }

    void checkJSONResponse(JSONObject json, String[][] rules) {
        for (String[] rule : rules) {
            String roles = json.getString(rule[0]);
            Assert.assertTrue((boolean)this.checkRolesStringsForEquality(rule[1], roles));
        }
    }

    String[][] getDefaultLayerRules() {
        return new String[][]{{"*.*.r", "*"}, {"*.*.w", "*"}};
    }

    String[][] getDefaultServiceRules() {
        return new String[][]{{"*.*", "*"}};
    }

    String[][] getDefaultRestRules() {
        return new String[][]{{"/**:GET,HEAD,OPTIONS", "ADMIN"}, {"/**:POST,DELETE,PUT", "ADMIN"}};
    }

    String[][] getDefaultRestRulesForDelete() {
        return new String[][]{{"%2F**:GET,HEAD,OPTIONS", "ADMIN"}, {"%2F**:POST,DELETE,PUT", "ADMIN"}};
    }

    @Test
    public void testGet() throws Exception {
        String[][] layerRules = this.getDefaultLayerRules();
        JSONObject json = (JSONObject)this.getAsJSON(DATA_URI_JSON);
        this.checkJSONResponse(json, layerRules);
        Document dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, layerRules);
        String[][] serviceRules = this.getDefaultServiceRules();
        json = (JSONObject)this.getAsJSON(SERVICE_URI_JSON);
        this.checkJSONResponse(json, serviceRules);
        dom = this.getAsDOM(SERVICE_URI_XML);
        this.checkXMLResponse(dom, serviceRules);
        String[][] restRules = this.getDefaultRestRules();
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, restRules);
        json = (JSONObject)this.getAsJSON(REST_URI_JSON);
        this.checkJSONResponse(json, restRules);
    }

    @Test
    public void testDelete() throws Exception {
        String[][] layerRules = this.getDefaultLayerRules();
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/security/acl/layers/" + layerRules[0][0]).getStatus());
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/security/acl/layers/" + layerRules[0][0]).getStatus());
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/security/acl/services/wfs.getFeature").getStatus());
        String[][] restRules = this.getDefaultRestRulesForDelete();
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/security/acl/rest/" + restRules[0][0]).getStatus());
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/security/acl/rest/" + restRules[0][0]).getStatus());
    }

    @Test
    public void testXMLPost() throws Exception {
        String[][] rules = this.getDefaultLayerRules();
        String[][] toBeAdded = new String[][]{rules[0], {"ws.layer1.r", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        Document dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        String[][] toBeAdded2 = new String[][]{{"ws.layer1.w", TEST_ROLE1}, {"ws.layer1.r", TEST_ROLELIST}};
        String[][] expected = new String[][]{rules[0], rules[1], toBeAdded2[0], toBeAdded2[1]};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded2), "text/xml").getStatus());
        dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, expected);
        rules = this.getDefaultServiceRules();
        toBeAdded2 = new String[][]{{"ws.*", TEST_ROLE1}, {"ws2.GetFeature", TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(SERVICE_URI_XML, this.createXMLBody(toBeAdded2), "text/xml").getStatus());
        expected = new String[][]{rules[0], toBeAdded2[0], toBeAdded2[1]};
        dom = this.getAsDOM(SERVICE_URI_XML);
        this.checkXMLResponse(dom, expected);
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(SERVICE_URI_XML, this.createXMLBody(toBeAdded2), "text/xml").getStatus());
        rules = this.getDefaultRestRules();
        toBeAdded = new String[][]{rules[0], {"/myworkspace/**:GET", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(REST_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeAdded2 = new String[][]{{"/myworkspace/**:PUT,POST", TEST_ROLE1}, {"/myworkspace/**:GET", TEST_ROLELIST}};
        expected = new String[][]{rules[0], rules[1], toBeAdded2[0], toBeAdded2[1]};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(REST_URI_XML, this.createXMLBody(toBeAdded2), "text/xml").getStatus());
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, expected);
    }

    @Test
    public void testJSONPost() throws Exception {
        String[][] rules = this.getDefaultLayerRules();
        String[][] toBeAdded = new String[][]{rules[0], {"ws.layer1.r", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(DATA_URI_JSON, this.createJSONBody(toBeAdded), "text/json").getStatus());
        JSONObject json = (JSONObject)this.getAsJSON(DATA_URI_JSON);
        this.checkJSONResponse(json, rules);
        String[][] toBeAdded2 = new String[][]{{"ws.layer1.w", TEST_ROLE1}, {"ws.layer1.r", TEST_ROLELIST}};
        String[][] expected = new String[][]{rules[0], rules[1], toBeAdded2[0], toBeAdded2[1]};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(DATA_URI_JSON, this.createJSONBody(toBeAdded2), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(DATA_URI_JSON);
        this.checkJSONResponse(json, expected);
        rules = this.getDefaultServiceRules();
        toBeAdded2 = new String[][]{{"ws.*", TEST_ROLE1}, {"ws2.GetFeature", TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(toBeAdded2), "text/json").getStatus());
        expected = new String[][]{rules[0], toBeAdded2[0], toBeAdded2[1]};
        json = (JSONObject)this.getAsJSON(SERVICE_URI_JSON);
        this.checkJSONResponse(json, expected);
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(toBeAdded2), "text/json").getStatus());
        rules = this.getDefaultRestRules();
        toBeAdded = new String[][]{rules[0], {"/myworkspace/**:GET", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.postAsServletResponse(REST_URI_JSON, this.createJSONBody(toBeAdded), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(REST_URI_JSON);
        this.checkJSONResponse(json, rules);
        toBeAdded2 = new String[][]{{"/myworkspace/**:PUT,POST", TEST_ROLE1}, {"/myworkspace/**:GET", TEST_ROLELIST}};
        expected = new String[][]{rules[0], rules[1], toBeAdded2[0], toBeAdded2[1]};
        Assert.assertEquals((long)200L, (long)this.postAsServletResponse(REST_URI_JSON, this.createJSONBody(toBeAdded2), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(REST_URI_JSON);
        this.checkJSONResponse(json, expected);
    }

    @Test
    public void testJSONPut() throws Exception {
        String[][] rules = this.getDefaultLayerRules();
        String[][] toBeModified = new String[][]{rules[0], {"ws.layer1.r", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(DATA_URI_JSON, this.createJSONBody(toBeModified), "text/json").getStatus());
        JSONObject json = (JSONObject)this.getAsJSON(DATA_URI_JSON);
        this.checkJSONResponse(json, rules);
        String[][] toBeModified2 = new String[][]{{rules[0][0], TEST_ROLE1}, {rules[1][0], TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(DATA_URI_JSON, this.createJSONBody(toBeModified2), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(DATA_URI_JSON);
        this.checkJSONResponse(json, toBeModified2);
        rules = this.getDefaultServiceRules();
        toBeModified2 = new String[][]{{"ws.*", TEST_ROLE1}, {"ws2.GetFeature", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(toBeModified2), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(SERVICE_URI_JSON);
        this.checkJSONResponse(json, rules);
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(new String[0][]), "text/json").getStatus());
        rules = this.getDefaultRestRules();
        toBeModified = new String[][]{rules[0], {"/myworkspace/**:GET", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(REST_URI_JSON, this.createJSONBody(toBeModified), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(REST_URI_JSON);
        this.checkJSONResponse(json, rules);
        toBeModified2 = new String[][]{{rules[0][0], TEST_ROLE1}, {rules[1][0], TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(REST_URI_JSON, this.createJSONBody(toBeModified2), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(REST_URI_JSON);
        this.checkJSONResponse(json, toBeModified2);
    }

    @Test
    public void testXMLPut() throws Exception {
        String[][] rules = this.getDefaultLayerRules();
        String[][] toBeModified = new String[][]{rules[0], {"ws.layer1.r", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeModified), "text/xml").getStatus());
        Document dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        String[][] toBeModified2 = new String[][]{{rules[0][0], TEST_ROLE1}, {rules[1][0], TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeModified2), "text/xml").getStatus());
        dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, toBeModified2);
        rules = this.getDefaultServiceRules();
        toBeModified2 = new String[][]{{"ws.*", TEST_ROLE1}, {"ws2.GetFeature", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(SERVICE_URI_XML, this.createXMLBody(toBeModified2), "text/xml").getStatus());
        dom = this.getAsDOM(SERVICE_URI_XML);
        this.checkXMLResponse(dom, rules);
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(SERVICE_URI_XML, this.createXMLBody(new String[0][]), "text/xml").getStatus());
        rules = this.getDefaultRestRules();
        toBeModified = new String[][]{rules[0], {"/myworkspace/**:GET", TEST_ROLELIST}};
        Assert.assertEquals((long)409L, (long)this.putAsServletResponse(REST_URI_XML, this.createXMLBody(toBeModified), "text/xml").getStatus());
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeModified2 = new String[][]{{rules[0][0], TEST_ROLE1}, {rules[1][0], TEST_ROLELIST}};
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(REST_URI_XML, this.createXMLBody(toBeModified2), "text/xml").getStatus());
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, toBeModified2);
    }

    @Test
    public void testCatalogMode() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON(CATALOG_URI_JSON);
        String mode = (String)json.get("mode");
        Assert.assertEquals((Object)CatalogMode.HIDE.toString(), (Object)mode);
        Document dom = this.getAsDOM(CATALOG_URI_XML);
        this.print(dom);
        Assert.assertEquals((Object)"catalog", (Object)dom.getDocumentElement().getNodeName());
        NodeList nl = dom.getElementsByTagName("mode");
        Assert.assertEquals((long)1L, (long)nl.getLength());
        mode = nl.item(0).getTextContent();
        Assert.assertEquals((Object)CatalogMode.HIDE.toString(), (Object)mode);
        String jsonTemplate = "'{'\"mode\":\"{0}\"'}'";
        Object xmlTemplate = "<catalog>\n";
        xmlTemplate = (String)xmlTemplate + " <mode>{0}";
        xmlTemplate = (String)xmlTemplate + "</mode>\n";
        xmlTemplate = (String)xmlTemplate + "</catalog>\n";
        Assert.assertEquals((long)404L, (long)this.putAsServletResponse(CATALOG_URI_JSON, "{\"modexxxxx\": \"HIDE\"}", "text/json").getStatus());
        Assert.assertEquals((long)422L, (long)this.putAsServletResponse(CATALOG_URI_JSON, MessageFormat.format(jsonTemplate, "ABC"), "text/json").getStatus());
        Assert.assertEquals((long)422L, (long)this.putAsServletResponse(CATALOG_URI_XML, MessageFormat.format((String)xmlTemplate, "ABC"), "text/xml").getStatus());
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(CATALOG_URI_JSON, MessageFormat.format(jsonTemplate, CatalogMode.MIXED.toString()), "text/json").getStatus());
        json = (JSONObject)this.getAsJSON(CATALOG_URI_JSON);
        mode = (String)json.get("mode");
        Assert.assertEquals((Object)CatalogMode.MIXED.toString(), (Object)mode);
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(CATALOG_URI_XML, MessageFormat.format((String)xmlTemplate, CatalogMode.CHALLENGE.toString()), "text/xml").getStatus());
        dom = this.getAsDOM(CATALOG_URI_XML);
        nl = dom.getElementsByTagName("mode");
        mode = nl.item(0).getTextContent();
        Assert.assertEquals((Object)CatalogMode.CHALLENGE.toString(), (Object)mode);
    }

    @Test
    public void testCatalogModeXXE() throws Exception {
        String resource = ((Object)((Object)this)).getClass().getResource("secret.txt").toExternalForm();
        Object xml = "<!DOCTYPE catalog [";
        xml = (String)xml + "<!ELEMENT catalog ANY>";
        xml = (String)xml + "<!ENTITY xxe SYSTEM \"" + resource + "\">]>";
        xml = (String)xml + "<catalog>\n";
        xml = (String)xml + " <mode>&xxe;";
        xml = (String)xml + "</mode>\n";
        xml = (String)xml + "</catalog>\n";
        MockHttpServletResponse resp = this.putAsServletResponse(CATALOG_URI_XML, (String)xml, "text/xml");
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        MatcherAssert.assertThat((Object)resp.getContentAsString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"HELLO WORLD")));
    }

    @Test
    public void testInvalidRules() throws Exception {
        String[][] rules = this.getDefaultLayerRules();
        String[][] toBeAdded = new String[][]{{"ws.layer1.r.c", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        Document dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeAdded = new String[][]{{"ws.layer1.x", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeAdded = new String[][]{{"*.layer1.r", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeAdded = new String[][]{{"ws.layer1.a", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(DATA_URI_XML);
        this.checkXMLResponse(dom, rules);
        rules = this.getDefaultServiceRules();
        toBeAdded = new String[][]{{"ws.getMap.c", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(SERVICE_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(SERVICE_URI_XML);
        this.checkXMLResponse(dom, rules);
        toBeAdded = new String[][]{{"*.getMap", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(SERVICE_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(SERVICE_URI_XML);
        this.checkXMLResponse(dom, rules);
        rules = this.getDefaultRestRules();
        toBeAdded = new String[][]{rules[0], {"/myworkspace/**!!!GET", TEST_ROLELIST}};
        Assert.assertEquals((long)422L, (long)this.postAsServletResponse(REST_URI_XML, this.createXMLBody(toBeAdded), "text/xml").getStatus());
        dom = this.getAsDOM(REST_URI_XML);
        this.checkXMLResponse(dom, rules);
    }

    @Test
    public void testNotAuthorized() throws Exception {
        this.logout();
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(DATA_URI_XML).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(DATA_URI_JSON).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(SERVICE_URI_XML).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(SERVICE_URI_JSON).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(REST_URI_XML).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(REST_URI_JSON).getStatus());
        String[][] dataRules = new String[][]{{"ws.layer1.w", TEST_ROLE1}, {"ws.layer1.r", TEST_ROLELIST}};
        String[][] serviceRules = new String[][]{{"ws.*", TEST_ROLE1}, {"ws2.GetFeature", TEST_ROLELIST}};
        String[][] restRules = new String[][]{{"/myworkspace/**:GET", TEST_ROLELIST}};
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(DATA_URI_XML, this.createXMLBody(dataRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(DATA_URI_JSON, this.createJSONBody(dataRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(SERVICE_URI_XML, this.createXMLBody(serviceRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(serviceRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(REST_URI_XML, this.createXMLBody(restRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(REST_URI_JSON, this.createJSONBody(restRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(DATA_URI_XML, this.createXMLBody(dataRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(DATA_URI_JSON, this.createJSONBody(dataRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(SERVICE_URI_XML, this.createXMLBody(serviceRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(SERVICE_URI_JSON, this.createJSONBody(serviceRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(REST_URI_XML, this.createXMLBody(restRules), "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.postAsServletResponse(REST_URI_JSON, this.createJSONBody(restRules), "text/json").getStatus());
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/security/acl/layers/fakerule").getStatus());
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/security/acl/services/fakerule").getStatus());
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/security/acl/rest/fakerule").getStatus());
        String jsonTemplate = "{\"mode\":\"MIXED\"}";
        Object xmlTemplate = "<catalog>\n";
        xmlTemplate = (String)xmlTemplate + " <mode>MIXED";
        xmlTemplate = (String)xmlTemplate + "</mode>\n";
        xmlTemplate = (String)xmlTemplate + "</catalog>\n";
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(CATALOG_URI_XML).getStatus());
        Assert.assertEquals((long)403L, (long)this.getAsServletResponse(CATALOG_URI_JSON).getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(CATALOG_URI_XML, (String)xmlTemplate, "text/xml").getStatus());
        Assert.assertEquals((long)403L, (long)this.putAsServletResponse(CATALOG_URI_JSON, jsonTemplate, "text/json").getStatus());
    }

    @Test
    public void testCatalogSecurityReload() throws Exception {
        String CATALOG_RELOAD_URI = "/rest/security/acl/catalog/reload";
        this.login();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/security/acl/catalog/reload", "", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = this.postAsServletResponse("/rest/security/acl/catalog/reload", "", "text/plain");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.logout();
        response = this.putAsServletResponse("/rest/security/acl/catalog/reload", "", "text/plain");
        Assert.assertEquals((long)403L, (long)response.getStatus());
        response = this.postAsServletResponse("/rest/security/acl/catalog/reload", "", "text/plain");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableAnonymousAccess() throws Exception {
        this.login();
        String CATALOG_RELOAD_URI = "/rest/security/acl/catalog/reload";
        File configFile = this.getDataDirectory().get(new String[]{"security/config.xml"}).file();
        Assert.assertNotNull((String)"config.xml file should exist", (Object)configFile);
        Assert.assertTrue((String)"config.xml file must exist", (boolean)configFile.exists());
        String originalConfig = FileUtils.readFileToString((File)configFile, (String)"UTF-8");
        try {
            String modifiedConfig = originalConfig.replaceAll("<filter>anonymous</filter>", "");
            FileUtils.writeStringToFile((File)configFile, (String)modifiedConfig, (String)"UTF-8");
            MockHttpServletResponse response = this.putAsServletResponse("/rest/security/acl/catalog/reload", "", "text/plain");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            this.logout();
            String wmsRequest = "wms?service=WMS&request=GetCapabilities&version=1.1.1";
            MockHttpServletResponse wmsResponse = this.getAsServletResponse(wmsRequest);
            int status = wmsResponse.getStatus();
            Assert.assertTrue((String)("Expected 401 or 403, but got " + status), (status == 401 || status == 403 || status == 404 ? 1 : 0) != 0);
        }
        finally {
            FileUtils.writeStringToFile((File)configFile, (String)originalConfig, (String)"UTF-8");
        }
    }
}

