/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LayerControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() throws IOException {
        this.revertLayer(SystemTestData.BUILDINGS);
        this.revertLayer(SystemTestData.BRIDGES);
        StyleInfo si = this.getCatalog().getStyleByName("cite", "foo");
        if (si != null) {
            this.getCatalog().remove(si);
        }
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        super.onTearDown(testData);
    }

    @Test
    public void testGetListAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layers.xml", 200);
        Assert.assertEquals((Object)"layers", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//layer[name='cite:Buildings']", (Document)dom);
        MatcherAssert.assertThat((Object)xp.evaluate("//layer[name='cite:Buildings']/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/layers/cite%3ABuildings.xml"));
    }

    @Test
    public void testGetListInWorkspaceAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/cite/layers.xml", 200);
        Assert.assertEquals((Object)"layers", (Object)dom.getDocumentElement().getNodeName());
        this.print(dom);
        XMLAssert.assertXpathExists((String)"//layer[name='Buildings']", (Document)dom);
        MatcherAssert.assertThat((Object)xp.evaluate("//layer[name='Buildings']/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/workspaces/cite/layers/Buildings.xml"));
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layers/cite:Buildings.xml", 200);
        Assert.assertEquals((Object)"layer", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/*[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/styles/Buildings.xml", (String)"/layer/defaultStyle/atom:link/attribute::href", (Document)dom);
    }

    @Test
    public void testGetInWorkspaceAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/cite/layers/Buildings.xml", 200);
        Assert.assertEquals((Object)"layer", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/*[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/styles/Buildings.xml", (String)"/layer/defaultStyle/atom:link/attribute::href", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/layers/cite:Buildings.html", 200);
    }

    @Test
    public void testGetWrongLayer() throws Exception {
        String layer = "cite:Buildingssssss";
        String requestPath = "/rest/layers/" + layer + ".html";
        String exception = "No such layer: " + layer;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        String message = response.getContentAsString();
        Assert.assertFalse((String)message, (boolean)message.contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layers.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)("" + catalog.getLayers().size()), (String)"count(//layer)", (Document)dom);
    }

    @Test
    public void testGetAllInWorkspaceAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/cite/layers.xml", 200);
        int count = catalog.getResourcesByNamespace("cite", ResourceInfo.class).stream().mapToInt(info -> catalog.getLayers(info).size()).sum();
        XMLAssert.assertXpathEvaluatesTo((String)("" + count), (String)"count(//layer)", (Document)dom);
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        this.getAsDOM("/rest/layers.html", 200);
    }

    @Test
    public void testPut() throws Exception {
        LayerInfo l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"Buildings", (Object)l.getDefaultStyle().getName());
        String xml = "<layer><defaultStyle>Forests</defaultStyle><styles><style>Ponds</style></styles></layer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"Forests", (Object)l.getDefaultStyle().getName());
        Assert.assertNotNull((Object)l.getDateModified());
    }

    @Test
    public void testPutInWorkspace() throws Exception {
        LayerInfo l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"Buildings", (Object)l.getDefaultStyle().getName());
        String xml = "<layer><defaultStyle>Forests</defaultStyle><styles><style>Ponds</style></styles></layer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/cite/layers/Buildings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"Forests", (Object)l.getDefaultStyle().getName());
        Assert.assertNotNull((Object)l.getDateModified());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        LayerInfo l = catalog.getLayerByName("cite:Buildings");
        Assert.assertTrue((boolean)l.isEnabled());
        boolean isAdvertised = l.isAdvertised();
        boolean isOpaque = l.isOpaque();
        boolean isQueryable = l.isQueryable();
        String xml = "<layer><defaultStyle>Forests</defaultStyle><styles><style>Ponds</style></styles></layer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        l = catalog.getLayerByName("cite:Buildings");
        Assert.assertTrue((boolean)l.isEnabled());
        Assert.assertEquals((Object)isAdvertised, (Object)l.isAdvertised());
        Assert.assertEquals((Object)isOpaque, (Object)l.isOpaque());
        Assert.assertEquals((Object)isQueryable, (Object)l.isQueryable());
        Assert.assertNotNull((Object)l.getDateModified());
    }

    @Test
    public void testUpdateStyleJSON() throws Exception {
        LayerInfo l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"Buildings", (Object)l.getDefaultStyle().getName());
        JSONObject json = (JSONObject)this.getAsJSON("/rest/layers/cite:Buildings.json");
        JSONObject layer = (JSONObject)json.get("layer");
        JSONObject style = (JSONObject)layer.get("defaultStyle");
        style.put((Object)"name", (Object)"polygon");
        style.put((Object)"href", (Object)"http://localhost:8080/geoserver/rest/styles/polygon.json");
        String updatedJson = json.toString();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layers/cite:Buildings", updatedJson, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        l = catalog.getLayerByName("cite:Buildings");
        Assert.assertEquals((Object)"polygon", (Object)l.getDefaultStyle().getName());
        Assert.assertNotNull((Object)l.getDateModified());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertNotNull((Object)catalog.getLayerByName("cite:Buildings"));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/layers/cite:Buildings").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("cite:Buildings"));
    }

    @Test
    public void testDeleteInWorkspace() throws Exception {
        Assert.assertNotNull((Object)catalog.getLayerByName("cite:Buildings"));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/cite/layers/Buildings").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("cite:Buildings"));
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        Assert.assertNotNull((Object)catalog.getLayerByName("cite:Buildings"));
        Assert.assertNotNull((Object)catalog.getFeatureTypeByName("cite", "Buildings"));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/layers/cite:Buildings").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("cite:Buildings"));
        Assert.assertNotNull((Object)catalog.getFeatureTypeByName("cite", "Buildings"));
        Assert.assertNotNull((Object)catalog.getLayerByName("cite:Bridges"));
        Assert.assertNotNull((Object)catalog.getFeatureTypeByName("cite", "Bridges"));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/layers/cite:Bridges?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("cite:Bridges"));
        Assert.assertNull((Object)catalog.getFeatureTypeByName("cite", "Bridges"));
    }

    @Test
    public void testPutWorkspaceStyle() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getStyleByName("foo"));
        Assert.assertNull((Object)cat.getStyleByName("cite", "foo"));
        String xml = "<style><name>foo</name><filename>foo.sld</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cite/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        Assert.assertNotNull((Object)cat.getStyleByName("cite", "foo"));
        xml = "<layer><defaultStyle><name>foo</name><workspace>cite</workspace></defaultStyle><enabled>true</enabled></layer>";
        response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerInfo l = cat.getLayerByName("cite:Buildings");
        Assert.assertNotNull((Object)l.getDefaultStyle());
        Assert.assertEquals((Object)"foo", (Object)l.getDefaultStyle().getName());
        Assert.assertNotNull((Object)l.getDefaultStyle().getWorkspace());
        Assert.assertNotNull((Object)l.getDateModified());
        Document dom = this.getAsDOM("/rest/layers/cite:Buildings.xml", 200);
        XMLAssert.assertXpathExists((String)"/layer/defaultStyle/name[text() = 'cite:foo']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/layer/defaultStyle/workspace[text() = 'cite']", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/workspaces/cite/styles/foo.xml", (String)"//defaultStyle/atom:link/@href", (Document)dom);
    }

    @Test
    public void testPutWorkspaceAlternateStyle() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getStyleByName("foo"));
        Assert.assertNull((Object)cat.getStyleByName("cite", "foo"));
        String xml = "<style><name>foo</name><filename>foo.sld</filename></style>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/cite/styles", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"text/plain"));
        Assert.assertNotNull((Object)cat.getStyleByName("cite", "foo"));
        xml = "<layer><styles><style><name>foo</name><workspace>cite</workspace></style></styles><enabled>true</enabled></layer>";
        response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerInfo l = cat.getLayerByName("cite:Buildings");
        Assert.assertNotNull((Object)l.getDefaultStyle());
        StyleInfo style = (StyleInfo)l.getStyles().iterator().next();
        Assert.assertEquals((Object)"foo", (Object)style.getName());
        Assert.assertNotNull((Object)style.getWorkspace());
        Assert.assertNotNull((Object)l.getDateModified());
        Document dom = this.getAsDOM("/rest/layers/cite:Buildings.xml", 200);
        XMLAssert.assertXpathExists((String)"/layer/styles/style/name[text() = 'cite:foo']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/layer/styles/style/workspace[text() = 'cite']", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/workspaces/cite/styles/foo.xml", (String)"//styles/style/atom:link/@href", (Document)dom);
    }

    @Test
    public void testPutDefaultWMSInterpolationMethod() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo l = cat.getLayerByName("cite:Buildings");
        Assert.assertNotNull((Object)l);
        Assert.assertNull((Object)l.getDefaultWMSInterpolationMethod());
        Document dom = this.getAsDOM("/rest/layers/cite:Buildings.xml", 200);
        Assert.assertEquals((Object)"layer", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathNotExists((String)"/layer/defaultWMSInterpolationMethod", (Document)dom);
        String xml = "<layer><defaultWMSInterpolationMethod>Nearest</defaultWMSInterpolationMethod><enabled>true</enabled></layer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        l = cat.getLayerByName("cite:Buildings");
        Assert.assertNotNull((Object)l.getDefaultWMSInterpolationMethod());
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Nearest, (Object)l.getDefaultWMSInterpolationMethod());
        Assert.assertNotNull((Object)l.getDateModified());
        dom = this.getAsDOM("/rest/layers/cite:Buildings.xml", 200);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/layer/defaultWMSInterpolationMethod)", (Document)dom);
        XMLAssert.assertXpathExists((String)"/layer/defaultWMSInterpolationMethod[text() = 'Nearest']", (Document)dom);
    }

    @Test
    public void testGetLayerWithColonInStyleName() throws Exception {
        LayerInfo roadsLayer = catalog.getLayerByName("RoadSegments");
        roadsLayer.getStyles().add(catalog.getStyleByName("RoadSegments"));
        catalog.save(roadsLayer);
        this.updateStyleNameInXmlFile();
        this.getGeoServer().reload();
        String requestPath = "/rest/layers/RoadSegments.json";
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains("demo:demo:RoadSegmentsDup"));
    }

    public void updateStyleNameInXmlFile() throws IOException {
        File requiredFile = Arrays.stream(Objects.requireNonNull(this.getDataDirectory().get(new String[]{"styles"}).dir().listFiles())).filter(file -> file.getName().equals("RoadSegments.xml")).findFirst().get();
        StringBuilder fileContents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(requiredFile.getAbsolutePath()));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                fileContents.append(currentLine);
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(requiredFile.getAbsolutePath()));){
            fileContents = new StringBuilder(fileContents.toString().replace("<name>RoadSegments</name>", "<name>demo:RoadSegmentsDup</name>"));
            writer.write(fileContents.toString());
        }
    }
}

