/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.mock.web.MockHttpServletResponse;

public class CatalogReloadControllerTest
extends GeoServerSystemTestSupport {
    static ReloadResetWatcher watcher = new ReloadResetWatcher();

    protected void onSetUp(SystemTestData data) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        beanFactory.registerSingleton("ReloadResetWatcher", (Object)watcher);
    }

    public void reset() {
        CatalogReloadControllerTest.watcher.didReload = false;
        CatalogReloadControllerTest.watcher.didReset = false;
    }

    @Test
    public synchronized void testPutReload() throws Exception {
        this.reset();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/reload", null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReload);
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReset);
    }

    @Test
    public synchronized void testPostReload() throws Exception {
        this.reset();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/reload", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReload);
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReset);
    }

    @Test
    public synchronized void testPutReset() throws Exception {
        this.reset();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/reset", null, null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)CatalogReloadControllerTest.watcher.didReload);
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReset);
    }

    @Test
    public synchronized void testPostReset() throws Exception {
        this.reset();
        MockHttpServletResponse response = this.postAsServletResponse("/rest/reset", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertFalse((boolean)CatalogReloadControllerTest.watcher.didReload);
        Assert.assertTrue((boolean)CatalogReloadControllerTest.watcher.didReset);
    }

    private static class ReloadResetWatcher
    implements GeoServerLifecycleHandler {
        boolean didReload;
        boolean didReset;

        private ReloadResetWatcher() {
        }

        public void onReset() {
            this.didReset = true;
        }

        public void onReload() {
            this.didReload = true;
        }

        public void onDispose() {
        }

        public void beforeReload() {
        }
    }
}

