/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogIntegrationTest;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LayerGroupControllerTest
extends CatalogRESTTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle("singleStyleGroup", "singleStyleGroup.sld", CatalogIntegrationTest.class, this.getCatalog());
    }

    @Before
    public void revertChanges() throws Exception {
        this.removeLayer("sf", "Lakes");
        this.removeLayerGroup(null, "nestedLayerGroupTest");
        this.removeLayerGroup(null, "citeLayerGroup");
        this.removeLayerGroup(null, "sfLayerGroup");
        this.removeLayerGroup("sf", "workspaceLayerGroup");
        this.removeLayerGroup(null, "newLayerGroup");
        this.removeLayerGroup(null, "newLayerGroupWithTypeCONTAINER");
        this.removeLayerGroup(null, "newLayerGroupWithTypeEO");
        this.removeLayerGroup(null, "newLayerGroupWithStyleGroup");
        this.removeLayerGroup(null, "doubleLayerGroup");
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName("sfLayerGroup");
        lg.getLayers().add(catalog.getLayerByName("sf:PrimitiveGeoFeature"));
        lg.getLayers().add(catalog.getLayerByName("sf:AggregateGeoFeature"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.getStyles().add(catalog.getStyleByName("point"));
        lg.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326")));
        catalog.add(lg);
        LayerGroupInfo lg2 = catalog.getFactory().createLayerGroup();
        lg2.setName("citeLayerGroup");
        List layers = lg2.getLayers();
        layers.add(catalog.getLayerByName("cite:Bridges"));
        layers.add(catalog.getLayerByName("cite:Buildings"));
        layers.add(catalog.getLayerByName("cite:Forests"));
        layers.add(catalog.getLayerByName("cite:Lakes"));
        layers.add(catalog.getLayerByName("cite:Ponds"));
        layers.add(catalog.getLayerByName("cite:Streams"));
        List styles = lg2.getStyles();
        styles.add(null);
        styles.add(null);
        styles.add(null);
        styles.add(null);
        styles.add(null);
        styles.add(null);
        lg2.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326")));
        catalog.add(lg2);
        this.addKeywordsToLayerGroup("citeLayerGroup");
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layergroups.xml");
        Assert.assertEquals((long)catalog.getLayerGroups().size(), (long)dom.getElementsByTagName("layerGroup").getLength());
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        this.getAsDOM("/rest/layergroups.html");
    }

    @Test
    public void testGetAllFromWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/layergroups.xml");
        Assert.assertEquals((Object)"layerGroups", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//layerGroup)", (Document)dom);
        this.addLayerGroupToWorkspace();
        dom = this.getAsDOM("/rest/workspaces/sf/layergroups.xml");
        Assert.assertEquals((Object)"layerGroups", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//layerGroup)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//layerGroup/name[text() = 'workspaceLayerGroup']", (Document)dom);
    }

    void addLayerGroupToWorkspace() {
        Catalog cat = this.getCatalog();
        LayerGroupInfo lg = cat.getFactory().createLayerGroup();
        lg.setName("workspaceLayerGroup");
        lg.setWorkspace(cat.getWorkspaceByName("sf"));
        lg.getLayers().add(cat.getLayerByName("sf:PrimitiveGeoFeature"));
        lg.getStyles().add(null);
        cat.add(lg);
    }

    @Test
    public void testGetAsXML() throws Exception {
        this.print(this.get("/rest/layergroups/sfLayerGroup.xml"));
        Document dom = this.getAsDOM("/rest/layergroups/sfLayerGroup.xml");
        this.print(dom);
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"sfLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//published)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//style)", (Document)dom);
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='sf:PrimitiveGeoFeature']/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/workspaces/sf/layers/PrimitiveGeoFeature.xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='sf:PrimitiveGeoFeature']/atom:link/@type", dom), (Matcher)Matchers.equalTo((Object)"application/xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//style[1]/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/styles/point.xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//style[1]/atom:link/@type", dom), (Matcher)Matchers.equalTo((Object)"application/xml"));
        dom = this.getAsDOM("/rest/layergroups/citeLayerGroup.xml");
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"citeLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//published)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)"count(//style)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//layerGroup/keywords/string)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//layerGroup/keywords[string='keyword1\\@language=en\\;\\@vocabulary=vocabulary1\\;'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//layerGroup/keywords[string='keyword2\\@language=pt\\;\\@vocabulary=vocabulary2\\;'])", (Document)dom);
    }

    @Test
    public void testGetAsXMLNestedLinks() throws Exception {
        LayerGroupInfo cite = catalog.getLayerGroupByName("citeLayerGroup");
        cite.getLayers().add(catalog.getLayerGroupByName("sfLayerGroup"));
        cite.getStyles().add(null);
        catalog.save(cite);
        Document dom = this.getAsDOM("/rest/layergroups/citeLayerGroup.xml");
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"citeLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(//published)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(//style)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(//published/atom:link)", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        this.print(this.get("/rest/layergroups/sfLayerGroup.json"));
        JSON json = this.getAsJSON("/rest/layergroups/sfLayerGroup.json");
        JSONArray arr = ((JSONObject)json).getJSONObject("layerGroup").getJSONObject("publishables").getJSONArray("published");
        Assert.assertEquals((long)2L, (long)arr.size());
        arr = ((JSONObject)json).getJSONObject("layerGroup").getJSONObject("styles").getJSONArray("style");
        Assert.assertEquals((long)2L, (long)arr.size());
        this.print(this.get("/rest/layergroups/citeLayerGroup.json"));
        json = this.getAsJSON("/rest/layergroups/citeLayerGroup.json");
        arr = ((JSONObject)json).getJSONObject("layerGroup").getJSONObject("publishables").getJSONArray("published");
        Assert.assertEquals((long)6L, (long)arr.size());
        arr = ((JSONObject)json).getJSONObject("layerGroup").getJSONObject("styles").getJSONArray("style");
        Assert.assertEquals((long)6L, (long)arr.size());
        LayerGroupInfo lg2 = catalog.getLayerGroupByName("citeLayerGroup");
        List styles = lg2.getStyles();
        styles.set(1, catalog.getStyleByName("point"));
        styles.set(3, catalog.getStyleByName("point"));
        catalog.save(lg2);
        this.print(this.get("/rest/layergroups/citeLayerGroup.json"));
        json = this.getAsJSON("/rest/layergroups/citeLayerGroup.json");
        JSONObject layerGroup = ((JSONObject)json).getJSONObject("layerGroup");
        arr = layerGroup.getJSONObject("publishables").getJSONArray("published");
        Assert.assertEquals((long)6L, (long)arr.size());
        arr = layerGroup.getJSONObject("styles").getJSONArray("style");
        Assert.assertEquals((long)6L, (long)arr.size());
        MatcherAssert.assertThat((Object)layerGroup.containsKey((Object)"keywords"), (Matcher)Matchers.is((Object)true));
        JSONObject keywordsObject = layerGroup.getJSONObject("keywords");
        MatcherAssert.assertThat((Object)keywordsObject.containsKey((Object)"string"), (Matcher)Matchers.is((Object)true));
        JSONArray keywords = keywordsObject.getJSONArray("string");
        MatcherAssert.assertThat((Object)keywords.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat(this.toList(keywords), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"keyword1\\@language=en\\;\\@vocabulary=vocabulary1\\;", "keyword2\\@language=pt\\;\\@vocabulary=vocabulary2\\;"}));
    }

    protected List<Object> toList(JSONArray keywords) {
        ArrayList<Object> keywordsList = new ArrayList<Object>();
        keywordsList.addAll((Collection<Object>)keywords);
        return keywordsList;
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/layergroups/sfLayerGroup.html");
    }

    @Test
    public void testRoundTripXML() throws Exception {
        LayerGroupInfo before = this.getCatalog().getLayerGroupByName("sfLayerGroup");
        String xml = this.getAsString("/rest/layergroups/sfLayerGroup.xml");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo after = this.getCatalog().getLayerGroupByName("sfLayerGroup");
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testRoundTripJSON() throws Exception {
        LayerGroupInfo before = this.getCatalog().getLayerGroupByName("sfLayerGroup");
        String json = this.getAsString("/rest/layergroups/sfLayerGroup.json");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", json, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo after = this.getCatalog().getLayerGroupByName("sfLayerGroup");
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testWorkspaceRoundTripXML() throws Exception {
        this.addLayerGroupToWorkspace();
        LayerGroupInfo before = this.getCatalog().getLayerGroupByName("workspaceLayerGroup");
        String xml = this.getAsString("/rest/workspaces/sf/layergroups/workspaceLayerGroup.xml");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo after = this.getCatalog().getLayerGroupByName("workspaceLayerGroup");
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testWorkspaceRoundTripJSON() throws Exception {
        this.addLayerGroupToWorkspace();
        LayerGroupInfo before = this.getCatalog().getLayerGroupByName("workspaceLayerGroup");
        String json = this.getAsString("/rest/workspaces/sf/layergroups/workspaceLayerGroup.json");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup", json, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo after = this.getCatalog().getLayerGroupByName("workspaceLayerGroup");
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testGetWrongLayerGroup() throws Exception {
        String ws = "sf";
        String lg = "foooooo";
        String requestPath = "/rest/layergroups/" + lg + ".html";
        String requestPath2 = "/rest/workspaces/" + ws + "/layergroups/" + lg + ".html";
        String exception = "No such layer group " + lg;
        String exception2 = "No such layer group " + lg + " in workspace " + ws;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
        response = this.getAsServletResponse(requestPath2);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception2));
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception2));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    @Test
    public void testGetFromWorkspace() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup.xml");
        Assert.assertEquals((long)404L, (long)resp.getStatus());
        this.addLayerGroupToWorkspace();
        resp = this.getAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup.xml");
        Assert.assertEquals((long)200L, (long)resp.getStatus());
        Document dom = this.getAsDOM("/rest/workspaces/sf/layergroups/workspaceLayerGroup.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"workspaceLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/layerGroup/workspace/name", (Document)dom);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<layerGroup>    <name>newLayerGroup</name>    <layers>        <layer>Ponds</layer>        <layer>Forests</layer>    </layers>    <styles>        <style>polygon</style>        <style>point</style>    </styles>    <keywords>        <string>keyword1\\@language=en\\;\\@vocabulary=vocabulary1\\;</string>        <string>keyword2\\@language=pt\\;\\@vocabulary=vocabulary2\\;</string>    </keywords></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/newLayerGroup"));
        LayerGroupInfo lg = catalog.getLayerGroupByName("newLayerGroup");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((Object)"Ponds", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertEquals((Object)"Forests", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
        Assert.assertEquals((long)2L, (long)lg.getStyles().size());
        Assert.assertEquals((Object)"polygon", (Object)((StyleInfo)lg.getStyles().get(0)).getName());
        Assert.assertEquals((Object)"point", (Object)((StyleInfo)lg.getStyles().get(1)).getName());
        Assert.assertNotNull((Object)lg.getBounds());
        Keyword keyword1 = new Keyword("keyword1");
        keyword1.setLanguage("en");
        keyword1.setVocabulary("vocabulary1");
        Keyword keyword2 = new Keyword("keyword2");
        keyword2.setLanguage("pt");
        keyword2.setVocabulary("vocabulary2");
        MatcherAssert.assertThat((Object)lg.getKeywords().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)lg.getKeywords(), (Matcher)Matchers.containsInAnyOrder((Object[])new KeywordInfo[]{keyword1, keyword2}));
        Assert.assertNotNull((Object)lg.getDateCreated());
    }

    @Test
    public void testPostWithStyleGroups() throws Exception {
        String xml = "<layerGroup>    <name>newLayerGroupWithStyleGroup</name>    <layers>        <layer>Ponds</layer>        <layer></layer>    </layers>    <styles>        <style>polygon</style>        <style>singleStyleGroup</style>    </styles>    <keywords>        <string>keyword1\\@language=en\\;\\@vocabulary=vocabulary1\\;</string>        <string>keyword2\\@language=pt\\;\\@vocabulary=vocabulary2\\;</string>    </keywords></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/newLayerGroupWithStyleGroup"));
        LayerGroupInfo lg = catalog.getLayerGroupByName("newLayerGroupWithStyleGroup");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((Object)"Ponds", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertNull(lg.getLayers().get(1));
        Assert.assertEquals((long)2L, (long)lg.getStyles().size());
        Assert.assertEquals((Object)"polygon", (Object)((StyleInfo)lg.getStyles().get(0)).getName());
        Assert.assertEquals((Object)"singleStyleGroup", (Object)((StyleInfo)lg.getStyles().get(1)).getName());
        Assert.assertNotNull((Object)lg.getBounds());
        Keyword keyword1 = new Keyword("keyword1");
        keyword1.setLanguage("en");
        keyword1.setVocabulary("vocabulary1");
        Keyword keyword2 = new Keyword("keyword2");
        keyword2.setLanguage("pt");
        keyword2.setVocabulary("vocabulary2");
        MatcherAssert.assertThat((Object)lg.getKeywords().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)lg.getKeywords(), (Matcher)Matchers.containsInAnyOrder((Object[])new KeywordInfo[]{keyword1, keyword2}));
    }

    @Test
    public void testPostWithNestedGroups() throws Exception {
        String xml = "<layerGroup><name>nestedLayerGroupTest</name><publishables><published type=\"layer\">Ponds</published><published type=\"layer\">Forests</published><published type=\"layerGroup\">sfLayerGroup</published></publishables><styles><style>polygon</style><style>point</style><style></style></styles></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/nestedLayerGroupTest"));
        LayerGroupInfo lg = catalog.getLayerGroupByName("nestedLayerGroupTest");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((long)3L, (long)lg.getLayers().size());
        Assert.assertEquals((Object)"Ponds", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertEquals((Object)"Forests", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
        Assert.assertEquals((Object)"sfLayerGroup", (Object)((PublishedInfo)lg.getLayers().get(2)).getName());
        Assert.assertEquals((long)3L, (long)lg.getStyles().size());
        Assert.assertEquals((Object)"polygon", (Object)((StyleInfo)lg.getStyles().get(0)).getName());
        Assert.assertEquals((Object)"point", (Object)((StyleInfo)lg.getStyles().get(1)).getName());
        Assert.assertNull(lg.getStyles().get(2));
        Assert.assertNotNull((Object)lg.getBounds());
    }

    @Test
    public void testPostWithTypeContainer() throws Exception {
        String xml = "<layerGroup><name>newLayerGroupWithTypeCONTAINER</name><mode>CONTAINER</mode><layers><layer>Ponds</layer><layer>Forests</layer></layers><styles><style>polygon</style><style>point</style></styles></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        LayerGroupInfo lg = catalog.getLayerGroupByName("newLayerGroupWithTypeCONTAINER");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((Object)LayerGroupInfo.Mode.CONTAINER, (Object)lg.getMode());
    }

    @Test
    public void testPostWithTypeEO() throws Exception {
        String xml = "<layerGroup><name>newLayerGroupWithTypeEO</name><mode>EO</mode><rootLayer>Ponds</rootLayer><rootLayerStyle>polygon</rootLayerStyle><layers><layer>Forests</layer></layers><styles><style>point</style></styles></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        LayerGroupInfo lg = catalog.getLayerGroupByName("newLayerGroupWithTypeEO");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((Object)LayerGroupInfo.Mode.EO, (Object)lg.getMode());
        Assert.assertEquals((Object)"Ponds", (Object)lg.getRootLayer().getName());
        Assert.assertEquals((Object)"polygon", (Object)lg.getRootLayerStyle().getName());
    }

    @Test
    public void testPostNoStyles() throws Exception {
        String xml = "<layerGroup><name>newLayerGroup</name><layers><layer>Ponds</layer><layer>Forests</layer></layers></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        LayerGroupInfo lg = catalog.getLayerGroupByName("newLayerGroup");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((Object)"Ponds", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertEquals((Object)"Forests", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
        Assert.assertEquals((long)2L, (long)lg.getStyles().size());
        Assert.assertNull(lg.getStyles().get(0));
        Assert.assertNull(lg.getStyles().get(1));
    }

    @Test
    public void testPostToWorkspace() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getWorkspaceByName("sf"));
        Assert.assertNull((Object)cat.getLayerGroupByName("sf", "workspaceLayerGroup"));
        String xml = "<layerGroup><name>workspaceLayerGroup</name><layers><layer>PrimitiveGeoFeature</layer></layers></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)cat.getLayerGroupByName("sf", "workspaceLayerGroup"));
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<layerGroup><name>sfLayerGroup</name><styles><style>polygon</style><style>line</style></styles><attribution>  <logoWidth>101</logoWidth>  <logoHeight>102</logoHeight></attribution><metadataLinks>   <metadataLink>  <id>1</id>  <type>text/html</type>  <metadataType>FGDC</metadataType>  <content>http://my/metadata/link/1</content></metadataLink>    <metadataLink>  <id>2</id>  <type>text/html</type>  <metadataType>FGDC</metadataType>  <content>http://my/metadata/link/2</content></metadataLink>    </metadataLinks></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo lg = catalog.getLayerGroupByName("sfLayerGroup");
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((long)2L, (long)lg.getStyles().size());
        Assert.assertEquals((Object)"polygon", (Object)((StyleInfo)lg.getStyles().get(0)).getName());
        Assert.assertEquals((Object)"line", (Object)((StyleInfo)lg.getStyles().get(1)).getName());
        Assert.assertEquals((long)101L, (long)lg.getAttribution().getLogoWidth());
        Assert.assertEquals((long)102L, (long)lg.getAttribution().getLogoHeight());
        Assert.assertEquals((long)2L, (long)lg.getMetadataLinks().size());
        Assert.assertNotNull((Object)lg.getDateModified());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        LayerGroupInfo lg = catalog.getLayerGroupByName("sfLayerGroup");
        boolean isQueryDisabled = lg.isQueryDisabled();
        lg.setQueryDisabled(true);
        catalog.save(lg);
        String xml = "<layerGroup><name>sfLayerGroup</name></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        lg = catalog.getLayerGroupByName("sfLayerGroup");
        Assert.assertTrue((boolean)lg.isQueryDisabled());
        lg.setQueryDisabled(isQueryDisabled);
        catalog.save(lg);
    }

    @Test
    public void testPutToWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertNull(cat.getLayerGroupByName("sf", "workspaceLayerGroup").getStyles().get(0));
        String xml = "<layerGroup><styles><style>line</style></styles></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup", xml, "application/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"line", (Object)((StyleInfo)cat.getLayerGroupByName("sf", "workspaceLayerGroup").getStyles().get(0)).getName());
    }

    @Test
    public void testPutToWorkspaceChangeWorkspace() throws Exception {
        this.testPostToWorkspace();
        String xml = "<layerGroup><workspace>cite</workspace></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup", xml, "application/xml");
        Assert.assertEquals((long)403L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/layergroups/sfLayerGroup");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = this.deleteAsServletResponse("/rest/layergroups/citeLayerGroup");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)catalog.getLayerGroups().size());
    }

    @Test
    public void testDeleteFromWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        Assert.assertNotNull((Object)cat.getLayerGroupByName("sf", "workspaceLayerGroup"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)cat.getLayerGroupByName("sf", "workspaceLayerGroup"));
    }

    @Test
    public void testLayerGroupDuplicateLayerNames() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo lakesFt = catalog.getFactory().createFeatureType();
        lakesFt.setName("Lakes");
        lakesFt.setNamespace(catalog.getNamespaceByPrefix("sf"));
        lakesFt.setStore((StoreInfo)catalog.getDefaultDataStore(catalog.getWorkspaceByName("sf")));
        lakesFt.setNativeBoundingBox(new ReferencedEnvelope(-10.0, 10.0, -10.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        catalog.add((ResourceInfo)lakesFt);
        lakesFt = catalog.getFeatureTypeByName("sf", "Lakes");
        LayerInfo lakes = catalog.getFactory().createLayer();
        lakes.setResource((ResourceInfo)lakesFt);
        catalog.add(lakes);
        Assert.assertNotNull((Object)catalog.getLayerByName("sf:Lakes"));
        Assert.assertNotNull((Object)catalog.getLayerByName("cite:Lakes"));
        String xml = "<layerGroup><name>doubleLayerGroup</name><layers><layer>sf:Lakes</layer><layer>cite:Lakes</layer></layers></layerGroup>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        LayerGroupInfo lg = catalog.getLayerGroupByName("doubleLayerGroup");
        Assert.assertNotNull((Object)lg);
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((Object)"Lakes", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertEquals((Object)"sf:Lakes", (Object)((PublishedInfo)lg.getLayers().get(0)).prefixedName());
        Assert.assertEquals((Object)"Lakes", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
        Assert.assertEquals((Object)"cite:Lakes", (Object)((PublishedInfo)lg.getLayers().get(1)).prefixedName());
        Document dom = this.getAsDOM("/rest/layergroups/doubleLayerGroup.xml");
        this.print(dom);
        Assert.assertEquals((Object)"layerGroup", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"doubleLayerGroup", (String)"/layerGroup/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//published)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//style)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf:Lakes", (String)"//publishables/published[1]/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"cite:Lakes", (String)"//publishables/published[2]/name", (Document)dom);
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='sf:Lakes']/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/workspaces/sf/layers/Lakes.xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='sf:Lakes']/atom:link/@type", dom), (Matcher)Matchers.equalTo((Object)"application/xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='cite:Lakes']/atom:link/@href", dom), (Matcher)Matchers.endsWith((String)"/rest/workspaces/cite/layers/Lakes.xml"));
        MatcherAssert.assertThat((Object)xp.evaluate("//published[name='cite:Lakes']/atom:link/@type", dom), (Matcher)Matchers.equalTo((Object)"application/xml"));
    }

    @Test
    public void testLayersStylesInWorkspace() throws Exception {
        this.testPostToWorkspace();
        Catalog cat = this.getCatalog();
        StyleInfo s = cat.getFactory().createStyle();
        s.setName("s1");
        s.setWorkspace(cat.getWorkspaceByName("sf"));
        s.setFilename("s1.sld");
        cat.add(s);
        s = cat.getFactory().createStyle();
        s.setName("s2");
        s.setWorkspace(cat.getWorkspaceByName("sf"));
        s.setFilename("s2.sld");
        cat.add(s);
        String xml = "<layerGroup><layers><layer>PrimitiveGeoFeature</layer><layer>AggregateGeoFeature</layer></layers><styles><style><name>s1</name><workspace>sf</workspace></style><style><name>s2</name><workspace>sf</workspace></style></styles></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/layergroups/workspaceLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo lg = cat.getLayerGroupByName("sf", "workspaceLayerGroup");
        Assert.assertEquals((long)2L, (long)lg.getLayers().size());
        Assert.assertEquals((long)2L, (long)lg.getStyles().size());
        Assert.assertEquals((Object)"PrimitiveGeoFeature", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
        Assert.assertEquals((Object)"AggregateGeoFeature", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
        Assert.assertEquals((Object)"s1", (Object)((StyleInfo)lg.getStyles().get(0)).getName());
        Assert.assertNotNull((Object)((StyleInfo)lg.getStyles().get(0)).getWorkspace());
        Assert.assertEquals((Object)"sf", (Object)((StyleInfo)lg.getStyles().get(0)).getWorkspace().getName());
        Assert.assertEquals((Object)"s2", (Object)((StyleInfo)lg.getStyles().get(1)).getName());
        Assert.assertNotNull((Object)((StyleInfo)lg.getStyles().get(1)).getWorkspace());
        Assert.assertEquals((Object)"sf", (Object)((StyleInfo)lg.getStyles().get(1)).getWorkspace().getName());
        Document dom = this.getAsDOM("/rest/workspaces/sf/layergroups/workspaceLayerGroup.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/workspaces/sf/styles/s1.xml", (String)"//style[name = 'sf:s1']/atom:link/@href", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost:8080/geoserver/rest/workspaces/sf/styles/s2.xml", (String)"//style[name = 'sf:s2']/atom:link/@href", (Document)dom);
    }

    @Test
    public void testPutInternationalAbstract() throws Exception {
        String xml = "<layerGroup><name>sfLayerGroup</name><styles><style>polygon</style><style>line</style></styles><attribution>  <logoWidth>101</logoWidth>  <logoHeight>102</logoHeight></attribution><internationalAbstract><en>english abstract</en><it>abstract italiano</it></internationalAbstract></layerGroup>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/sfLayerGroup", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        LayerGroupInfo lg = catalog.getLayerGroupByName("sfLayerGroup");
        Assert.assertEquals((Object)"abstract italiano", (Object)lg.getInternationalAbstract().toString(Locale.ITALIAN));
        Assert.assertEquals((Object)"english abstract", (Object)lg.getInternationalAbstract().toString(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutAndGetLayerGroupStyle() throws Exception {
        LayerGroupInfo lg = catalog.getLayerGroupByName("citeLayerGroup");
        Assert.assertEquals((long)0L, (long)lg.getLayerGroupStyles().size());
        try {
            StyleInfoImpl styleName = new StyleInfoImpl(catalog);
            styleName.setName("theGroupStyleName");
            String xml = "<layerGroup><layerGroupStyles>\n    <LayerGroupStyle>\n      <name>theGroupStyle</name>\n      <internationalTitle/>\n      <internationalAbstract/>\n      <layers>\n        <published type=\"layer\">Ponds</published>        <published type=\"layer\">Forests</published>      </layers>\n      <styles>\n        <style>polygon</style>\n        <style/>\n      </styles>\n    </LayerGroupStyle>\n  </layerGroupStyles></layerGroup>";
            MockHttpServletResponse response = this.putAsServletResponse("/rest/layergroups/citeLayerGroup", xml, "text/xml");
            Assert.assertEquals((long)200L, (long)response.getStatus());
            lg = catalog.getLayerGroupByName("citeLayerGroup");
            Assert.assertEquals((long)1L, (long)lg.getLayerGroupStyles().size());
            LayerGroupStyle groupStyle = (LayerGroupStyle)lg.getLayerGroupStyles().get(0);
            Assert.assertEquals((long)2L, (long)groupStyle.getLayers().size());
            Assert.assertEquals((long)2L, (long)groupStyle.getStyles().size());
            Document dom = this.getAsDOM("/rest/layergroups/citeLayerGroup.xml");
            XMLAssert.assertXpathEvaluatesTo((String)"theGroupStyle", (String)"/layerGroup/layerGroupStyles/LayerGroupStyle/name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"cite:Ponds", (String)"//LayerGroupStyle/layers/published[1]/name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"cite:Forests", (String)"//LayerGroupStyle/layers/published[2]/name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"polygon", (String)"//LayerGroupStyle/styles/style[1]/name", (Document)dom);
            XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//LayerGroupStyle/styles/style[2]", (Document)dom);
        }
        finally {
            lg.setLayerGroupStyles(Collections.emptyList());
            catalog.save(lg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testPostJSONWithContainedGroupStyleNull() throws Exception {
        LayerGroupInfo lg = null;
        try {
            String json = "{\n  \"layerGroup\": {\n    \"name\": \"layerGroupNullStyle\",\n    \"publishables\": {\n  \"published\": [\n    {\n      \"name\": \"sfLayerGroup\",\n      \"@type\": \"layerGroup\"\n    },    {\n      \"name\": \"citeLayerGroup\",\n      \"@type\": \"layerGroup\"\n    }  ]\n},\n    \"styles\": null  }\n}";
            MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", json, "application/json");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
            Assert.assertNotNull((Object)response.getHeader("Location"));
            Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/layerGroupNullStyle"));
            lg = catalog.getLayerGroupByName("layerGroupNullStyle");
            Assert.assertNotNull((Object)lg);
            Assert.assertEquals((long)2L, (long)lg.getLayers().size());
            Assert.assertEquals((Object)"sfLayerGroup", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
            Assert.assertNull(lg.getStyles().get(0));
            Assert.assertEquals((Object)"citeLayerGroup", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
            Assert.assertNull(lg.getStyles().get(0));
            if (lg == null) return;
        }
        catch (Throwable throwable) {
            if (lg == null) throw throwable;
            catalog.remove(lg);
            throw throwable;
        }
        catalog.remove(lg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testPostXMLWithContainedGroupStyleNull() throws Exception {
        LayerGroupInfo lg = null;
        try {
            String xml = "<layerGroup><name>layerGroupNullStyle2</name><publishables><published type=\"layerGroup\">sfLayerGroup</published><published type=\"layerGroup\">citeLayerGroup</published></publishables><styles/></layerGroup>";
            MockHttpServletResponse response = this.postAsServletResponse("/rest/layergroups", xml, "text/xml");
            Assert.assertEquals((long)201L, (long)response.getStatus());
            Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
            Assert.assertNotNull((Object)response.getHeader("Location"));
            Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/layergroups/layerGroupNullStyle2"));
            lg = catalog.getLayerGroupByName("layerGroupNullStyle2");
            Assert.assertNotNull((Object)lg);
            Assert.assertEquals((long)2L, (long)lg.getLayers().size());
            Assert.assertEquals((Object)"sfLayerGroup", (Object)((PublishedInfo)lg.getLayers().get(0)).getName());
            Assert.assertNull(lg.getStyles().get(0));
            Assert.assertEquals((Object)"citeLayerGroup", (Object)((PublishedInfo)lg.getLayers().get(1)).getName());
            Assert.assertNull(lg.getStyles().get(0));
            if (lg == null) return;
        }
        catch (Throwable throwable) {
            if (lg == null) throw throwable;
            catalog.remove(lg);
            throw throwable;
        }
        catalog.remove(lg);
    }
}

