/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;

public class HttpTestUtils {
    private HttpTestUtils() {
        throw new UnsupportedOperationException();
    }

    public static Matcher<HttpServletResponse> hasStatus(final HttpStatus expectedStatus) {
        return new BaseMatcher<HttpServletResponse>(){

            public boolean matches(Object item) {
                if (item instanceof HttpServletResponse) {
                    HttpStatus value = HttpStatus.valueOf((int)((HttpServletResponse)item).getStatus());
                    return value == expectedStatus;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("HTTP Response with status ").appendValue((Object)expectedStatus.value()).appendText(" ").appendValue((Object)expectedStatus.getReasonPhrase());
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof HttpServletResponse) {
                    HttpStatus value = HttpStatus.valueOf((int)((HttpServletResponse)item).getStatus());
                    description.appendText("status was ").appendValue((Object)value.value()).appendText(" ").appendValue((Object)value.getReasonPhrase());
                } else {
                    description.appendText("was not an HttpServletResponse");
                }
            }
        };
    }

    public static Matcher<HttpServletResponse> hasHeader(final String name, final Matcher<String> valueMatcher) {
        return new BaseMatcher<HttpServletResponse>(){

            public boolean matches(Object item) {
                if (item instanceof HttpServletResponse) {
                    String value = ((HttpServletResponse)item).getHeader(name);
                    return !Objects.isNull(value) && valueMatcher.matches((Object)value);
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("HTTP Response with header ").appendValue((Object)name).appendText(" with value ").appendDescriptionOf((SelfDescribing)valueMatcher);
            }

            public void describeMismatch(Object item, Description description) {
                if (item instanceof HttpServletResponse) {
                    String value = ((HttpServletResponse)item).getHeader(name);
                    if (Objects.isNull(value)) {
                        description.appendText("did not have header ").appendValue((Object)"name");
                    } else {
                        description.appendText("header ").appendValue((Object)name).appendText(" ");
                        valueMatcher.describeMismatch((Object)value, description);
                    }
                } else {
                    description.appendText("was not an HttpServletResponse");
                }
            }
        };
    }

    public static InputStream istream(MockHttpServletResponse response) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(response.getContentAsString().getBytes());
    }
}

