/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionCustomizerReader;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CoverageStoreControllerTest
extends CatalogRESTTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpDefaultRasterLayers();
    }

    @Before
    public void addBlueMarbleCoverage() throws Exception {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
    }

    @Test
    public void testGetAllOnMissingWorkspace() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/abcde/coveragestores.xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"abcde"));
    }

    @Test
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores.xml");
        Assert.assertEquals((long)catalog.getStoresByWorkspace("wcs", CoverageStoreInfo.class).size(), (long)dom.getElementsByTagName("coverageStore").getLength());
    }

    @Test
    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores.json");
        Assert.assertTrue((boolean)(json instanceof JSONObject));
        Object coveragestores = ((JSONObject)json).getJSONObject("coverageStores").get("coverageStore");
        Assert.assertNotNull((Object)coveragestores);
        if (coveragestores instanceof JSONArray) {
            Assert.assertEquals((long)catalog.getCoverageStoresByWorkspace("wcs").size(), (long)((JSONArray)coveragestores).size());
        } else {
            Assert.assertEquals((long)1L, (long)catalog.getCoverageStoresByWorkspace("wcs").size());
        }
    }

    @Test
    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores.html");
        List coveragestores = catalog.getCoverageStoresByWorkspace("wcs");
        NodeList links = xp.getMatchingNodes("//html:a", dom);
        Assert.assertEquals((long)coveragestores.size(), (long)links.getLength());
        for (int i = 0; i < coveragestores.size(); ++i) {
            CoverageStoreInfo cs = (CoverageStoreInfo)coveragestores.get(i);
            Element link = (Element)links.item(i);
            Assert.assertTrue((boolean)link.getAttribute("href").endsWith(cs.getName() + ".html"));
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/wcs/coveragestores").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores").getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        Assert.assertEquals((Object)"coverageStore", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"BlueMarble", (Object)xp.evaluate("/coverageStore/name", dom));
        Assert.assertEquals((Object)"wcs", (Object)xp.evaluate("/coverageStore/workspace/name", dom));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/workspaces/wcs.xml", (Object)xp.evaluate("/coverageStore/workspace/atom:link/@href", dom));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/workspaces/wcs/coveragestores/BlueMarble/coverages.xml", (Object)xp.evaluate("/coverageStore/coverages/atom:link/@href", dom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAsHTML() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo coverage = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_BM));
        String oldName = coverage.getName();
        coverage.setName("fooBar");
        catalog.save((ResourceInfo)coverage);
        try {
            Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.html");
            CoverageStoreInfo cs = CatalogRESTTestSupport.catalog.getCoverageStoreByName("wcs", "BlueMarble");
            List coverages = CatalogRESTTestSupport.catalog.getCoveragesByCoverageStore(cs);
            NodeList links = xp.getMatchingNodes("//html:a", dom);
            Assert.assertEquals((long)coverages.size(), (long)links.getLength());
            for (int i = 0; i < coverages.size(); ++i) {
                CoverageInfo cov = (CoverageInfo)coverages.get(i);
                Element link = (Element)links.item(i);
                Assert.assertTrue((boolean)link.getAttribute("href").endsWith("coverages/" + cov.getName() + ".html"));
            }
        }
        finally {
            coverage.setName(oldName);
            catalog.save((ResourceInfo)coverage);
        }
    }

    @Test
    public void testGetWrongCoverageStore() throws Exception {
        String ws = "wcs";
        String cs = "BlueMarblesssss";
        String requestPath = "/rest/workspaces/" + ws + "/coveragestores/" + cs + ".html";
        String exception = "No such coverage store: " + ws + "," + cs;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getContentAsString().contains(exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertFalse((boolean)response.getContentAsString().contains(exception));
        Assert.assertTrue((boolean)response.getContentAsString().isEmpty());
    }

    File setupNewCoverageStore() throws Exception {
        File dir = new File("./target/usa");
        dir.mkdir();
        dir.deleteOnExit();
        File f = new File(dir, "usa.prj");
        f.deleteOnExit();
        try (FileOutputStream fout = new FileOutputStream(f);){
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.prj"), (OutputStream)fout);
            fout.flush();
        }
        f = new File(dir, "usa.meta");
        f.deleteOnExit();
        fout = new FileOutputStream(f);
        try {
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.meta"), (OutputStream)fout);
            fout.flush();
        }
        finally {
            fout.close();
        }
        f = new File(dir, "usa.png");
        f.deleteOnExit();
        fout = new FileOutputStream(f);
        try {
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/usa.png"), (OutputStream)fout);
            fout.flush();
        }
        finally {
            fout.close();
        }
        return f;
    }

    @Test
    public void testPostAsXML() throws Exception {
        this.removeStore("wcs", "newCoverageStore");
        File f = this.setupNewCoverageStore();
        String xml = "<coverageStore><name>newCoverageStore</name><type>WorldImage</type><url>file://" + f.getAbsolutePath() + "</url><workspace>wcs</workspace></coverageStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores", xml, "text/xml");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/wcs/coveragestores/newCoverageStore"));
        CoverageStoreInfo newCoverageStore = catalog.getCoverageStoreByName("newCoverageStore");
        Assert.assertNotNull((Object)newCoverageStore);
        Assert.assertNotNull((Object)newCoverageStore.getFormat());
    }

    @Test
    public void testRoundTripCoverageStoreXML() throws Exception {
        CoverageInfo before = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_BM));
        String xml = this.getAsString("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CoverageInfo after = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_BM));
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores/BlueMarble.json");
        JSONObject coverageStore = ((JSONObject)json).getJSONObject("coverageStore");
        Assert.assertNotNull((Object)coverageStore);
        Assert.assertEquals((Object)"BlueMarble", (Object)coverageStore.get("name"));
        Assert.assertEquals((Object)"wcs", (Object)coverageStore.getJSONObject("workspace").get("name"));
        Assert.assertNotNull((Object)coverageStore.get("type"));
        Assert.assertNotNull((Object)coverageStore.get("url"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/workspaces/wcs.json", (Object)coverageStore.getJSONObject("workspace").get("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/workspaces/wcs/coveragestores/BlueMarble/coverages.json", (Object)coverageStore.get("coverages"));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        this.removeStore("wcs", "newCoverageStore");
        File f = this.setupNewCoverageStore();
        String json = "{'coverageStore':{'name':'newCoverageStore','type': 'WorldImage','url':'" + f.getAbsolutePath().replace('\\', '/') + "','workspace':'wcs',}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores", json, "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertNotNull((Object)response.getHeader("Location"));
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/wcs/coveragestores/newCoverageStore"));
        CoverageStoreInfo newCoverageStore = catalog.getCoverageStoreByName("newCoverageStore");
        Assert.assertNotNull((Object)newCoverageStore);
        Assert.assertNotNull((Object)newCoverageStore.getFormat());
    }

    @Test
    public void testRoundTripCoverageStoreJSON() throws Exception {
        CoverageInfo before = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_BM));
        String xml = this.getAsString("/rest/workspaces/wcs/coveragestores/BlueMarble.json");
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CoverageInfo after = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_BM));
        Assert.assertEquals((Object)before, (Object)after);
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<coverageStore><name>BlueMarble</name><enabled>false</enabled></coverageStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/coverageStore/enabled", (Document)dom);
        String xml = "<coverageStore><name>BlueMarble</name><enabled>false</enabled></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/coverageStore/enabled", (Document)dom);
        Assert.assertFalse((boolean)catalog.getCoverageStoreByName("wcs", "BlueMarble").isEnabled());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        CoverageStoreInfo cs = catalog.getCoverageStoreByName("wcs", "BlueMarble");
        Assert.assertTrue((boolean)cs.isEnabled());
        String xml = "<coverageStore><name>BlueMarble</name></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        cs = catalog.getCoverageStoreByName("wcs", "BlueMarble");
        Assert.assertTrue((boolean)cs.isEnabled());
    }

    @Test
    @Ignore
    public void testPutEmptyAndHarvest() throws Exception {
        File dir = new File("./target/empty");
        dir.mkdir();
        dir.deleteOnExit();
        File f = new File(dir, "empty.zip");
        f.deleteOnExit();
        try (FileOutputStream fout = new FileOutputStream(f);){
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/empty.zip"), (OutputStream)fout);
            fout.flush();
        }
        int length = (int)f.length();
        byte[] zipData = new byte[length];
        try (FileInputStream fis = new FileInputStream(f);){
            fis.read(zipData);
        }
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/empty/file.imagemosaic?configure=none", zipData, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/empty.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/coverageStore/enabled", (Document)dom);
        f = new File(dir, "NCOM_wattemp_020_20081031T0000000_12.tiff");
        f.deleteOnExit();
        try (FileOutputStream fout = new FileOutputStream(f);){
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/NCOM_wattemp_020_20081031T0000000_12.tiff"), (OutputStream)fout);
            fout.flush();
        }
        String path = "file://" + f.getCanonicalPath();
        response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/empty/external.imagemosaic", path, "text/plain");
        Assert.assertEquals((long)202L, (long)response.getStatus());
        dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/empty/coverages.xml?list=all");
        XMLAssert.assertXpathEvaluatesTo((String)"index", (String)"/list/coverageName", (Document)dom);
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/empty?recurse=true&purge=all").getStatus());
    }

    private void purgeRequest(String purge, int expectedFiles) throws Exception {
        File dir = new File("./target/mosaicfordelete");
        dir.mkdir();
        dir.deleteOnExit();
        File f = new File(dir, "mosaic.zip");
        f.deleteOnExit();
        try (FileOutputStream fout = new FileOutputStream(f);){
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/mosaic.zip"), (OutputStream)fout);
            fout.flush();
        }
        int length = (int)f.length();
        byte[] zipData = new byte[length];
        try (FileInputStream fis = new FileInputStream(f);){
            fis.read(zipData);
        }
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/mosaicfordelete/file.imagemosaic", zipData, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/mosaicfordelete.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/coverageStore/enabled", (Document)dom);
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        File storeDir = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)"data/wcs/mosaicfordelete"), (boolean)true);
        File[] content = storeDir.listFiles();
        MatcherAssert.assertThat((Object)content.length, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Matchers.equalTo((Object)9), Matchers.equalTo((Object)10), Matchers.equalTo((Object)11)}));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/mosaicfordelete?recurse=true&purge=" + purge).getStatus());
        content = storeDir.listFiles();
        Assert.assertEquals((long)expectedFiles, (long)content.length);
        Assert.assertNull((Object)catalog.getCoverageStoreByName("wcs", "mosaicfordelete"));
    }

    @Test
    public void testDeletePurgeMetadataAfterConfigure() throws Exception {
        this.purgeRequest("metadata", 1);
    }

    @Test
    public void testDeletePurgeAllAfterConfigure() throws Exception {
        this.purgeRequest("all", 0);
    }

    @Test
    public void testPut2() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"GeoTIFF", (String)"/coverageStore/type", (Document)dom);
        String xml = "<coverageStore><name>BlueMarble</name><type>WorldImage</type></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CoverageStoreInfo cs = catalog.getCoverageStoreByName("wcs", "BlueMarble");
        Assert.assertEquals((Object)"WorldImage", (Object)cs.getType());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<coverageStore><name>changed</name></coverageStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/nonExistant", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/nonExistant").getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        CoverageStoreInfo cs = catalog.getCoverageStoreByName("wcs", "BlueMarble");
        List coverages = catalog.getCoveragesByCoverageStore(cs);
        for (CoverageInfo c : coverages) {
            for (LayerInfo l : catalog.getLayers((ResourceInfo)c)) {
                catalog.remove(l);
            }
            catalog.remove((ResourceInfo)c);
        }
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble").getStatus());
        Assert.assertNull((Object)catalog.getCoverageStoreByName("wcs", "BlueMarble"));
    }

    @Test
    public void testDeleteNonEmpty() throws Exception {
        Assert.assertEquals((long)401L, (long)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        Assert.assertNotNull((Object)catalog.getCoverageStoreByName("wcs", "BlueMarble"));
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble?recurse=true");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertNull((Object)catalog.getCoverageStoreByName("wcs", "BlueMarble"));
        for (CoverageInfo c : catalog.getCoverages()) {
            if (!c.getStore().getName().equals("BlueMarble")) continue;
            Assert.fail();
        }
    }

    @Test
    public void testCoverageStoreReset() throws Exception {
        CoverageStoreInfo cs = catalog.getCoverageStoreByName("wcs", "BlueMarble");
        GridCoverage2DReader reader = ((CoverageDimensionCustomizerReader)cs.getGridCoverageReader(null, null)).getDelegate();
        Assert.assertNotNull((Object)reader);
        MatcherAssert.assertThat((Object)reader, (Matcher)CoreMatchers.instanceOf(GeoTiffReader.class));
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(SystemTestData.TASMANIA_BM));
        Assert.assertNotNull((Object)ci);
        GridCoverage2D gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelope = gridCoverage.getEnvelope();
        CoverageStoreControllerTest.dispose(gridCoverage);
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/reset", "", null);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        try (InputStream is = SystemTestData.class.getResourceAsStream("world.tiff");
             OutputStream os = this.getDataDirectory().get(new String[]{"BlueMarble/tazbm.tiff"}).out();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        GridCoverage2DReader readerNew = ((CoverageDimensionCustomizerReader)cs.getGridCoverageReader(null, null)).getDelegate();
        Assert.assertNotNull((Object)readerNew);
        Assert.assertNotSame((Object)readerNew, (Object)reader);
        gridCoverage = (GridCoverage2D)ci.getGridCoverage(null, null);
        Bounds envelopeNew = gridCoverage.getEnvelope();
        Assert.assertNotEquals((Object)envelopeNew, (Object)envelope);
        CoverageStoreControllerTest.dispose(gridCoverage);
    }
}

