/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.File;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.impl.LoggingInfoImpl;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LoggingControllerTest
extends CatalogRESTTestSupport {
    protected GeoServer geoServer;
    protected static File logsDir = null;

    @Before
    public void init() {
        this.geoServer = this.getGeoServer();
        LoggingInfoImpl loggingInfo = new LoggingInfoImpl();
        loggingInfo.setLocation("logs/geoserver-test.log");
        loggingInfo.setLevel("TEST_LOGGING.xml");
        loggingInfo.setStdOutLogging(true);
        this.geoServer.setLogging((LoggingInfo)loggingInfo);
    }

    @After
    public void reset() throws Exception {
        Resource logs = this.getDataDirectory().get(new String[]{"logs"});
        if (logs.getType() == Resource.Type.DIRECTORY) {
            logsDir = logs.dir();
        }
        LocalWorkspace.remove();
    }

    @AfterClass
    public static void cleanupLogs() {
        if (logsDir != null) {
            Files.delete((File)logsDir);
            logsDir = null;
        }
    }

    @Test
    public void testGetLoggingAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/logging.json");
        this.print(json);
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject loggingInfo = jsonObject.getJSONObject("logging");
        Assert.assertNotNull((Object)loggingInfo);
        Assert.assertEquals((Object)"TEST_LOGGING.xml", (Object)loggingInfo.get("level"));
        Assert.assertEquals((Object)"logs/geoserver-test.log", (Object)loggingInfo.get("location"));
        Assert.assertEquals((Object)true, (Object)loggingInfo.get("stdOutLogging"));
    }

    @Test
    public void testGetLoggingAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/logging.xml");
        Assert.assertEquals((Object)"logging", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"TEST_LOGGING.xml", (String)"/logging/level", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"logs/geoserver-test.log", (String)"/logging/location", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/logging/stdOutLogging", (Document)dom);
    }

    @Test
    public void testGetLoggingAsHTML() throws Exception {
        this.getAsDOM("/rest/logging.html", 200);
    }

    @Test
    public void testPutLoggingAsJSON() throws Exception {
        String inputJson = "{'logging':{    'level':'DEFAULT_LOGGING.xml',    'location':'logs/geoserver-test-2.log',    'stdOutLogging':false}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/logging", inputJson, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/logging.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject loggingInfo = jsonObject.getJSONObject("logging");
        Assert.assertNotNull((Object)loggingInfo);
        Assert.assertEquals((Object)"DEFAULT_LOGGING.xml", (Object)loggingInfo.get("level"));
        Assert.assertEquals((Object)"logs/geoserver-test-2.log", (Object)loggingInfo.get("location"));
        Assert.assertEquals((Object)false, (Object)loggingInfo.get("stdOutLogging"));
    }

    @Test
    public void testPutLoggingAsXML() throws Exception {
        String xml = "<logging> <level>DEFAULT_LOGGING.xml</level><location>logs/geoserver-test-2.log</location><stdOutLogging>false</stdOutLogging> </logging>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/logging", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/logging.xml");
        Assert.assertEquals((Object)"logging", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"DEFAULT_LOGGING.xml", (String)"/logging/level", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"logs/geoserver-test-2.log", (String)"/logging/location", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/logging/stdOutLogging", (Document)dom);
    }
}

