/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.geoserver.rest.catalog.StringsList;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geoserver.rest.util.MediaTypeExtensions;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class StringsListJSONConverter
extends BaseMessageConverter<StringsList> {
    public StringsListJSONConverter() {
        super(new MediaType[]{MediaType.APPLICATION_JSON, MediaTypeExtensions.TEXT_JSON});
    }

    protected boolean supports(Class<?> clazz) {
        return StringsList.class.isAssignableFrom(clazz);
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    public void writeInternal(StringsList stringsList, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Map<String, Map<String, List<String>>> values = Collections.singletonMap("list", Collections.singletonMap("string", stringsList.getValues()));
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputMessage.getBody()));
        JSONObject.fromObject(values).write((Writer)outWriter);
        ((Writer)outWriter).flush();
        ((Writer)outWriter).close();
    }
}

