/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.vfny.geoserver.util.DataStoreUtils;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/workspaces/{workspaceName}/datastores"})
public class DataStoreController
extends AbstractCatalogController {
    private static final Logger LOGGER = Logging.getLogger(DataStoreController.class);

    @Autowired
    public DataStoreController(@Qualifier(value="catalog") Catalog catalog) {
        super(catalog);
    }

    @GetMapping(produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<DataStoreInfo> dataStoresGet(@PathVariable String workspaceName) {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspaceName);
        if (ws == null) {
            throw new ResourceNotFoundException("No such workspace : " + workspaceName);
        }
        List dataStores = this.catalog.getDataStoresByWorkspace(ws);
        return this.wrapList(dataStores, DataStoreInfo.class);
    }

    @GetMapping(path={"{storeName}"}, produces={"application/json", "application/xml", "text/html"})
    public RestWrapper<DataStoreInfo> dataStoreGet(@PathVariable String workspaceName, @PathVariable String storeName) {
        DataStoreInfo dataStore = this.getExistingDataStore(workspaceName, storeName);
        return this.wrapObject(dataStore, DataStoreInfo.class);
    }

    @PostMapping(consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public ResponseEntity<String> dataStorePost(@RequestBody DataStoreInfo dataStore, @PathVariable String workspaceName, UriComponentsBuilder builder) {
        block9: {
            WorkspaceInfo ws;
            if (dataStore.getWorkspace() != null) {
                ws = dataStore.getWorkspace();
                if (!workspaceName.equals(ws.getName())) {
                    throw new RestException("Expected workspace " + workspaceName + " but client specified " + ws.getName(), HttpStatus.FORBIDDEN);
                }
            } else {
                dataStore.setWorkspace(this.catalog.getWorkspaceByName(workspaceName));
            }
            dataStore.setEnabled(true);
            if (!dataStore.getConnectionParameters().containsKey("namespace")) {
                ws = dataStore.getWorkspace();
                NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ws.getName());
                if (ns == null) {
                    ns = this.catalog.getDefaultNamespace();
                }
                if (ns != null) {
                    dataStore.getConnectionParameters().put("namespace", ns.getURI());
                }
            }
            if (dataStore.getType() == null) {
                try {
                    DataAccessFactory factory = DataStoreUtils.aquireFactory((Map)dataStore.getConnectionParameters());
                    dataStore.setType(factory.getDisplayName());
                }
                catch (Exception e) {
                    LOGGER.warning("Unable to determine datastore type from connection parameters");
                    if (!LOGGER.isLoggable(Level.FINE)) break block9;
                    LOGGER.log(Level.FINE, "", e);
                }
            }
        }
        this.catalog.validate((StoreInfo)dataStore, true).throwIfInvalid();
        this.catalog.add((StoreInfo)dataStore);
        String storeName = dataStore.getName();
        LOGGER.info("POST data store " + storeName);
        UriComponents uriComponents = builder.path("/workspaces/{workspaceName}/datastores/{storeName}").buildAndExpand(new Object[]{workspaceName, storeName});
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(uriComponents.toUri());
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)storeName, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @PutMapping(value={"{storeName}"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void dataStorePut(@RequestBody DataStoreInfo info, @PathVariable String workspaceName, @PathVariable String storeName) {
        DataStoreInfo original = this.getExistingDataStore(workspaceName, storeName);
        new CatalogBuilder(this.catalog).updateDataStore(original, info);
        this.catalog.validate((StoreInfo)original, false).throwIfInvalid();
        this.catalog.save((StoreInfo)original);
        LOGGER.info("PUT datastore " + workspaceName + "," + storeName);
    }

    @DeleteMapping(value={"{storeName}"})
    public void dataStoreDelete(@PathVariable String workspaceName, @PathVariable String storeName, @RequestParam(name="recurse", required=false, defaultValue="false") boolean recurse, @RequestParam(name="purge", required=false, defaultValue="none") String deleteType) throws IOException {
        DataStoreInfo ds = this.getExistingDataStore(workspaceName, storeName);
        if (recurse) {
            new CascadeDeleteVisitor(this.catalog).visit(ds);
        } else {
            try {
                this.catalog.remove((StoreInfo)ds);
            }
            catch (IllegalArgumentException e) {
                throw new RestException(e.getMessage(), HttpStatus.FORBIDDEN, (Throwable)e);
            }
        }
        LOGGER.info("DELETE datastore " + workspaceName + ":s" + workspaceName);
    }

    @RequestMapping(value={"{storeName}/reset"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void reset(@PathVariable String workspaceName, @PathVariable String storeName) {
        DataStoreInfo ds = this.getExistingDataStore(workspaceName, storeName);
        this.catalog.getResourcePool().clear(ds);
    }

    private DataStoreInfo getExistingDataStore(String workspaceName, String storeName) {
        DataStoreInfo original = this.catalog.getDataStoreByName(workspaceName, storeName);
        if (original == null) {
            throw new ResourceNotFoundException("No such datastore: " + workspaceName + "," + storeName);
        }
        return original;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return DataStoreInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, final XStreamMessageConverter converter) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected Class<DataStoreInfo> getObjectClass() {
                return DataStoreInfo.class;
            }

            protected CatalogInfo getCatalogObject() {
                Map uriTemplateVars = DataStoreController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                String datastore = (String)uriTemplateVars.get("storeName");
                if (workspace == null || datastore == null) {
                    return null;
                }
                return DataStoreController.this.catalog.getDataStoreByName(workspace, datastore);
            }

            protected void postEncodeDataStore(DataStoreInfo ds, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("featureTypes");
                converter.encodeCollectionLink("featuretypes", writer);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, String prefix, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    converter.encodeLink("/workspaces/" + converter.encode(ref), writer);
                }
            }
        });
    }

    protected String getTemplateName(Object object) {
        if (object instanceof DataStoreInfo) {
            return "DataStoreInfo";
        }
        return null;
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<DataStoreInfo>(DataStoreInfo.class){

            protected void wrapInternal(Map<String, Object> properties, SimpleHash model, DataStoreInfo dataStoreInfo) {
                if (properties == null) {
                    properties = this.hashToProperties(model);
                }
                ArrayList dsProps = new ArrayList();
                List featureTypes = DataStoreController.this.catalog.getFeatureTypesByDataStore(dataStoreInfo);
                for (FeatureTypeInfo ft : featureTypes) {
                    HashMap<String, String> names = new HashMap<String, String>();
                    names.put("name", ft.getName());
                    dsProps.add(Collections.singletonMap("properties", names));
                }
                if (!dsProps.isEmpty()) {
                    properties.putIfAbsent("featureTypes", dsProps);
                }
            }

            protected void wrapInternal(SimpleHash model, Collection object) {
                for (Object w : object) {
                    DataStoreInfo wk = (DataStoreInfo)w;
                    this.wrapInternal(null, model, wk);
                }
            }
        };
    }
}

