/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.security;

import java.io.IOException;
import java.text.MessageFormat;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.PasswordPolicyException;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.HttpStatus;

public class UserPasswordControllerTest
extends GeoServerSystemTestSupport {
    static final String UP_URI = "/rest/security/self/password";
    static final String USERNAME = "restuser";
    static final String USERPW = "restpassword";
    protected static XpathEngine xp;
    String xmlTemplate = "<userPassword><newPassword>{0}</newPassword></userPassword>";
    String xmlBadTemplate = "<userPassword><not_the_right_element>{0}</not_the_right_element></userPassword>";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        if (service.getUserByUsername(USERNAME) == null) {
            GeoServerUser user = service.createUserObject(USERNAME, USERPW, true);
            GeoServerUserGroupStore store = service.createStore();
            store.addUser(user);
            store.store();
            service.load();
        }
        xp = XMLUnit.newXpathEngine();
    }

    public void resetUserPassword() throws IOException, PasswordPolicyException {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        GeoServerUser user = service.getUserByUsername(USERNAME);
        user.setPassword(USERPW);
        GeoServerUserGroupStore store = service.createStore();
        store.updateUser(user);
        store.store();
        service.load();
    }

    public void login() throws Exception {
        this.resetUserPassword();
        this.login(USERNAME, USERPW, new String[]{"ROLE_AUTHENTICATED"});
    }

    @Test
    public void testGetAsAuthorized() throws Exception {
        this.login();
        Assert.assertEquals((Object)HttpStatus.METHOD_NOT_ALLOWED, (Object)HttpStatus.valueOf((int)this.getAsServletResponse(UP_URI).getStatus()));
    }

    @Test
    public void testGetAsNotAuthorized() throws Exception {
        this.logout();
        Assert.assertEquals((Object)HttpStatus.METHOD_NOT_ALLOWED, (Object)HttpStatus.valueOf((int)this.getAsServletResponse(UP_URI).getStatus()));
    }

    @Test
    public void testPutUnauthorized() throws Exception {
        this.logout();
        String body = MessageFormat.format(this.xmlTemplate, "new01");
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
    }

    @Test
    public void testPutInvalidNewPassword() throws Exception {
        this.login();
        String body = MessageFormat.format(this.xmlTemplate, "   ");
        Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
    }

    @Test
    public void testPutInvalidElement() throws Exception {
        this.login();
        String body = MessageFormat.format(this.xmlBadTemplate, "newpw42");
        Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
    }

    @Test
    public void testPutAsXML() throws Exception {
        this.login();
        String body = MessageFormat.format(this.xmlTemplate, "pw01");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
    }

    @Test
    public void checkUpdatedPassword() throws Exception {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        this.login();
        GeoServerUser user = service.getUserByUsername(USERNAME);
        String originalPw = user.getPassword();
        String body = MessageFormat.format(this.xmlTemplate, "pw01");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
        service.load();
        user = service.getUserByUsername(USERNAME);
        String pw1 = user.getPassword();
        Assert.assertNotEquals((Object)originalPw, (Object)pw1);
        body = MessageFormat.format(this.xmlTemplate, "pw02");
        Assert.assertEquals((long)200L, (long)this.putAsServletResponse(UP_URI, body, "text/xml").getStatus());
        service.load();
        user = service.getUserByUsername(USERNAME);
        String pw2 = user.getPassword();
        Assert.assertNotEquals((Object)originalPw, (Object)pw2);
        Assert.assertNotEquals((Object)pw1, (Object)pw2);
    }
}

