/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.net.URL;
import junit.framework.AssertionFailedError;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.rest.catalog.HttpTestUtils;
import org.geoserver.rest.catalog.WMTSLayerController;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.referencing.CRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMTSLayerTest
extends CatalogRESTTestSupport {
    private static final String LAYER_NAME = "AMSR2_Snow_Water_Equivalent";
    private static final String ANOTHER_LAYER_NAME = "AMSR2_Soil_Moisture_NPD_Day";
    private static final String ANOTHER_LOCAL_NAME = "this_is_the_local_name";
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName("sf"));
        WMTSStoreInfo wmts = cb.buildWMTSStore("demo");
        wmts.setCapabilitiesURL(this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
        catalog.add((StoreInfo)wmts);
        this.addWmtsLayer();
    }

    @Before
    public void addWmtsLayer() throws Exception {
        String capabilities = this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        WMTSLayerInfo wml = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        if (wml == null) {
            wml = catalog.getFactory().createWMTSLayer();
            wml.setName(LAYER_NAME);
            wml.setNativeName("topp:AMSR2_Snow_Water_Equivalent");
            wml.setStore(catalog.getStoreByName("demo", WMTSStoreInfo.class));
            wml.setCatalog(catalog);
            wml.setNamespace(catalog.getNamespaceByPrefix("sf"));
            wml.setSRS("EPSG:4326");
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            wml.setNativeCRS(wgs84);
            wml.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
            wml.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            catalog.add((ResourceInfo)wml);
        }
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("nasa.getcapa.xml"), "text/xml", new String[0]));
        this.clientMocker.bind((HTTPClient)client, capabilities);
    }

    @After
    public void removeLayer() throws Exception {
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", LAYER_NAME));
        if (l != null) {
            catalog.remove(l);
        }
    }

    @Before
    public void removeLocalLayer() throws Exception {
        ResourceInfo r;
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", ANOTHER_LOCAL_NAME));
        if (l != null) {
            catalog.remove(l);
        }
        if ((r = catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class)) != null) {
            catalog.remove(r);
        }
    }

    @Test
    public void testBeanPresent() throws Exception {
        MatcherAssert.assertThat((Object)GeoServerExtensions.extensions(RestBaseController.class), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(WMTSLayerController.class)));
    }

    @Test
    public void testGetAllByWorkspace() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmtslayers.xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((long)catalog.getResourcesByNamespace(catalog.getNamespaceByPrefix("sf"), WMTSLayerInfo.class).size(), (long)dom.getElementsByTagName("wmtsLayer").getLength());
    }

    @Test
    public void testGetAllByWMTSStore() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers.xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wmtsLayer").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wmtsLayer/name[text()='AMSR2_Snow_Water_Equivalent'])", (Document)dom);
    }

    @Test
    public void testGetAllAvailable() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo/layers.xml?list=available", 200);
        this.print(dom);
        XMLAssert.assertXpathExists((String)"/list/wmtsLayerName[text() = 'AMSR2_Snow_Water_Equivalent']", (Document)dom);
        XMLAssert.assertXpathExists((String)"/list/wmtsLayerName[text() = 'AMSR2_Soil_Moisture_NPD_Day']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"/list/wmtsLayerName[text() = 'topp:AMSR2_Snow_Water_Equivalent']", (Document)dom);
    }

    @Test
    public void testGetAllAvailableJSON() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers.json?list=available");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        JSON json = this.json(response);
        JSONArray names = (JSONArray)((JSONObject)((JSONObject)json).get("list")).get("string");
        MatcherAssert.assertThat((Object)names, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.equalTo((Object)LAYER_NAME), Matchers.equalTo((Object)ANOTHER_LAYER_NAME)}));
    }

    protected JSON getAsJSON(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        try {
            return this.json(response);
        }
        catch (JSONException ex) {
            throw new AssertionFailedError("Invalid JSON: \"" + response.getContentAsString() + "\"");
        }
    }

    @Test
    public void testPutAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers").getStatus());
    }

    @Test
    public void testDeleteAllUnauthorized() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers").getStatus());
    }

    @Test
    public void testPostAsXML() throws Exception {
        MatcherAssert.assertThat((Object)((WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class)), (Matcher)Matchers.nullValue());
        String xml = "<wmtsLayer><name>this_is_the_local_name</name><nativeName>AMSR2_Soil_Moisture_NPD_Day</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><store>demo</store></wmtsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmtsstores/demo/layers/this_is_the_local_name")));
        WMTSLayerInfo layer = (WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class);
        MatcherAssert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostAsXMLNoWorkspace() throws Exception {
        MatcherAssert.assertThat((Object)((WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class)), (Matcher)Matchers.nullValue());
        String xml = "<wmtsLayer><name>this_is_the_local_name</name><nativeName>AMSR2_Soil_Moisture_NPD_Day</nativeName><srs>EPSG:4326</srs><nativeCRS>EPSG:4326</nativeCRS><store>demo</store></wmtsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtslayers", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmtslayers/this_is_the_local_name")));
        WMTSLayerInfo layer = (WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class);
        MatcherAssert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostAsJSON() throws Exception {
        MatcherAssert.assertThat((Object)((WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class)), (Matcher)Matchers.nullValue());
        String json = "{'wmtsLayer':{'name':'this_is_the_local_name','nativeName':'AMSR2_Soil_Moisture_NPD_Day','srs':'EPSG:4326','nativeCRS':'EPSG:4326','store':'demo'}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers", json, "text/json");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.CREATED));
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasHeader("Location", (Matcher<String>)Matchers.endsWith((String)"/workspaces/sf/wmtsstores/demo/layers/this_is_the_local_name")));
        WMTSLayerInfo layer = (WMTSLayerInfo)catalog.getResourceByName("sf", ANOTHER_LOCAL_NAME, WMTSLayerInfo.class);
        MatcherAssert.assertThat((Object)layer, (Matcher)Matchers.hasProperty((String)"nativeBoundingBox", (Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testPostToResource() throws Exception {
        String xml = "<wmtsLayer><name>og:restricted</name></wmtsLayer>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent", xml, "text/xml");
        Assert.assertEquals((long)405L, (long)response.getStatus());
    }

    @Test
    public void testGetAsXML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmtslayers/AMSR2_Snow_Water_Equivalent.xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.dom(HttpTestUtils.istream(response));
        Assert.assertEquals((Object)"wmtsLayer", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)LAYER_NAME, (String)"/wmtsLayer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:4326", (String)"/wmtsLayer/srs", (Document)dom);
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)xp.evaluate("/wmtsLayer/nativeCRS", dom));
        WMTSLayerInfo wml = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        ReferencedEnvelope re = wml.getLatLonBoundingBox();
        XMLAssert.assertXpathEvaluatesTo((String)("" + re.getMinX()), (String)"/wmtsLayer/latLonBoundingBox/minx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + re.getMaxX()), (String)"/wmtsLayer/latLonBoundingBox/maxx", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + re.getMinY()), (String)"/wmtsLayer/latLonBoundingBox/miny", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)("" + re.getMaxY()), (String)"/wmtsLayer/latLonBoundingBox/maxy", (Document)dom);
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmtslayers/AMSR2_Snow_Water_Equivalent.json");
        JSONObject featureType = ((JSONObject)json).getJSONObject("wmtsLayer");
        Assert.assertNotNull((Object)featureType);
        Assert.assertEquals((Object)LAYER_NAME, (Object)featureType.get("name"));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326").toWKT(), (Object)featureType.get("nativeCRS"));
        Assert.assertEquals((Object)"EPSG:4326", (Object)featureType.get("srs"));
    }

    @Test
    public void testGetAsHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/workspaces/sf/wmtslayers/AMSR2_Snow_Water_Equivalent.html");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
    }

    @Test
    public void testGetWrongWMTSLayer() throws Exception {
        String ws = "sf";
        String wmts = "demo";
        String wl = "statessssss";
        String requestPath = "/rest/workspaces/" + ws + "/wmtslayers/" + wl + ".html";
        String requestPath2 = "/rest/workspaces/" + ws + "/wmtsstores/" + wmts + "/layers/" + wl + ".html";
        String exception = "No such cascaded wmts: " + ws + "," + wl;
        MockHttpServletResponse response = this.getAsServletResponse(requestPath);
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)exception));
        response = this.getAsServletResponse(requestPath + "?quietOnNotFound=true");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)exception)));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.emptyString());
        response = this.getAsServletResponse(requestPath2);
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)exception));
        response = this.getAsServletResponse(requestPath2 + "?quietOnNotFound=true");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.NOT_FOUND));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)exception)));
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.emptyString());
    }

    @Test
    public void testPut() throws Exception {
        String xml = "<wmtsLayer><title>Lots of states here</title></wmtsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent", xml, "text/xml");
        MatcherAssert.assertThat((Object)response, HttpTestUtils.hasStatus(HttpStatus.OK));
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"Lots of states here", (String)"/wmtsLayer/title", (Document)dom);
        WMTSLayerInfo wli = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        Assert.assertEquals((Object)"Lots of states here", (Object)wli.getTitle());
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        WMTSLayerInfo wli = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        wli.setEnabled(true);
        catalog.save((ResourceInfo)wli);
        wli = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        Assert.assertTrue((boolean)wli.isEnabled());
        boolean isAdvertised = wli.isAdvertised();
        String xml = "<wmtsLayer><title>Lots of states here</title></wmtsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        wli = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        Assert.assertTrue((boolean)wli.isEnabled());
        Assert.assertEquals((Object)isAdvertised, (Object)wli.isAdvertised());
    }

    @Test
    public void testPutNonExistant() throws Exception {
        String xml = "<wmtsLayer><title>new title</title></wmtsLayer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/bugsites", xml, "text/xml");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
        MatcherAssert.assertThat((Object)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent"), HttpTestUtils.hasStatus(HttpStatus.OK));
        Assert.assertNull((Object)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
    }

    @Test
    public void testDeleteNonExistant() throws Exception {
        Assert.assertEquals((long)404L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/NonExistent").getStatus());
    }

    void addLayer() {
        LayerInfo l = catalog.getLayerByName((Name)new NameImpl("sf", LAYER_NAME));
        if (l == null) {
            l = catalog.getFactory().createLayer();
            l.setResource(catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
            catalog.add(l);
        }
    }

    @Test
    public void testDeleteNonRecursive() throws Exception {
        this.addLayer();
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
        Assert.assertEquals((long)403L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent").getStatus());
    }

    @Test
    public void testDeleteRecursive() throws Exception {
        this.addLayer();
        Assert.assertNotNull((Object)catalog.getLayerByName("sf:AMSR2_Snow_Water_Equivalent"));
        Assert.assertNotNull((Object)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/workspaces/sf/wmtsstores/demo/layers/AMSR2_Snow_Water_Equivalent?recurse=true").getStatus());
        Assert.assertNull((Object)catalog.getLayerByName("sf:AMSR2_Snow_Water_Equivalent"));
        Assert.assertNull((Object)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class));
    }
}

