/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.lang.reflect.Type;
import java.util.Map;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.service.ServiceSettingsController;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSXStreamLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/services/wfs"}, produces={"application/json", "application/xml", "text/html"})
public class WFSSettingsController
extends ServiceSettingsController<WFSInfo> {
    @Autowired
    public WFSSettingsController(GeoServer geoServer) {
        super(geoServer, WFSInfo.class);
    }

    @PutMapping(value={"/settings", "/workspaces/{workspaceName}/settings"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void serviceSettingsPut(@RequestBody WFSInfo info, @PathVariable(required=false) String workspaceName) {
        super.serviceSettingsPut((ServiceInfo)info, workspaceName);
    }

    public String getTemplateName(Object object) {
        return "wfsSettings";
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WFSInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.setCallback(new XStreamPersister.Callback(){

            protected ServiceInfo getServiceObject() {
                ServiceInfo service;
                Map uriTemplateVars = WFSSettingsController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                if (workspace != null) {
                    WorkspaceInfo ws = WFSSettingsController.this.geoServer.getCatalog().getWorkspaceByName(workspace);
                    service = WFSSettingsController.this.geoServer.getService(ws, WFSInfo.class);
                } else {
                    service = WFSSettingsController.this.geoServer.getService(WFSInfo.class);
                }
                return service;
            }

            protected Class<WFSInfo> getObjectClass() {
                return WFSInfo.class;
            }
        });
        WFSXStreamLoader.initXStreamPersister((XStreamPersister)persister);
    }
}

