/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class LocalWFSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() {
        LocalWorkspace.remove();
        this.revertService(WFSInfo.class, "sf");
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        LocalWorkspace.set((WorkspaceInfo)ws);
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
        wfsInfo.setWorkspace(ws);
        geoServer.save((ServiceInfo)wfsInfo);
    }

    @After
    public void clearLocalWorkspace() throws Exception {
        LocalWorkspace.remove();
    }

    @Test
    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wfs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wfsinfo = (JSONObject)jsonObject.get("wfs");
        Assert.assertEquals((Object)"WFS", (Object)wfsinfo.get("name"));
        JSONObject workspace = (JSONObject)wfsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
        Assert.assertEquals((Object)"COMPLETE", (Object)wfsinfo.get("serviceLevel"));
        Assert.assertEquals((Object)"1000000", (Object)wfsinfo.get("maxFeatures").toString().trim());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wfs/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wfs", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wfs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wfs/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WFS", (String)"/wfs/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"COMPLETE", (String)"/wfs/serviceLevel", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1000000", (String)"/wfs/maxFeatures", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wfs/workspaces/sf/settings.html");
    }

    @Test
    public void testCreateAsJSON() throws Exception {
        this.removeLocalWorkspace();
        String input = "{'wfs': {'id' : 'wfs', 'name' : 'WFS', 'workspace': {'name': 'sf'},'enabled': 'true'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/workspaces/sf/settings", input, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON json = this.getAsJSON("/rest/services/wfs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wmsinfo = (JSONObject)jsonObject.get("wfs");
        Assert.assertEquals((Object)"WFS", (Object)wmsinfo.get("name"));
        JSONObject workspace = (JSONObject)wmsinfo.get("workspace");
        Assert.assertNotNull((Object)workspace);
        Assert.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    @Test
    public void testCreateAsXML() throws Exception {
        this.removeLocalWorkspace();
        String xml = "<wfs><id>wfs</id><workspace><name>sf</name></workspace><name>OGC:WFS</name><enabled>false</enabled></wfs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wfs/workspaces/sf/settings.xml");
        Assert.assertEquals((Object)"wfs", (Object)dom.getDocumentElement().getLocalName());
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wfs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"sf", (String)"/wfs/workspace/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"OGC:WFS", (String)"/wfs/name", (Document)dom);
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wfs': {'id':'wfs','workspace':{'name':'sf'},'enabled':'false','name':'WFS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/workspaces/sf/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wfs/workspaces/sf/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wfsinfo = (JSONObject)jsonObject.get("wfs");
        Assert.assertEquals((Object)"false", (Object)wfsinfo.get("enabled").toString().trim());
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wfs><id>wfs</id><workspace><name>sf</name></workspace><enabled>false</enabled></wfs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wfs/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wfs/enabled", (Document)dom);
    }

    @Test
    public void testPutFullAsXML() throws Exception {
        String xml = IOUtils.toString((InputStream)LocalWFSSettingsControllerTest.class.getResourceAsStream("wfs.xml"), (Charset)StandardCharsets.UTF_8);
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/workspaces/sf/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wfs/workspaces/sf/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wfs/enabled", (Document)dom);
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)200L, (long)this.deleteAsServletResponse("/rest/services/wfs/workspaces/sf/settings").getStatus());
        boolean thrown = false;
        try {
            this.getAsJSON("/rest/services/wfs/workspaces/sf/settings.json");
        }
        catch (JSONException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    private void removeLocalWorkspace() {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo ws = geoServer.getCatalog().getWorkspaceByName("sf");
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(ws, WFSInfo.class);
        geoServer.remove((ServiceInfo)wfsInfo);
    }
}

