/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.catalog;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.Filter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.filters.LoggingFilter;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geotools.util.URLs;
import org.h2.tools.DeleteDbFiles;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class DataStoreFileUploadWFSTest
extends CatalogRESTTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        NamespaceInfoImpl gsmlNamespace = new NamespaceInfoImpl();
        gsmlNamespace.setPrefix("gsml");
        gsmlNamespace.setURI("http://www.cgi-iugs.org/xml/GeoSciML/2");
        WorkspaceInfoImpl gsmlWorkspace = new WorkspaceInfoImpl();
        gsmlWorkspace.setName("gsml");
        this.getCatalog().add((NamespaceInfo)gsmlNamespace);
        this.getCatalog().add((WorkspaceInfo)gsmlWorkspace);
    }

    protected List<Filter> getFilters() {
        LoggingFilter filter = new LoggingFilter(null);
        filter.setEnabled(true);
        filter.setLogBodies(true);
        return Collections.singletonList(filter);
    }

    @Before
    public void removePdsDataStore() {
        this.removeStore("gs", "pds");
        this.removeStore("gs", "store with spaces");
    }

    @After
    public void cleanUpDbFiles() throws Exception {
        DeleteDbFiles.execute((String)"target", (String)"foo", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"pds", (boolean)true);
        DeleteDbFiles.execute((String)"target", (String)"chinese_poly", (boolean)true);
    }

    @Test
    public void testPropertyFileUpload() throws Exception {
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", bytes, "text/plain");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    @Test
    public void testPropertyFileUploadWithWorkspace() throws Exception {
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/sf/datastores/pds/file.properties", bytes, "text/plain");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=sf:pds");
        this.assertFeatures(dom, "sf");
    }

    @Test
    public void testPropertyFileUploadZipped() throws Exception {
        byte[] bytes = this.propertyFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.putNextEntry(new ZipEntry("pds.properties"));
        zout.write(bytes);
        zout.flush();
        zout.close();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", out.toByteArray(), "application/zip");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    byte[] propertyFile() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("ds.0='zero'|POINT(0 0)\n");
        writer.write("ds.1='one'|POINT(1 1)\n");
        writer.flush();
        return output.toByteArray();
    }

    void assertFeatures(Document dom) throws Exception {
        this.assertFeatures(dom, "gs");
    }

    void assertFeatures(Document dom, String ns) throws Exception {
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((long)2L, (long)dom.getElementsByTagName(ns + ":pds").getLength());
    }

    @Test
    public void testShapeFileUpload() throws Exception {
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/pds/file.shp", bytes, "application/zip");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    @Test
    public void testShapeFileUploadWithCharset() throws Exception {
        byte[] bytes = this.shpChineseZipAsBytes();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/datastores/chinese_poly/file.shp?charset=UTF-8", bytes, "application/zip");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        MockHttpServletResponse response2 = this.getAsServletResponse("wfs?request=getfeature&typename=gs:chinese_poly", "GB18030");
        Assert.assertTrue((boolean)response2.getContentAsString().contains("\u951f\u65a4\u62f7"));
    }

    byte[] shpZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip"));
    }

    byte[] shpChineseZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/chinese_poly.zip"));
    }

    byte[] shpMultiZipAsBytes() throws IOException {
        return this.toBytes(((Object)((Object)this)).getClass().getResourceAsStream("test-data/pdst.zip"));
    }

    byte[] toBytes(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShapeFileUploadExternal() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        File target = new File("target");
        File f = File.createTempFile("rest", "dir", target);
        try {
            f.delete();
            f.mkdir();
            File zip = new File(f, "pds.zip");
            IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip"), (OutputStream)new FileOutputStream(zip));
            org.geoserver.rest.util.IOUtils.inflate((ZipFile)new ZipFile(zip), (Resource)Files.asResource((File)f), null);
            MockHttpServletResponse resp = this.putAsServletResponse("/rest/workspaces/gs/datastores/pds/external.shp", URLs.fileToUrl((File)new File(f, "pds.shp")).toString(), "text/plain");
            Assert.assertEquals((long)201L, (long)resp.getStatus());
            dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
            this.assertFeatures(dom);
            this.getGeoServer().reload();
            resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.shp");
            Assert.assertEquals((long)200L, (long)resp.getStatus());
            Assert.assertEquals((Object)"application/zip", (Object)resp.getContentType());
            HashSet<String> entryNames = new HashSet<String>();
            try (ByteArrayInputStream bin = this.getBinaryInputStream(resp);
                 ZipInputStream zin = new ZipInputStream(bin);){
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    entryNames.add(entry.getName());
                }
            }
            Assert.assertTrue((boolean)entryNames.contains("pds.shp"));
            Assert.assertTrue((boolean)entryNames.contains("pds.shx"));
            Assert.assertTrue((boolean)entryNames.contains("pds.dbf"));
        }
        finally {
            FileUtils.deleteQuietly((File)f);
        }
    }

    @Test
    public void testShapeFileUploadIntoExisting() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "foo_h2"));
        String xml = "<dataStore> <name>foo_h2</name> <type>H2</type> <connectionParameters><namespace>" + MockData.DEFAULT_URI + "</namespace><database>target/foo</database><dbtype>h2</dbtype> </connectionParameters><workspace>gs</workspace></dataStore>";
        this.post("/rest/workspaces/gs/datastores", xml);
        DataStoreInfo ds = cat.getDataStoreByName("gs", "foo_h2");
        Assert.assertNotNull((Object)ds);
        Assert.assertTrue((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/foo_h2/file.shp", bytes, "application/zip");
        Assert.assertFalse((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    @Test
    public void testShapeFileUploadWithTarget() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "pds"));
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/pds/file.shp?target=h2", bytes, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "pds");
        Assert.assertNotNull((Object)ds);
        Assert.assertFalse((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    @Test
    @Ignore
    public void testShapeFileUploadWithSpaces() throws Exception {
        Catalog cat = this.getCatalog();
        Assert.assertNull((Object)cat.getDataStoreByName("gs", "store with spaces"));
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/store%20with%20spaces/file.shp", bytes, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "store with spaces");
        Assert.assertNull((Object)ds);
    }
}

