/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WFSSettingsControllerTest
extends CatalogRESTTestSupport {
    @Before
    public void revertChanges() {
        this.revertService(WFSInfo.class, null);
    }

    @Test
    public void testGetASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wfs/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wfsinfo = (JSONObject)jsonObject.get("wfs");
        Assert.assertEquals((Object)"true", (Object)wfsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WFS", (Object)wfsinfo.get("name"));
        Assert.assertEquals((Object)"COMPLETE", (Object)wfsinfo.get("serviceLevel"));
        Assert.assertEquals((Object)"1000000", (Object)wfsinfo.get("maxFeatures").toString().trim());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wfs/settings.xml");
        Assert.assertEquals((Object)"wfs", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wfs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WFS", (String)"/wfs/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"COMPLETE", (String)"/wfs/serviceLevel", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1000000", (String)"/wfs/maxFeatures", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wfs/settings.html");
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wfs': {'id':'wfs','enabled':'false','name':'WFS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wfs/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wfsinfo = (JSONObject)jsonObject.get("wfs");
        Assert.assertEquals((Object)"false", (Object)wfsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WFS", (Object)wfsinfo.get("name"));
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wfs><id>wfs</id><enabled>disabled</enabled><name>WFS</name><title>GeoServer Web Feature Service</title><maintainer>http://geoserver.org/comm</maintainer></wfs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wfs/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wfs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WFS", (String)"/wfs/name", (Document)dom);
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo i = (WFSInfo)geoServer.getService(WFSInfo.class);
        i.setEnabled(true);
        String xml = "<wfs><id>wfs</id><name>WFS</name><title>GeoServer Web Feature Service</title><maintainer>http://geoserver.org/comm</maintainer></wfs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wfs/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wfs/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wfs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WFS", (String)"/wfs/name", (Document)dom);
        i = (WFSInfo)geoServer.getService(WFSInfo.class);
        geoServer.save((ServiceInfo)i);
        Assert.assertTrue((boolean)i.isEnabled());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/services/wfs/settings").getStatus());
    }
}

