/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import java.lang.reflect.Type;
import java.util.Map;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.service.ServiceSettingsController;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WCSXStreamLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/services/wcs"}, produces={"application/json", "application/xml", "text/html"})
public class WCSSettingsController
extends ServiceSettingsController<WCSInfo> {
    @Autowired
    public WCSSettingsController(GeoServer geoServer) {
        super(geoServer, WCSInfo.class);
    }

    @PutMapping(value={"/settings", "/workspaces/{workspaceName}/settings"}, consumes={"application/json", "text/json", "application/xml", "text/xml"})
    public void serviceSettingsPut(@RequestBody WCSInfo info, @PathVariable(required=false) String workspaceName) {
        super.serviceSettingsPut((ServiceInfo)info, workspaceName);
    }

    public String getTemplateName(Object object) {
        return "wcsSettings";
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return WCSInfo.class.isAssignableFrom(methodParameter.getParameterType());
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        persister.setHideFeatureTypeAttributes();
        persister.setCallback(new XStreamPersister.Callback(){

            protected ServiceInfo getServiceObject() {
                ServiceInfo service;
                Map uriTemplateVars = WCSSettingsController.this.getURITemplateVariables();
                String workspace = (String)uriTemplateVars.get("workspaceName");
                if (workspace != null) {
                    WorkspaceInfo ws = WCSSettingsController.this.geoServer.getCatalog().getWorkspaceByName(workspace);
                    service = WCSSettingsController.this.geoServer.getService(ws, WCSInfo.class);
                } else {
                    service = WCSSettingsController.this.geoServer.getService(WCSInfo.class);
                }
                return service;
            }

            protected Class<WCSInfo> getObjectClass() {
                return WCSInfo.class;
            }
        });
        WCSXStreamLoader.initXStreamPersister((XStreamPersister)persister);
    }
}

