/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.service;

import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.rest.catalog.CatalogRESTTestSupport;
import org.geoserver.wcs.WCSInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WCSSettingsControllerTest
extends CatalogRESTTestSupport {
    @After
    public void revertChanges() {
        this.revertService(WCSInfo.class, null);
    }

    @Test
    public void testGetASJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/services/wcs/settings.json");
        JSONObject jsonObject = (JSONObject)json;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wcsinfo = (JSONObject)jsonObject.get("wcs");
        this.print((JSON)wcsinfo);
        Assert.assertEquals((Object)"WCS", (Object)wcsinfo.get("name"));
        Assert.assertEquals((Object)"true", (Object)wcsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"false", (Object)wcsinfo.get("verbose").toString().trim());
    }

    @Test
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/services/wcs/settings.xml");
        Assert.assertEquals((Object)"wcs", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("name").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wcs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WCS", (String)"/wcs/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wcs/verbose", (Document)dom);
    }

    @Test
    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/services/wcs/settings.html");
    }

    @Test
    public void testPutAsJSON() throws Exception {
        String json = "{'wcs': {'id':'wcs','enabled':'false','name':'WCS'}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wcs/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wcsinfo = (JSONObject)jsonObject.get("wcs");
        Assert.assertEquals((Object)"false", (Object)wcsinfo.get("enabled").toString().trim());
        Assert.assertEquals((Object)"WCS", (Object)wcsinfo.get("name"));
    }

    @Test
    public void testPutAsXML() throws Exception {
        String xml = "<wcs><id>wcs</id><enabled>false</enabled><name>WCS</name><title>GeoServer Web Coverage Service</title><maintainer>http://geoserver.org/comm</maintainer></wcs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wcs/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/wcs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WCS", (String)"/wcs/name", (Document)dom);
    }

    @Test
    public void testPutNonDestructive() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WCSInfo i = (WCSInfo)geoServer.getService(WCSInfo.class);
        i.setEnabled(true);
        geoServer.save((ServiceInfo)i);
        String xml = "<wcs><id>wcs</id><name>WCS</name><title>GeoServer Web Coverage Service</title><maintainer>http://geoserver.org/comm</maintainer></wcs>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/settings", xml, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document dom = this.getAsDOM("/rest/services/wcs/settings.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/wcs/enabled", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"WCS", (String)"/wcs/name", (Document)dom);
        i = (WCSInfo)geoServer.getService(WCSInfo.class);
        Assert.assertTrue((boolean)i.isEnabled());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertEquals((long)405L, (long)this.deleteAsServletResponse("/rest/services/wcs/settings").getStatus());
    }

    @Test
    public void testPutAsJSONInternationalTitle() throws Exception {
        String json = "{'wcs': {'id':'wcs','enabled':'false','name':'WCS', 'internationalTitle': {'en':'english WCS title','it': 'titolo italiano WCS'}}}";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/services/wcs/settings", json, "text/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSON jsonMod = this.getAsJSON("/rest/services/wcs/settings.json");
        JSONObject jsonObject = (JSONObject)jsonMod;
        Assert.assertNotNull((Object)jsonObject);
        JSONObject wcsinfo = (JSONObject)jsonObject.get("wcs");
        Assert.assertEquals((Object)"english WCS title", (Object)wcsinfo.getJSONObject("internationalTitle").getString("en").trim());
        Assert.assertEquals((Object)"titolo italiano WCS", (Object)wcsinfo.getJSONObject("internationalTitle").getString("it"));
    }
}

