/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.rest.RestException;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.rest.util.RESTUploadPathMapper;
import org.geoserver.security.FileAccessManager;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

public class RESTUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.rest.util");
    public static final String ROOT_KEY = "root";
    public static final String QUIET_ON_NOT_FOUND_KEY = "quietOnNotFound";
    static Set<String> ZIP_MIME_TYPES = new HashSet<String>();

    public static Resource handleBinUpload(String fileName, Resource directory, boolean deleteDirectoryContent, HttpServletRequest request) throws IOException {
        return RESTUtils.handleBinUpload(fileName, directory, deleteDirectoryContent, request, null);
    }

    public static Resource handleBinUpload(String fileName, Resource directory, boolean deleteDirectoryContent, HttpServletRequest request, String workSpace) throws IOException {
        Resource newFile;
        MediaType mediaType;
        StringBuilder itemPath = new StringBuilder(fileName);
        MediaType mediaType2 = mediaType = request.getContentType() == null ? null : MediaType.valueOf((String)request.getContentType());
        if (mediaType == null || !RESTUtils.isZipMediaType(mediaType)) {
            String baseName = FilenameUtils.getBaseName((String)fileName);
            String itemName = FilenameUtils.getName((String)fileName);
            HashMap<String, String> storeParams = new HashMap<String, String>();
            RESTUtils.remapping(workSpace, baseName, itemPath, itemName, storeParams);
        }
        if (Resources.exists((Resource)(newFile = directory.get(itemPath.toString())))) {
            if (deleteDirectoryContent) {
                for (Resource file : directory.list()) {
                    file.delete();
                }
            } else {
                newFile.delete();
            }
        }
        try (OutputStream os = newFile.out();){
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)os);
        }
        return newFile;
    }

    public static Resource handleURLUpload(String fileName, String workSpace, Resource directory, HttpServletRequest request) throws IOException, URLCheckerException {
        MediaType mediaType;
        StringBuilder itemPath = new StringBuilder(fileName);
        MediaType mediaType2 = mediaType = request.getContentType() != null ? MediaType.valueOf((String)request.getContentType()) : null;
        if (mediaType == null || !RESTUtils.isZipMediaType(mediaType)) {
            String baseName = FilenameUtils.getBaseName((String)fileName);
            HashMap<String, String> storeParams = new HashMap<String, String>();
            String itemName = FilenameUtils.getName((String)fileName);
            RESTUtils.remapping(workSpace, baseName, itemPath, itemName, storeParams);
        }
        Resource newFile = directory.get(itemPath.toString());
        ServletInputStream inStream = request.getInputStream();
        String stringURL = IOUtils.getStringFromStream((InputStream)inStream);
        URL fileURL = new URL(stringURL);
        IOUtils.upload(fileURL, newFile);
        return newFile;
    }

    public static Resource handleEXTERNALUpload(HttpServletRequest request) throws IOException, URLCheckerException {
        File inputFile;
        String stringURL;
        try (ServletInputStream inStream = request.getInputStream();){
            stringURL = IOUtils.getStringFromStream((InputStream)inStream);
            inputFile = new File(stringURL);
            if (!inputFile.exists()) {
                URL fileURL = new URL(stringURL);
                inputFile = IOUtils.URLToFile(fileURL);
            }
        }
        if (inputFile == null || !inputFile.exists()) {
            throw new RestException("Failed to locate the input file " + stringURL, HttpStatus.BAD_REQUEST);
        }
        if (!inputFile.canRead()) {
            throw new RestException("Input file is not readable, check filesystem permissions: " + stringURL, HttpStatus.BAD_REQUEST);
        }
        return Files.asResource((File)inputFile);
    }

    public static boolean isZipMediaType(HttpServletRequest request) {
        return ZIP_MIME_TYPES.contains(request.getContentType());
    }

    public static boolean isZipMediaType(MediaType mediaType) {
        return ZIP_MIME_TYPES.contains(mediaType.toString());
    }

    public static void unzipFile(Resource zipFile, Resource outputDirectory) throws IOException {
        RESTUtils.unzipFile(zipFile, outputDirectory, null, null, null, false);
    }

    public static void unzipFile(Resource zipFile, Resource outputDirectory, String workspace, String store, List<Resource> files, boolean external) throws IOException {
        if (outputDirectory == null) {
            outputDirectory = zipFile.parent();
        }
        try (ZipFile archive = new ZipFile(zipFile.file());){
            IOUtils.inflate(archive, outputDirectory, null, workspace, store, files, external, true);
            zipFile.delete();
        }
    }

    public static String getAttribute(HttpServletRequest request, String name) {
        Object o = request.getAttribute(name);
        return RESTUtils.decode(o);
    }

    public static String getQueryStringValue(HttpServletRequest request, String key) {
        String value = request.getParameter(key);
        return RESTUtils.decode(value);
    }

    static String decode(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getItem(String workspaceName, String storeName, Catalog catalog, String key) {
        String item = RESTUtils.extractMapItem(RESTUtils.loadMapfromStore(storeName, catalog), key);
        if (item == null) {
            item = RESTUtils.extractMapItem(RESTUtils.loadMapfromWorkSpace(workspaceName, catalog), key);
        }
        if (item == null) {
            item = RESTUtils.extractMapItem(RESTUtils.loadMapFromGlobal(), key);
        }
        return item;
    }

    public static MetadataMap loadMapfromStore(String storeName, Catalog catalog) {
        StoreInfo storeInfo = catalog.getStoreByName(storeName, CoverageStoreInfo.class);
        if (storeInfo == null) {
            storeInfo = catalog.getStoreByName(storeName, DataStoreInfo.class);
        }
        if (storeInfo != null) {
            return storeInfo.getMetadata();
        }
        return null;
    }

    public static MetadataMap loadMapfromWorkSpace(String workspaceName, Catalog catalog) {
        WorkspaceInfo wsInfo = catalog.getWorkspaceByName(workspaceName);
        if (wsInfo != null) {
            GeoServer gs = (GeoServer)GeoServerExtensions.bean(GeoServer.class);
            SettingsInfo info = gs.getSettings(wsInfo);
            return info != null ? info.getMetadata() : null;
        }
        return null;
    }

    public static MetadataMap loadMapFromGlobal() {
        GeoServerInfo gsInfo = ((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal();
        if (gsInfo != null) {
            SettingsInfo info = gsInfo.getSettings();
            return info != null ? info.getMetadata() : null;
        }
        return null;
    }

    public static String extractMapItem(MetadataMap map, String key) {
        String item;
        if (map != null && !map.isEmpty() && (item = (String)map.get(key, String.class)) != null && !item.isEmpty()) {
            return item;
        }
        return null;
    }

    public static String getRootDirectory(String workspaceName, String storeName, Catalog catalog) {
        File rootFile;
        String rootDir;
        FileAccessManager fam = FileAccessManager.lookupFileAccessManager();
        if (fam.getSandbox() != null) {
            File root = fam.getSandbox();
            rootDir = root.getAbsolutePath();
        } else {
            rootDir = RESTUtils.getItem(workspaceName, storeName, catalog, ROOT_KEY);
        }
        if (rootDir != null && (rootFile = new File(rootDir)).isAbsolute()) {
            if (!rootFile.exists()) {
                if (!rootFile.mkdirs()) {
                    rootFile.delete();
                    return null;
                }
            } else if (!rootFile.isDirectory()) {
                LOGGER.info(rootDir + " ROOT path is not a directory");
                return null;
            }
        }
        return rootDir;
    }

    public static void remapping(String workspace, String store, StringBuilder itemPath, String initialFileName, Map<String, String> storeParams) throws IOException {
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapItemPath(workspace, store, storeParams, itemPath, initialFileName);
        }
    }

    public static void unzipInputStream(InputStream in, File outputDirectory) throws IOException {
        org.geoserver.util.IOUtils.decompress((InputStream)in, (File)outputDirectory);
    }

    public static Resource createUploadRoot(Catalog catalog, String workspaceName, String storeName, boolean isPost) throws IOException {
        CoverageStoreInfo coverage;
        Resource directory = null;
        if (isPost && storeName != null && (coverage = catalog.getCoverageStoreByName(storeName)) != null && (workspaceName == null || coverage.getWorkspace().getName().equalsIgnoreCase(workspaceName))) {
            String url = coverage.getURL();
            String path = url.startsWith("file:") ? URLs.urlToFile((URL)new URL(url)).getPath() : url;
            directory = Resources.fromPath((String)path, (Resource)catalog.getResourceLoader().get(""));
        }
        if (directory == null) {
            directory = catalog.getResourceLoader().get(Paths.path((String[])new String[]{"data", workspaceName, storeName}));
        }
        StringBuilder root = new StringBuilder(directory.path());
        HashMap<String, String> storeParams = new HashMap<String, String>();
        List mappers = GeoServerExtensions.extensions(RESTUploadPathMapper.class);
        for (RESTUploadPathMapper mapper : mappers) {
            mapper.mapStorePath(root, workspaceName, storeName, storeParams);
        }
        directory = Resources.fromPath((String)root.toString());
        return directory;
    }

    static {
        ZIP_MIME_TYPES.add("application/zip");
        ZIP_MIME_TYPES.add("multipart/x-zip");
        ZIP_MIME_TYPES.add("application/x-zip-compressed");
    }
}

