/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import java.io.IOException;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.xml.sax.EntityResolver;

public class StyleReaderConverter
extends BaseMessageConverter<Style> {
    private final Version version;
    private final StyleHandler handler;
    private final EntityResolver entityResolver;

    public StyleReaderConverter(String mimeType, Version version, StyleHandler handler, EntityResolver entityResolver) {
        super(MediaType.valueOf((String)mimeType));
        this.handler = handler;
        this.version = version;
        this.entityResolver = entityResolver;
    }

    protected boolean supports(Class<?> clazz) {
        return Style.class.isAssignableFrom(clazz);
    }

    @Override
    public Style readInternal(Class<? extends Style> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        StyledLayerDescriptor sld = this.handler.parse((Object)inputMessage.getBody(), this.version, null, this.entityResolver);
        return Styles.style((StyledLayerDescriptor)sld);
    }

    protected boolean canWrite(MediaType mediaType) {
        return false;
    }
}

