/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipFile;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.util.IOUtils;
import org.geoserver.util.ZipTestUtil;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IOUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder(new File("target"));
    private static URLChecker geoserverAboutChecker = new URLChecker(){

        public String getName() {
            return "aboutGeoServer";
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean confirm(String s) {
            return s.startsWith("https://geoserver.org/about");
        }
    };
    private static URLChecker tmpChecker = new URLChecker(){
        String tmpDir = new File(System.getProperty("java.io.tmpdir")).getAbsoluteFile().toURI().toString();

        public String getName() {
            return "java.io.tmpdir";
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean confirm(String s) {
            return s.startsWith(this.tmpDir);
        }
    };

    @BeforeClass
    public static void setupURLCheckers() throws Exception {
        URLCheckers.register((URLChecker)geoserverAboutChecker);
        URLCheckers.register((URLChecker)tmpChecker);
    }

    @AfterClass
    public static void teardownURLCheckers() throws Exception {
        URLCheckers.deregister((URLChecker)geoserverAboutChecker);
        URLCheckers.deregister((URLChecker)tmpChecker);
    }

    @Test
    public void testInflateBadEntryName() throws IOException {
        File destDir = this.temp.newFolder("d1").toPath().toFile();
        destDir.mkdirs();
        Resource directory = new GeoServerResourceLoader(destDir).get("");
        File file = ZipTestUtil.initZipSlipFile((File)this.temp.newFile("d1.zip"));
        try {
            IOUtils.inflate((ZipFile)new ZipFile(file), (Resource)directory, null, null, null, null, (boolean)false, (boolean)false);
            Assert.fail((String)"Expected decompression to fail");
        }
        catch (IOException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Entry is outside of the target directory"));
        }
    }

    @Test
    public void testURLToFile() throws Exception {
        File file = File.createTempFile("sample", "txt");
        URL fileURL = file.toURI().toURL();
        Assert.assertEquals((Object)file, (Object)IOUtils.URLToFile((URL)fileURL));
        File home = new File(System.getProperty("user.home"));
        URL homeURL = home.toURI().toURL();
        Assert.assertNull((Object)IOUtils.URLToFile((URL)homeURL));
    }

    @Test
    public void testUpload() throws IOException {
        File destDir = this.temp.newFolder("upload").toPath().toFile();
        destDir.mkdirs();
        Resource newFile = new GeoServerResourceLoader(destDir).get("about.html");
        URL uploadURL = new URL("https://geoserver.org/about");
        IOUtils.upload((URL)uploadURL, (Resource)newFile);
        Assert.assertSame((String)"uploaded", (Object)newFile.getType(), (Object)Resource.Type.RESOURCE);
        URL osgeoURL = new URL("https://geoserver.org/img/osgeo-logo.png");
        Resource logoFile = new GeoServerResourceLoader(destDir).get("osgeo-logo.png");
        try {
            IOUtils.upload((URL)osgeoURL, (Resource)logoFile);
            Assert.fail((String)"geoserver.org blocked");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertSame((String)"blocked", (Object)logoFile.getType(), (Object)Resource.Type.UNDEFINED);
    }
}

