/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletResponse;

public class RESTDispatcherCallbackTest
extends GeoServerSystemTestSupport {
    DispatcherCallback callback;

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void prepareCallback() throws Exception {
        this.callback = (DispatcherCallback)EasyMock.createMock(DispatcherCallback.class);
        GeoServerExtensionsHelper.init((ApplicationContext)applicationContext);
        GeoServerExtensionsHelper.singleton((String)"testCallback", (Object)this.callback, (Class[])new Class[]{DispatcherCallback.class});
    }

    @Test
    public void testCallback() throws Exception {
        this.callback.init((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.dispatched((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject(), EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.finished((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.callback});
        MockHttpServletResponse response = this.getAsServletResponse("/rest/index.html");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{this.callback});
    }

    @Test
    public void testCallbackException() throws Exception {
        this.callback.init((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.dispatched((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject(), EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.exception((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject(), (Exception)EasyMock.anyObject());
        EasyMock.expectLastCall();
        this.callback.finished((HttpServletRequest)EasyMock.anyObject(), (HttpServletResponse)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.callback});
        this.getAsServletResponse("/rest/exception?code=400&message=error");
        EasyMock.verify((Object[])new Object[]{this.callback});
    }
}

