/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.List;
import javax.servlet.Filter;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class IndexControllerTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    protected List<Filter> getFilters() {
        return List.of((Filter)GeoServerExtensions.bean(GeoServerSecurityFilterChainProxy.class));
    }

    @Test
    public void testRootWithoutExtensionAdministrator() throws Exception {
        this.doTestIndex("admin", "geoserver", "/rest");
    }

    @Test
    public void testRootWithExtensionAdministrator() throws Exception {
        this.doTestIndex("admin", "geoserver", "/rest.html");
    }

    @Test
    public void testIndexWithoutExtensionAdministrator() throws Exception {
        this.doTestIndex("admin", "geoserver", "/rest/index");
    }

    @Test
    public void testIndexWithExtensionAdministrator() throws Exception {
        this.doTestIndex("admin", "geoserver", "/rest/index.html");
    }

    @Test
    public void testRootWithoutExtensionAnonymous() throws Exception {
        this.doTestIndex(null, null, "/rest");
    }

    @Test
    public void testRootWithExtensionAnonymous() throws Exception {
        this.doTestIndex(null, null, "/rest.html");
    }

    @Test
    public void testIndexWithoutExtensionAnonymous() throws Exception {
        this.doTestIndex(null, null, "/rest/index");
    }

    @Test
    public void testIndexWithExtensionAnonymous() throws Exception {
        this.doTestIndex(null, null, "/rest/index.html");
    }

    private void doTestIndex(String username, String password, String path) throws Exception {
        this.setRequestAuth(username, password);
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getContentAsString();
        if (username != null) {
            Assert.assertEquals((long)200L, (long)response.getStatus());
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"Geoserver Configuration API"));
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"<a href="));
        } else {
            Assert.assertEquals((long)401L, (long)response.getStatus());
            Assert.assertEquals((Object)"", (Object)content);
        }
    }
}

