/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.rest.LoggingCapturer;
import org.geoserver.rest.RestControllerAdvice;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ExceptionHandlingTest
extends GeoServerSystemTestSupport {
    private Level level;

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void disableRestControllerAdviceLogging() {
        this.level = RestControllerAdvice.LOGGER.getLevel();
        RestControllerAdvice.LOGGER.setLevel(Level.OFF);
    }

    @After
    public void enableRestControllerAdviceLogging() {
        RestControllerAdvice.LOGGER.setLevel(this.level);
    }

    @After
    public void resetQuietOnNotFountConfig() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().getMetadata().remove((Object)"quietOnNotFound");
        this.getGeoServer().save(global);
    }

    @Test
    public void testRestException() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/exception?code=400&message=error");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String txt = response.getContentAsString();
        Assert.assertEquals((Object)"error", (Object)txt);
    }

    @Test
    public void testInternalError() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/error");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String txt = response.getContentAsString();
        Assert.assertEquals((Object)"An internal error occurred", (Object)txt);
    }

    @Test
    public void testNotFound() throws Exception {
        MockHttpServletResponse response = this.assertNotFound("/rest/notfound");
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String txt = response.getContentAsString();
        Assert.assertEquals((Object)"I'm not there", (Object)txt);
    }

    @Test
    public void testQuietOnNotFoundLogging_default() throws Exception {
        String path = "/rest/notfound";
        List<String> loggingMessages = this.captureNotFoundLogs(path);
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    @Test
    public void testQuietOnNotFoundLogging_queryParam() throws Exception {
        String path = "/rest/notfound?quietOnNotFound=true";
        List<String> loggingMessages = this.captureNotFoundLogs(path);
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        path = "/rest/notfound?quietOnNotFound=false";
        loggingMessages = this.captureNotFoundLogs(path);
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    @Test
    public void testQuietOnNotFoundLogging_globalSettings() throws Exception {
        GeoServer geoserver = super.getGeoServer();
        String path = "/rest/notfound";
        List<String> loggingMessages = this.captureNotFoundLogs("/rest/notfound");
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        GeoServerInfo global = geoserver.getGlobal();
        global.getSettings().getMetadata().put("quietOnNotFound", (Serializable)Boolean.valueOf(false));
        geoserver.save(global);
        loggingMessages = this.captureNotFoundLogs("/rest/notfound");
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        global = geoserver.getGlobal();
        global.getSettings().getMetadata().put("quietOnNotFound", (Serializable)Boolean.valueOf(true));
        geoserver.save(global);
        loggingMessages = this.captureNotFoundLogs("/rest/notfound");
        MatcherAssert.assertThat(loggingMessages, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> captureNotFoundLogs(String path) throws Exception {
        Logger logger = RestControllerAdvice.LOGGER;
        logger.setLevel(Level.SEVERE);
        LoggingCapturer capturer = new LoggingCapturer(RestControllerAdvice.LOGGER).start();
        try {
            this.assertNotFound(path);
        }
        finally {
            capturer.stop();
        }
        return capturer.getMessages();
    }

    private MockHttpServletResponse assertNotFound(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        return response;
    }

    @Test
    public void testNullPointerException() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/npe");
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        String txt = response.getContentAsString();
        Assert.assertEquals((Object)"", (Object)txt);
    }
}

