/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.util;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.rest.util.RESTUploadPathMapperImpl;
import org.geoserver.rest.util.RESTUtils;
import org.geoserver.security.FileAccessManager;

public class RESTUploadExternalPathMapper
extends RESTUploadPathMapperImpl
implements ExtensionPriority {
    public RESTUploadExternalPathMapper(Catalog catalog) {
        super(catalog);
    }

    @Override
    public void mapStorePath(StringBuilder rootDir, String workspace, String store, Map<String, String> storeParams) throws IOException {
        FileAccessManager fam;
        String externalRoot = RESTUtils.getRootDirectory(workspace, store, this.catalog);
        if (externalRoot == null || externalRoot.isEmpty()) {
            return;
        }
        rootDir.setLength(0);
        rootDir.append(externalRoot);
        if (workspace != null && !workspace.isEmpty()) {
            rootDir.append(File.separator);
            rootDir.append(workspace);
        }
        if (store != null && !store.isEmpty()) {
            rootDir.append(File.separator);
            rootDir.append(store);
        }
        if (!(fam = FileAccessManager.lookupFileAccessManager()).checkAccess(new File(rootDir.toString()))) {
            throw new IOException("Access to the external root directory is not allowed: " + rootDir);
        }
    }

    public int getPriority() {
        return 0;
    }
}

