/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ResourceNotification
implements Serializable {
    private static final long serialVersionUID = 1689657047251329584L;
    private final String path;
    private final Kind kind;
    private final List<Event> delta;
    private final long timestamp;

    public static List<Event> delta(File baseDirectory, Collection<String> created, Collection<String> removed, Collection<String> modified) {
        created = created == null ? Collections.emptyList() : created;
        removed = removed == null ? Collections.emptyList() : removed;
        Collection<Object> collection = modified = modified == null ? Collections.emptyList() : modified;
        if (created.isEmpty() && removed.isEmpty() && modified.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Event> events = new ArrayList<Event>(created.size() + removed.size() + modified.size());
        created.stream().map(relativePath -> new Event((String)relativePath, Kind.ENTRY_CREATE)).forEach(events::add);
        removed.stream().map(relativePath -> new Event((String)relativePath, Kind.ENTRY_DELETE)).forEach(events::add);
        modified.stream().map(relativePath -> new Event((String)relativePath, Kind.ENTRY_MODIFY)).forEach(events::add);
        return events;
    }

    ResourceNotification(String path, Kind kind, long timestamp) {
        this.path = path;
        this.kind = kind;
        this.delta = Collections.emptyList();
        this.timestamp = timestamp;
    }

    public ResourceNotification(String path, Kind kind, long timestamp, List<Event> delta) {
        this.path = path;
        this.kind = kind;
        this.delta = delta != null ? Collections.unmodifiableList(delta) : Collections.emptyList();
        this.timestamp = timestamp;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getPath() {
        return this.path;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Event> events() {
        return this.delta;
    }

    public String toString() {
        return "ResourceNotification [path=" + this.path + ", kind=" + this.kind + ", delta=" + this.delta + ", timestamp=" + this.timestamp + "]";
    }

    public static class Event
    implements Serializable {
        private static final long serialVersionUID = 2852962095949861322L;
        final String path;
        final Kind kind;

        public Event(String path, Kind kind) {
            this.path = path;
            this.kind = kind;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getPath() {
            return this.path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            if (this.kind != other.kind) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            return "Event [path=" + this.path + ", kind=" + this.kind + "]";
        }
    }

    public static enum Kind {
        ENTRY_CREATE,
        ENTRY_DELETE,
        ENTRY_MODIFY;

    }
}

