/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.geoserver.platform.resource.FilePaths;
import org.geoserver.platform.resource.Paths;
import org.junit.Assert;
import org.junit.Test;

public class FilePathsTest {
    @Test
    public void isAbsolutePath() {
        Assert.assertFalse((String)"data directory relative", (boolean)FilePaths.isAbsolute((String)"data/tasmania/roads.shp"));
        Assert.assertTrue((String)"linux absolute", (boolean)FilePaths.isAbsolute((String)"/srv/gis/cadaster/district.geopkg", (boolean)false));
        Assert.assertTrue((String)"windows drive absolute", (boolean)FilePaths.isAbsolute((String)"D:/gis/cadaster/district.geopkg", (boolean)true));
        Assert.assertFalse((String)"windows drive relative", (boolean)FilePaths.isAbsolute((String)"D:fail.shp", (boolean)true));
    }

    @Test
    public void naming() throws IOException {
        File home = new File(System.getProperty("user.home")).getCanonicalFile();
        String absolutePath = Paths.convert((String)home.getPath());
        Assert.assertTrue((String)"home", (boolean)FilePaths.isAbsolute((String)absolutePath));
        String root = (String)FilePaths.names((String)absolutePath).get(0);
        Assert.assertTrue((String)("system root '" + root + "'"), (boolean)FilePaths.isAbsolute((String)root));
    }

    @Test
    public void roundTripFileTests() throws IOException {
        File home = new File(System.getProperty("user.home")).getCanonicalFile();
        File directory = new File(home, "directory");
        File file = new File(directory, "file");
        this.absolutePathCheck(home);
        this.absolutePathCheck(directory);
        this.absolutePathCheck(file);
        File base = new File(home, "data");
        this.relativePathCheck(base, new File("folder"));
        this.relativePathCheck(base, new File(new File("folder"), "file"));
    }

    public void absolutePathCheck(File file) {
        String filePath = file.getPath();
        String path1 = Paths.convert((String)filePath);
        Assert.assertTrue((String)("absolute: " + path1), (boolean)FilePaths.isAbsolute((String)path1));
        List names = FilePaths.names((String)path1);
        Assert.assertTrue((String)("absolute: " + (String)names.get(0)), (boolean)FilePaths.isAbsolute((String)((String)names.get(0))));
        String path2 = Paths.toPath((List)names);
        Assert.assertTrue((String)("absolute:" + path2), (boolean)FilePaths.isAbsolute((String)path2));
        File file2 = FilePaths.toFile(null, (String)path2);
        Assert.assertEquals((String)file2.getName(), (Object)file, (Object)file2);
    }

    public void relativePathCheck(File base, File file) {
        String path1 = Paths.convert((File)base, (File)file);
        Assert.assertFalse((String)("absolute: " + path1), (boolean)FilePaths.isAbsolute((String)path1));
        List names = Paths.names((String)path1);
        Assert.assertFalse((String)("absolute: " + (String)names.get(0)), (boolean)FilePaths.isAbsolute((String)((String)names.get(0))));
        String path2 = Paths.toPath((List)names);
        Assert.assertFalse((String)("absolute:" + path2), (boolean)FilePaths.isAbsolute((String)path2));
        File file2 = FilePaths.toFile((File)base, (String)path2);
        Assert.assertTrue((String)("absolute:" + file2.getPath()), (boolean)file2.isAbsolute());
        Assert.assertEquals((String)file2.getName(), (Object)new File(base, file.getPath()), (Object)file2);
    }
}

