/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTestUtil {
    private OutputStream showXML = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private NamespaceContext namespaceContext;

    private void regenerateContext() {
        this.namespaceContext = new SimpleNamespaceContext(this.namespaces);
    }

    public XmlTestUtil() {
        this.regenerateContext();
    }

    public void setShowXML(OutputStream showXML) {
        this.showXML = showXML;
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        this.regenerateContext();
    }

    public Matcher<Document> hasOneNode(String xPath, Matcher<? super Node> matcher) {
        return this.hasNodes(xPath, (Matcher<? extends Iterable<Node>>)Matchers.contains(matcher));
    }

    public Matcher<Document> hasOneNode(String xPath) {
        return this.hasOneNode(xPath, (Matcher<? super Node>)Matchers.any(Node.class));
    }

    public Matcher<Document> hasNode(String xPath, Matcher<Node> matcher) {
        return this.hasNodes(xPath, (Matcher<? extends Iterable<Node>>)Matchers.hasItem(matcher));
    }

    public Matcher<Document> hasNode(String xPath) {
        return this.hasNode(xPath, (Matcher<Node>)Matchers.any(Node.class));
    }

    public Matcher<Document> hasNodes(final String xPath, final Matcher<? extends Iterable<Node>> matcher) {
        return new BaseMatcher<Document>(){

            public boolean matches(Object item) {
                XpathEngine engine = XMLUnit.newXpathEngine();
                engine.setNamespaceContext(XmlTestUtil.this.namespaceContext);
                try {
                    List<Node> nodes = XmlTestUtil.nodeCollection(engine.getMatchingNodes(xPath, (Document)item));
                    return matcher.matches(nodes);
                }
                catch (XpathException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("Document where the list of nodes matching ").appendValue((Object)xPath).appendText(" is ").appendDescriptionOf((SelfDescribing)matcher);
            }

            public void describeMismatch(Object item, Description description) {
                XpathEngine engine = XMLUnit.newXpathEngine();
                engine.setNamespaceContext(XmlTestUtil.this.namespaceContext);
                try {
                    List<Node> nodes = XmlTestUtil.nodeCollection(engine.getMatchingNodes(xPath, (Document)item));
                    matcher.describeMismatch(nodes, description);
                    if (XmlTestUtil.this.showXML != null) {
                        XmlTestUtil.printDom((Document)item, XmlTestUtil.this.showXML);
                    }
                }
                catch (XpathException e) {
                    description.appendText("exception occured: ").appendText(e.getMessage());
                }
            }
        };
    }

    public static List<Node> nodeCollection(final NodeList nl) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nl.item(index);
            }

            @Override
            public int size() {
                return nl.getLength();
            }
        };
    }

    public static void printDom(Node dom, OutputStream os) {
        PrintWriter w = new PrintWriter(os);
        try {
            TransformerFactory fact = TransformerFactory.newInstance();
            Transformer trans = fact.newTransformer();
            trans.transform(new DOMSource(dom), new StreamResult(new OutputStreamWriter(os)));
        }
        catch (TransformerException e) {
            w.println("An error ocurred while transforming the given DOM:");
            e.printStackTrace(w);
        }
    }
}

