/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.util;

import org.easymock.EasyMock;
import org.geoserver.platform.util.GeoServerPropertyFactoryBean;
import org.geoserver.util.PropertyRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeoServerPropertyFactoryBeanTest {
    public static final String PROPERTY_NAME = "FOO";
    @Rule
    public PropertyRule foo = PropertyRule.system("FOO");
    GeoServerPropertyFactoryBean<String> factory;

    @Before
    public void setUp() {
        this.factory = new GeoServerPropertyFactoryBean<String>(PROPERTY_NAME){

            protected String createInstance(String propertyValue) {
                if (propertyValue.equals("UNKNOWN")) {
                    return null;
                }
                return "Bean: " + propertyValue;
            }

            public Class<?> getObjectType() {
                return String.class;
            }
        };
        ApplicationContext context = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.replay((Object[])new Object[]{context});
        this.factory.setApplicationContext(context);
    }

    @Test
    public void testGetBean() throws Exception {
        this.factory.setDefaultValue("Default");
        this.foo.setValue("testValue1");
        MatcherAssert.assertThat((Object)((String)this.factory.createInstance()), (Matcher)Matchers.equalTo((Object)"Bean: testValue1"));
    }

    @Test
    public void testGetDefault() throws Exception {
        this.factory.setDefaultValue("Default");
        MatcherAssert.assertThat((Object)((String)this.factory.createInstance()), (Matcher)Matchers.equalTo((Object)"Bean: Default"));
    }

    @Test
    public void testGetUnsetDefault() throws Exception {
        Assert.assertThrows(IllegalStateException.class, () -> this.factory.createInstance());
    }

    @Test
    public void testGetBadDefault() throws Exception {
        Assert.assertThrows(IllegalStateException.class, () -> {
            this.factory.setDefaultValue("UNKNOWN");
            this.factory.createInstance();
        });
    }

    @Test
    public void testFallBackToDefault() throws Exception {
        this.factory.setDefaultValue("Default");
        this.foo.setValue("UNKNOWN");
        MatcherAssert.assertThat((Object)((String)this.factory.createInstance()), (Matcher)Matchers.equalTo((Object)"Bean: Default"));
    }
}

